/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.util.repository;

import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import org.osgi.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadListenerPromise {
    private static final Logger logger = LoggerFactory.getLogger(DownloadListenerPromise.class);
    final RepositoryPlugin.DownloadListener[] dls;
    final Promise<File> promise;
    private final String task;
    private File linked;

    public DownloadListenerPromise(Reporter r, String task, Promise<File> promise, RepositoryPlugin.DownloadListener ... downloadListeners) {
        Reporter reporter = Slf4jReporter.getAlternative(DownloadListenerPromise.class, r);
        this.task = task;
        this.promise = promise;
        this.dls = downloadListeners;
        logger.debug("{}: starting", (Object)task);
        promise.thenAccept(file -> {
            if (file == null) {
                throw new FileNotFoundException("Download failed");
            }
            logger.debug("{}: success {}", (Object)this, file);
            if (this.linked != null) {
                IO.createSymbolicLinkOrCopy(this.linked, file);
            }
            for (RepositoryPlugin.DownloadListener dl : this.dls) {
                try {
                    dl.success((File)file);
                }
                catch (Throwable e) {
                    reporter.warning("%s: Success callback failed to %s: %s", this, dl, e);
                }
            }
        }).onFailure(failure -> {
            logger.debug("{}: failure", (Object)this, failure);
            String reason = Exceptions.toString(failure);
            for (RepositoryPlugin.DownloadListener dl : this.dls) {
                try {
                    dl.failure(null, reason);
                }
                catch (Throwable e) {
                    reporter.warning("%s: Fail callback failed to %s: %s", this, dl, e);
                }
            }
        });
    }

    public String toString() {
        return this.task;
    }

    public void linkTo(File linked) {
        this.linked = linked;
    }
}

