/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.Signatures;
import aQute.bnd.signatures.TypeArgument;
import aQute.lib.stringrover.StringRover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class SimpleClassTypeSignature {
    static final SimpleClassTypeSignature[] EMPTY = new SimpleClassTypeSignature[0];
    public final String identifier;
    public final TypeArgument[] typeArguments;

    SimpleClassTypeSignature(String identifier, TypeArgument[] typeArguments) {
        this.identifier = identifier;
        this.typeArguments = typeArguments;
    }

    public int hashCode() {
        int result = 31 + this.identifier.hashCode();
        result = result * 31 + Arrays.hashCode(this.typeArguments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleClassTypeSignature)) {
            return false;
        }
        SimpleClassTypeSignature other = (SimpleClassTypeSignature)obj;
        return Objects.equals(this.identifier, other.identifier) && Arrays.equals(this.typeArguments, other.typeArguments);
    }

    public String toString() {
        if (Signatures.isEmpty(this.typeArguments)) {
            return this.identifier;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier).append('<');
        for (TypeArgument t : this.typeArguments) {
            sb.append(t);
        }
        return sb.append('>').toString();
    }

    static SimpleClassTypeSignature parseSimpleClassTypeSignature(StringRover signature) {
        int offset = 0;
        char c = signature.charAt(offset);
        while (c != '.' && c != ';' && c != '<') {
            c = signature.charAt(++offset);
        }
        String identifier = Signatures.intern(signature.substring(0, offset));
        signature.increment(offset);
        if (signature.charAt(0) != '<') {
            return new SimpleClassTypeSignature(identifier, TypeArgument.EMPTY);
        }
        signature.increment();
        ArrayList<TypeArgument> list = new ArrayList<TypeArgument>();
        do {
            TypeArgument item = TypeArgument.parseTypeArgument(signature);
            list.add(item);
        } while (signature.charAt(0) != '>');
        signature.increment();
        return new SimpleClassTypeSignature(identifier, list.toArray(TypeArgument.EMPTY));
    }
}

