/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.Signature;
import aQute.bnd.signatures.Signatures;
import aQute.bnd.signatures.ThrowsSignature;
import aQute.bnd.signatures.TypeParameter;
import aQute.bnd.signatures.TypeVariableSignature;
import aQute.bnd.signatures.VoidDescriptor;
import aQute.lib.stringrover.StringRover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MethodSignature
implements Signature {
    public final TypeParameter[] typeParameters;
    public final JavaTypeSignature[] parameterTypes;
    public final Result resultType;
    public final ThrowsSignature[] throwTypes;
    static final ThrowsSignature[] EMPTY_ThrowsSignature = new ThrowsSignature[0];

    public static MethodSignature of(String signature) {
        return MethodSignature.parseMethodSignature(new StringRover(signature));
    }

    MethodSignature(TypeParameter[] typeParameters, JavaTypeSignature[] parameterTypes, Result resultType, ThrowsSignature[] throwTypes) {
        this.typeParameters = typeParameters;
        this.parameterTypes = parameterTypes;
        this.resultType = resultType;
        this.throwTypes = throwTypes;
    }

    @Override
    public Set<String> erasedBinaryReferences() {
        HashSet<String> references = new HashSet<String>();
        TypeParameter.erasedBinaryReferences(this.typeParameters, references);
        for (JavaTypeSignature parameterType : this.parameterTypes) {
            Signatures.erasedBinaryReferences(parameterType, references);
        }
        if (this.resultType instanceof ReferenceTypeSignature) {
            Signatures.erasedBinaryReferences((ReferenceTypeSignature)this.resultType, references);
        }
        for (ThrowsSignature throwType : this.throwTypes) {
            Signatures.erasedBinaryReferences((JavaTypeSignature)((Object)throwType), references);
        }
        return references;
    }

    public int hashCode() {
        int result = 31 + Arrays.hashCode(this.typeParameters);
        result = result * 31 + Arrays.hashCode(this.parameterTypes);
        result = result * 31 + this.resultType.hashCode();
        result = result * 31 + Arrays.hashCode(this.throwTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        return Objects.equals(this.resultType, other.resultType) && Arrays.equals(this.typeParameters, other.typeParameters) && Arrays.equals(this.parameterTypes, other.parameterTypes) && Arrays.equals(this.throwTypes, other.throwTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!Signatures.isEmpty(this.typeParameters)) {
            sb.append('<');
            for (TypeParameter typeParameter : this.typeParameters) {
                sb.append(typeParameter);
            }
            sb.append('>');
        }
        sb.append('(');
        for (JavaTypeSignature javaTypeSignature : this.parameterTypes) {
            sb.append(javaTypeSignature);
        }
        sb.append(')').append(this.resultType);
        for (ThrowsSignature throwsSignature : this.throwTypes) {
            sb.append('^').append(throwsSignature);
        }
        return sb.toString();
    }

    static MethodSignature parseMethodSignature(StringRover signature) {
        JavaTypeSignature[] parameterTypes;
        TypeParameter[] typeParameters = TypeParameter.parseTypeParameters(signature);
        assert (signature.charAt(0) == '(');
        if (signature.increment().charAt(0) != ')') {
            ArrayList<JavaTypeSignature> list = new ArrayList<JavaTypeSignature>();
            do {
                JavaTypeSignature item = Signatures.parseJavaTypeSignature(signature);
                list.add(item);
            } while (signature.charAt(0) != ')');
            parameterTypes = list.toArray(Signatures.EMPTY_JavaTypeSignature);
        } else {
            parameterTypes = Signatures.EMPTY_JavaTypeSignature;
        }
        Result returnType = MethodSignature.parseResult(signature.increment());
        if (signature.isEmpty()) {
            return new MethodSignature(typeParameters, parameterTypes, returnType, EMPTY_ThrowsSignature);
        }
        ArrayList<ThrowsSignature> list = new ArrayList<ThrowsSignature>();
        do {
            ThrowsSignature item = MethodSignature.parseThrowsSignature(signature);
            list.add(item);
        } while (!signature.isEmpty());
        return new MethodSignature(typeParameters, parameterTypes, returnType, list.toArray(EMPTY_ThrowsSignature));
    }

    static Result parseResult(StringRover signature) {
        switch (signature.charAt(0)) {
            case 'V': {
                signature.increment();
                return VoidDescriptor.V;
            }
        }
        return Signatures.parseJavaTypeSignature(signature);
    }

    static ThrowsSignature parseThrowsSignature(StringRover signature) {
        assert (signature.charAt(0) == '^');
        switch (signature.charAt(1)) {
            case 'T': {
                return TypeVariableSignature.parseTypeVariableSignature(signature.increment());
            }
            case 'L': {
                return ClassTypeSignature.parseClassTypeSignature(signature.increment());
            }
        }
        throw new IllegalArgumentException("invalid signature: " + signature);
    }
}

