/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.Signature;
import aQute.bnd.signatures.Signatures;
import aQute.bnd.signatures.TypeParameter;
import aQute.lib.stringrover.StringRover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ClassSignature
implements Signature {
    public final TypeParameter[] typeParameters;
    public final ClassTypeSignature superClass;
    public final ClassTypeSignature[] superInterfaces;

    public static ClassSignature of(String signature) {
        return ClassSignature.parseClassSignature(new StringRover(signature));
    }

    ClassSignature(TypeParameter[] typeParameters, ClassTypeSignature superClass, ClassTypeSignature[] superInterfaces) {
        this.typeParameters = typeParameters;
        this.superClass = superClass;
        this.superInterfaces = superInterfaces;
    }

    @Override
    public Set<String> erasedBinaryReferences() {
        HashSet<String> references = new HashSet<String>();
        TypeParameter.erasedBinaryReferences(this.typeParameters, references);
        Signatures.erasedBinaryReferences(this.superClass, references);
        for (ClassTypeSignature superInterface : this.superInterfaces) {
            Signatures.erasedBinaryReferences(superInterface, references);
        }
        return references;
    }

    public int hashCode() {
        int result = 31 + Arrays.hashCode(this.typeParameters);
        result = result * 31 + this.superClass.hashCode();
        result = result * 31 + Arrays.hashCode(this.superInterfaces);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassSignature)) {
            return false;
        }
        ClassSignature other = (ClassSignature)obj;
        return Objects.equals(this.superClass, other.superClass) && Arrays.equals(this.typeParameters, other.typeParameters) && Arrays.equals(this.superInterfaces, other.superInterfaces);
    }

    public String toString() {
        if (Signatures.isEmpty(this.typeParameters) && Signatures.isEmpty(this.superInterfaces)) {
            return this.superClass.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (!Signatures.isEmpty(this.typeParameters)) {
            sb.append('<');
            for (TypeParameter typeParameter : this.typeParameters) {
                sb.append(typeParameter);
            }
            sb.append('>');
        }
        sb.append(this.superClass);
        for (ClassTypeSignature classTypeSignature : this.superInterfaces) {
            sb.append(classTypeSignature);
        }
        return sb.toString();
    }

    static ClassSignature parseClassSignature(StringRover signature) {
        TypeParameter[] typeParameters = TypeParameter.parseTypeParameters(signature);
        ClassTypeSignature superClass = ClassTypeSignature.parseClassTypeSignature(signature);
        if (signature.isEmpty()) {
            return new ClassSignature(typeParameters, superClass, ClassTypeSignature.EMPTY);
        }
        ArrayList<ClassTypeSignature> list = new ArrayList<ClassTypeSignature>();
        do {
            ClassTypeSignature item = ClassTypeSignature.parseClassTypeSignature(signature);
            list.add(item);
        } while (!signature.isEmpty());
        return new ClassSignature(typeParameters, superClass, list.toArray(ClassTypeSignature.EMPTY));
    }
}

