/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.osgi;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.repository.osgi.OSGiIndex;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.repository.Prepare;
import aQute.bnd.util.repository.DownloadListenerPromise;
import aQute.bnd.version.Version;
import aQute.lib.converter.Converter;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(name="OSGiRepository", parameters=aQute.configurable.Config.class)
public class OSGiRepository
extends BaseRepository
implements Plugin,
RepositoryPlugin,
Actionable,
Refreshable,
RegistryPlugin,
Prepare,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(OSGiRepository.class);
    static final int YEAR = 31536000;
    static int DEFAULT_POLL_TIME = (int)TimeUnit.MINUTES.toSeconds(5L);
    private Config config;
    private OSGiIndex index;
    private Reporter reporter;
    private Registry registry;
    private ScheduledFuture<?> poller;
    private volatile boolean stale = false;
    private final AtomicBoolean inPoll = new AtomicBoolean();

    @Override
    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        File target = IO.getFile(this.getIndex().getCache(), bsn + "-" + version + ".jar");
        Promise<File> promise = this.getIndex().get(bsn, version, target);
        if (promise == null) {
            return null;
        }
        if (listeners.length == 0) {
            return promise.getValue();
        }
        new DownloadListenerPromise(this.reporter, "Download " + bsn + "-" + version + " into " + this.config.name(), promise, listeners);
        return target;
    }

    private synchronized OSGiIndex getIndex() throws Exception {
        if (this.index != null) {
            return this.index;
        }
        return this.getIndex(false);
    }

    synchronized OSGiIndex getIndex(boolean refresh) throws Exception {
        int polltime;
        Parameters gestalt;
        String cachePath;
        File cache;
        HttpClient client = this.registry.getPlugin(HttpClient.class);
        Workspace ws = this.registry.getPlugin(Workspace.class);
        if (ws == null) {
            ws = Workspace.createDefaultWorkspace();
        }
        File file = cache = (cachePath = this.config.cache()) == null ? ws.getCache(this.config.name()) : ws.getFile(cachePath);
        if (refresh) {
            IO.delete(cache);
        }
        List<String> strings = Strings.split(this.config.locations());
        ArrayList<URI> urls = new ArrayList<URI>(strings.size());
        for (String s : strings) {
            urls.add(new URI(s));
        }
        if (!(this.poller != null || (gestalt = ws.getGestalt()).containsKey("batch") || gestalt.containsKey("ci") || gestalt.containsKey("offline") || (polltime = this.config.poll_time(DEFAULT_POLL_TIME)) <= 0)) {
            this.poller = Processor.getScheduledExecutor().scheduleAtFixedRate(this::pollTask, polltime, polltime, TimeUnit.SECONDS);
        }
        this.index = new OSGiIndex(this.config.name(), client, cache, urls, this.config.max_stale(31536000), refresh);
        if (refresh) {
            this.index.getBridgeRepository().onResolve(this::notifyRepositoryListeners);
        }
        this.stale = false;
        return this.index;
    }

    private void notifyRepositoryListeners() {
        this.registry.getPlugins(RepositoryListenerPlugin.class).forEach(rp -> rp.repositoryRefreshed(this));
    }

    private void pollTask() {
        if (this.inPoll.getAndSet(true)) {
            return;
        }
        try {
            this.poll();
        }
        catch (Exception e) {
            logger.debug("During polling", e);
        }
        finally {
            this.inPoll.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() throws Exception {
        OSGiIndex ix;
        if (this.stale) {
            return;
        }
        OSGiRepository oSGiRepository = this;
        synchronized (oSGiRepository) {
            ix = this.index;
        }
        if (ix == null) {
            return;
        }
        if (ix.isStale()) {
            this.stale = true;
            this.notifyRepositoryListeners();
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public List<String> list(String pattern) throws Exception {
        return this.getIndex().getBridge().list(pattern);
    }

    @Override
    public SortedSet<Version> versions(String bsn) throws Exception {
        return this.getIndex().getBridge().versions(bsn);
    }

    @Override
    public String getName() {
        return this.config.name();
    }

    @Override
    public String getLocation() {
        try {
            return Strings.join(this.getIndex().getURIs());
        }
        catch (Exception e) {
            return this.config.locations();
        }
    }

    @Override
    public Map<String, Runnable> actions(Object ... target) throws Exception {
        LinkedHashMap<String, Runnable> menu = new LinkedHashMap<String, Runnable>();
        switch (target.length) {
            case 0: {
                menu.put("Reload Index & Bundles", () -> {
                    try {
                        this.getIndex(true);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                });
                break;
            }
            case 2: {
                menu.put("Reload Bundle", () -> {
                    try {
                        String bsn = (String)target[0];
                        Version version = (Version)target[1];
                        File f = this.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
                        if (f != null) {
                            IO.delete(f);
                        }
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                });
            }
        }
        return menu;
    }

    @Override
    public String tooltip(Object ... target) throws Exception {
        if (target.length == 0) {
            try (Formatter f = new Formatter();){
                if (this.stale) {
                    f.format("[stale] Needs reload, see menu\n", new Object[0]);
                }
                f.format("Name             : %s\n", this.getName());
                f.format("Cache            : %s\n", this.getRoot());
                f.format("Max stale (secs) : %s\n", this.config.max_stale(31536000));
                f.format("\nURLs            :\n", new Object[0]);
                for (URI uri : this.getIndex().getURIs()) {
                    f.format("    %s\n", uri);
                }
                String string = f.toString();
                return string;
            }
        }
        return this.getIndex().getBridge().tooltip(target);
    }

    @Override
    public String title(Object ... target) throws Exception {
        if (target.length == 0 && this.stale) {
            return this.getName() + " [stale]";
        }
        return this.getIndex().getBridge().title(target);
    }

    @Override
    public synchronized boolean refresh() {
        try {
            this.getIndex(true);
            return true;
        }
        catch (Exception e) {
            logger.error("Refreshing repository {} failed", (Object)this.getName(), (Object)e);
            return false;
        }
    }

    @Override
    public File getRoot() throws Exception {
        return this.getIndex().getCache();
    }

    @Override
    public void setProperties(Map<String, String> map) throws Exception {
        this.config = Converter.cnv(Config.class, map);
    }

    @Override
    public void setReporter(Reporter processor) {
        this.reporter = processor;
    }

    @Override
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public void prepare() throws Exception {
        this.getIndex();
    }

    public String toString() {
        String location;
        try {
            location = this.getRoot().getAbsolutePath();
        }
        catch (Exception e) {
            location = this.config.cache();
        }
        return String.format("%s [%-40s r/w=%s]", this.getName(), location, this.canWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ScheduledFuture<?> p;
        OSGiRepository oSGiRepository = this;
        synchronized (oSGiRepository) {
            p = this.poller;
        }
        if (p != null) {
            p.cancel(true);
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        try {
            return this.getIndex().findProviders(requirements);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    static interface Config {
        public String locations();

        public int max_stale(int var1);

        public String cache();

        public String name();

        public int poll_time(int var1);
    }
}

