/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.osgi;

import aQute.bnd.http.HttpClient;
import aQute.bnd.http.HttpRequest;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.promise.PromiseCollectors;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OSGiIndex {
    private static final Logger logger = LoggerFactory.getLogger(OSGiIndex.class);
    private final Promise<BridgeRepository> repository;
    private final HttpClient client;
    private final PromiseFactory promiseFactory;
    private final long staleTime;
    private final File cache;
    private final String name;
    private final List<URI> uris;

    OSGiIndex(String name, HttpClient client, File cache, List<URI> uris, int staleTime, boolean refresh) throws Exception {
        this.name = name;
        this.uris = uris;
        this.client = client;
        this.promiseFactory = client.promiseFactory();
        this.cache = OSGiIndex.checkCache(cache);
        this.staleTime = (long)staleTime * 1000L;
        this.repository = this.readIndexes(refresh);
    }

    private Promise<BridgeRepository> readIndexes(boolean refresh) throws Exception {
        Promise<List> resources = this.getURIs().stream().map(uri -> this.download((URI)uri, refresh)).collect(PromiseCollectors.toPromise(this.promiseFactory)).map(ll -> ll.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        Promise<BridgeRepository> bridge = resources.map(ResourcesRepository::new).map(BridgeRepository::new);
        return bridge;
    }

    Promise<BridgeRepository> getBridgeRepository() {
        return this.repository;
    }

    private static File checkCache(File cache) throws Exception {
        IO.mkdirs(cache);
        if (!cache.isDirectory()) {
            throw new IllegalArgumentException("Cannot create directory for " + cache);
        }
        return cache;
    }

    private Promise<List<Resource>> download(URI uri, boolean refresh) {
        HttpRequest<File> req = this.client.build().useCache(refresh ? -1L : this.staleTime);
        return req.async(uri).map(file -> {
            if (file == null) {
                logger.debug("{}: No file downloaded for {}", (Object)this.name, (Object)uri);
                return Collections.emptyList();
            }
            try (XMLResourceParser xmlp = new XMLResourceParser(IO.stream(file), this.name, uri);){
                List<Resource> list = xmlp.parse();
                return list;
            }
        });
    }

    Promise<File> get(String bsn, Version version, File file) throws Exception {
        Resource resource = this.getBridge().get(bsn, version);
        if (resource == null) {
            return null;
        }
        ResourceUtils.ContentCapability content = ResourceUtils.getContentCapability(resource);
        if (content == null) {
            logger.warn("{}: No content capability for {}", (Object)this.name, (Object)resource);
            return null;
        }
        URI url = content.url();
        if (url == null) {
            logger.warn("{}: No content URL for {}", (Object)this.name, (Object)resource);
            return null;
        }
        return this.client.build().useCache(file, this.staleTime).async(url);
    }

    BridgeRepository getBridge() throws Exception {
        return this.repository.getValue();
    }

    File getCache() {
        return this.cache;
    }

    boolean isStale() throws Exception {
        Deferred freshness = this.promiseFactory.deferred();
        ArrayList promises = new ArrayList(this.getURIs().size());
        for (URI uri : this.getURIs()) {
            if (freshness.getPromise().isDone()) break;
            try {
                Promise<TaggedData> async = this.client.build().useCache().asTag().async(uri);
                promises.add(async.then(resolved -> {
                    switch (((TaggedData)resolved.getValue()).getState()) {
                        case OTHER: {
                            logger.debug("Could not verify {}", (Object)uri);
                            break;
                        }
                        case UNMODIFIED: {
                            break;
                        }
                        default: {
                            logger.debug("Found {} to be stale", (Object)uri);
                            freshness.fail(new Exception("stale"));
                        }
                    }
                    return null;
                }, resolved -> {
                    logger.debug("Could not verify {}: {}", (Object)uri, (Object)resolved.getFailure());
                    freshness.fail(resolved.getFailure());
                }));
            }
            catch (Exception e) {
                logger.debug("Checking stale status: {}: {}", (Object)uri, (Object)e);
            }
        }
        Promise all = this.promiseFactory.all(promises);
        freshness.resolveWith(all);
        return freshness.getPromise().getFailure() != null;
    }

    List<URI> getURIs() {
        return this.uris;
    }

    Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) throws Exception {
        return this.getBridge().getRepository().findProviders(requirements);
    }
}

