/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResolutionDirective;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceImpl;
import aQute.lib.converter.Converter;
import aQute.lib.filter.Filter;
import aQute.lib.strings.Strings;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class ResourceUtils {
    public static final Comparator<? super Resource> IDENTITY_VERSION_COMPARATOR = (o1, o2) -> {
        String v2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        String v1 = ResourceUtils.getIdentityVersion(o1);
        if (v1 == (v2 = ResourceUtils.getIdentityVersion(o2))) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return new aQute.bnd.version.Version(v1).compareTo(new aQute.bnd.version.Version(v2));
    };
    private static final Comparator<? super Resource> RESOURCE_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof ResourceImpl && o2 instanceof ResourceImpl) {
            return ((ResourceImpl)o1).compareTo((Resource)o2);
        }
        return o1.toString().compareTo(o2.toString());
    };
    public static final Resource DUMMY_RESOURCE = new ResourceBuilder().build();
    public static final String WORKSPACE_NAMESPACE = "bnd.workspace.project";
    private static final Converter cnv = new Converter();
    private static final Collection<Requirement> all;

    private static Stream<Capability> capabilityStream(Resource resource, String namespace) {
        return resource.getCapabilities(namespace).stream();
    }

    private static <T extends Capability> Stream<T> capabilityStream(Resource resource, String namespace, Class<T> type) {
        return ResourceUtils.capabilityStream(resource, namespace).map(c -> ResourceUtils.as(c, type));
    }

    public static ContentCapability getContentCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).findFirst().orElse(null);
    }

    public static List<ContentCapability> getContentCapabilities(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).collect(Collectors.toList());
    }

    public static IdentityCapability getIdentityCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.identity", IdentityCapability.class).findFirst().orElse(null);
    }

    public static String getIdentityVersion(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.identity", IdentityCapability.class).findFirst().map(c -> c.getAttributes().get("version")).map(Object::toString).orElse(null);
    }

    public static BundleCap getBundleCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.wiring.bundle", BundleCap.class).findFirst().orElse(null);
    }

    public static aQute.bnd.version.Version toVersion(Object v) {
        if (v instanceof aQute.bnd.version.Version) {
            return (aQute.bnd.version.Version)v;
        }
        if (v instanceof Version) {
            Version o = (Version)v;
            String q = o.getQualifier();
            return q.isEmpty() ? new aQute.bnd.version.Version(o.getMajor(), o.getMinor(), o.getMicro()) : new aQute.bnd.version.Version(o.getMajor(), o.getMinor(), o.getMicro(), q);
        }
        if (v instanceof String) {
            if (!aQute.bnd.version.Version.isVersion((String)v)) {
                return null;
            }
            return new aQute.bnd.version.Version((String)v);
        }
        return null;
    }

    public static final aQute.bnd.version.Version getVersion(Capability cap) {
        String attr = ResourceUtils.getVersionAttributeForNamespace(cap.getNamespace());
        if (attr == null) {
            return null;
        }
        Object v = cap.getAttributes().get(attr);
        if (v == null) {
            return null;
        }
        if (v instanceof aQute.bnd.version.Version) {
            return (aQute.bnd.version.Version)v;
        }
        if (v instanceof Version) {
            return new aQute.bnd.version.Version(v.toString());
        }
        if (v instanceof String) {
            return aQute.bnd.version.Version.parseVersion((String)v);
        }
        return null;
    }

    public static URI getURI(Capability contentCapability) {
        Object uriObj = contentCapability.getAttributes().get("url");
        if (uriObj == null) {
            return null;
        }
        if (uriObj instanceof URI) {
            return (URI)uriObj;
        }
        try {
            if (uriObj instanceof URL) {
                return ((URL)uriObj).toURI();
            }
            if (uriObj instanceof String) {
                try {
                    URL url = new URL((String)uriObj);
                    return url.toURI();
                }
                catch (MalformedURLException url) {
                    File f = new File((String)uriObj);
                    if (f.isFile()) {
                        return f.toURI();
                    }
                    return new URI((String)uriObj);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Resource content capability has illegal URL attribute", e);
        }
        return null;
    }

    public static String getVersionAttributeForNamespace(String namespace) {
        switch (namespace) {
            case "osgi.identity": {
                return "version";
            }
            case "osgi.wiring.bundle": 
            case "osgi.wiring.host": {
                return "bundle-version";
            }
            case "osgi.wiring.package": {
                return "version";
            }
            case "osgi.ee": {
                return "version";
            }
            case "osgi.native": {
                return "osgi.native.osversion";
            }
            case "osgi.extender": {
                return "version";
            }
            case "osgi.contract": {
                return "version";
            }
            case "osgi.implementation": {
                return "version";
            }
        }
        return null;
    }

    public static <T extends Capability> T as(Capability cap, Class<T> type) {
        return (T)((Capability)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (target, method, args) -> Capability.class == method.getDeclaringClass() ? method.invoke((Object)cap, args) : ResourceUtils.get(method, cap.getAttributes(), cap.getDirectives(), args)));
    }

    public static <T extends Requirement> T as(Requirement req, Class<T> type) {
        return (T)((Requirement)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (target, method, args) -> Requirement.class == method.getDeclaringClass() ? method.invoke((Object)req, args) : ResourceUtils.get(method, req.getAttributes(), req.getDirectives(), args)));
    }

    private static Object get(Method method, Map<String, Object> attrs, Map<String, String> directives, Object[] args) throws Exception {
        String name = method.getName().replace('_', '.');
        Object value = name.startsWith("$") ? directives.get(name.substring(1)) : attrs.get(name);
        if (value == null && args != null && args.length == 1) {
            value = args[0];
        }
        return cnv.convert(method.getGenericReturnType(), value);
    }

    public static Set<Resource> getResources(Collection<? extends Capability> providers) {
        if (providers == null || providers.isEmpty()) {
            return Collections.emptySet();
        }
        return ResourceUtils.getResources(providers.stream());
    }

    private static Set<Resource> getResources(Stream<? extends Capability> providers) {
        return providers.map(Capability::getResource).collect(Collectors.toCollection(() -> new TreeSet<Resource>(RESOURCE_COMPARATOR)));
    }

    public static Requirement createWildcardRequirement() {
        return CapReqBuilder.createSimpleRequirement("osgi.identity", "*", null).buildSyntheticRequirement();
    }

    public static boolean isEffective(Requirement r, Capability c) {
        String capabilityEffective = (String)c.getDirectives().get("effective");
        if (capabilityEffective == null) {
            return true;
        }
        if (capabilityEffective.equals("resolve")) {
            return true;
        }
        String requirementEffective = (String)r.getDirectives().get("effective");
        if (requirementEffective == null) {
            return false;
        }
        return capabilityEffective.equals(requirementEffective);
    }

    public static boolean matches(Requirement requirement, Resource resource) {
        return ResourceUtils.capabilityStream(resource, requirement.getNamespace()).anyMatch(c -> ResourceUtils.matches(requirement, c));
    }

    public static boolean matches(Requirement requirement, Capability capability) {
        if (!requirement.getNamespace().equals(capability.getNamespace())) {
            return false;
        }
        if (!ResourceUtils.isEffective(requirement, capability)) {
            return false;
        }
        String filter = (String)requirement.getDirectives().get("filter");
        if (filter == null) {
            return true;
        }
        try {
            Filter f = new Filter(filter);
            return f.matchMap(capability.getAttributes());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getEffective(Map<String, String> directives) {
        String effective = directives.get("effective");
        if (effective == null) {
            return "resolve";
        }
        return effective;
    }

    public static ResolutionDirective getResolution(Requirement requirement) {
        String resolution = (String)requirement.getDirectives().get("resolution");
        if (resolution == null || resolution.equals("mandatory")) {
            return ResolutionDirective.mandatory;
        }
        if (resolution.equals("optional")) {
            return ResolutionDirective.optional;
        }
        return null;
    }

    public static String toRequireCapability(Requirement requirement) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(requirement.getNamespace());
        CapReqBuilder r = new CapReqBuilder(requirement.getNamespace());
        r.addAttributes(requirement.getAttributes());
        r.addDirectives(requirement.getDirectives());
        Attrs attrs = r.toAttrs();
        sb.append(";").append(attrs);
        return sb.toString();
    }

    public static String toProvideCapability(Capability capability) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(capability.getNamespace());
        CapReqBuilder r = new CapReqBuilder(capability.getNamespace());
        r.addAttributes(capability.getAttributes());
        r.addDirectives(capability.getDirectives());
        Attrs attrs = r.toAttrs();
        sb.append(";").append(attrs);
        return sb.toString();
    }

    public static Map<URI, String> getLocations(Resource resource) {
        return ResourceUtils.capabilityStream(resource, "osgi.content", ContentCapability.class).filter(c -> Objects.nonNull(c.url())).collect(Collector.of(HashMap::new, (m, c) -> m.put(c.url(), c.osgi_content()), (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        }, new Collector.Characteristics[0]));
    }

    public static List<Capability> findProviders(Requirement requirement, Collection<? extends Capability> capabilities) {
        return capabilities.stream().filter(c -> ResourceUtils.matches(requirement, c)).collect(Collectors.toList());
    }

    public static boolean isFragment(Resource resource) {
        IdentityCapability identity = ResourceUtils.getIdentityCapability(resource);
        if (identity == null) {
            return false;
        }
        return "osgi.fragment".equals(identity.getAttributes().get("type"));
    }

    public static String stripDirective(String name) {
        if (Strings.charAt(name, -1) == ':') {
            return Strings.substring(name, 0, -1);
        }
        return name;
    }

    public static String getIdentity(Capability identityCapability) throws IllegalArgumentException {
        String id = (String)identityCapability.getAttributes().get("osgi.identity");
        if (id == null) {
            throw new IllegalArgumentException("Resource identity capability has missing identity attribute");
        }
        return id;
    }

    public static VersionedClause toVersionClause(Resource resource, String mask) {
        String versionString;
        IdentityCapability idCap = ResourceUtils.getIdentityCapability(resource);
        String identity = ResourceUtils.getIdentity(idCap);
        if (resource.getCapabilities(WORKSPACE_NAMESPACE).isEmpty()) {
            Macro macro = new Macro(new Processor(), new Object[0]);
            aQute.bnd.version.Version version = ResourceUtils.getVersion(idCap);
            versionString = macro._range(new String[]{"range", mask, version.toString()});
        } else {
            versionString = "snapshot";
        }
        Attrs attribs = new Attrs();
        attribs.put("version", versionString);
        return new VersionedClause(identity, attribs);
    }

    public static Set<Resource> getAllResources(Repository repository) {
        return ResourceUtils.getResources(repository.findProviders(all).values().stream().flatMap(Collection::stream));
    }

    static {
        cnv.hook((Type)((Object)aQute.bnd.version.Version.class), (dest, o) -> o instanceof Version ? new aQute.bnd.version.Version(o.toString()) : null);
        all = Collections.singleton(ResourceUtils.createWildcardRequirement());
    }

    public static interface BundleCap
    extends Capability {
        public String osgi_wiring_bundle();

        public boolean singleton();

        public aQute.bnd.version.Version bundle_version();
    }

    public static interface ContentCapability
    extends Capability {
        public String osgi_content();

        public URI url();

        public long size();

        public String mime();
    }

    public static interface IdentityCapability
    extends Capability {
        public String osgi_identity();

        public boolean singleton();

        public aQute.bnd.version.Version version();

        public Type type();

        public URI uri();

        public String copyright();

        public String description(String var1);

        public String documentation();

        public String license();

        public static enum Type {
            bundle("osgi.bundle"),
            fragment("osgi.fragment"),
            unknown("unknown");

            private final String s;

            private Type(String s) {
                this.s = s;
            }

            public String toString() {
                return this.s;
            }
        }
    }
}

