/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.URLResource;
import aQute.bnd.osgi.ZipResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;

public interface Resource
extends Closeable {
    public InputStream openInputStream() throws Exception;

    public void write(OutputStream var1) throws Exception;

    public long lastModified();

    public void setExtra(String var1);

    public String getExtra();

    public long size() throws Exception;

    public ByteBuffer buffer() throws Exception;

    public static Resource fromURL(URL url) throws IOException {
        return Resource.fromURL(url, null);
    }

    public static Resource fromURL(URL url, HttpClient client) throws IOException {
        URLResource.JarURLUtil util;
        URL jarFileURL;
        if (url.getProtocol().equalsIgnoreCase("file")) {
            URI uri = URI.create(url.toExternalForm());
            Path path = new File(uri.getSchemeSpecificPart()).toPath().toAbsolutePath();
            return new FileResource(path);
        }
        if (url.getProtocol().equals("jar") && (jarFileURL = (util = new URLResource.JarURLUtil(url)).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
            URI uri = URI.create(jarFileURL.toExternalForm());
            Path path = new File(uri.getSchemeSpecificPart()).toPath().toAbsolutePath();
            String entryName = util.getEntryName();
            if (entryName == null) {
                return new FileResource(path);
            }
            return new ZipResource(path, entryName);
        }
        return new URLResource(url, client);
    }
}

