/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.ClassDataCollectorRecorder;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.OpCodes;
import aQute.bnd.osgi.Resource;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.Signature;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.ByteBufferDataInput;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.generics.Create;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clazz {
    private static final Logger logger = LoggerFactory.getLogger(Clazz.class);
    public static final EnumSet<QUERY> HAS_ARGUMENT = EnumSet.of(QUERY.IMPLEMENTS, new QUERY[]{QUERY.EXTENDS, QUERY.IMPORTS, QUERY.NAMED, QUERY.VERSION, QUERY.ANNOTATED, QUERY.INDIRECTLY_ANNOTATED, QUERY.HIERARCHY_ANNOTATED, QUERY.HIERARCHY_INDIRECTLY_ANNOTATED});
    static final int ACC_PUBLIC = 1;
    static final int ACC_FINAL = 16;
    static final int ACC_SUPER = 32;
    static final int ACC_INTERFACE = 512;
    static final int ACC_ABSTRACT = 1024;
    static final int ACC_SYNTHETIC = 4096;
    static final int ACC_BRIDGE = 64;
    static final int ACC_ANNOTATION = 8192;
    static final int ACC_ENUM = 16384;
    static final int ACC_MODULE = 32768;
    public static final Comparator<Clazz> NAME_COMPARATOR = (a, b) -> a.className.compareTo(b.className);
    boolean hasRuntimeAnnotations;
    boolean hasClassAnnotations;
    boolean hasDefaultConstructor;
    int depth = 0;
    Deque<ClassDataCollector> cds = new LinkedList<ClassDataCollector>();
    Descriptors.TypeRef className;
    Object[] pool;
    int[] intPool;
    Set<Descriptors.PackageRef> imports = Create.set();
    String path;
    int minor_version = 0;
    int major_version = 0;
    int innerAccess = -1;
    int accessx = 0;
    String sourceFile;
    Set<Descriptors.TypeRef> xref;
    Set<Descriptors.TypeRef> annotations;
    int forName = 0;
    int class$ = 0;
    Descriptors.TypeRef[] interfaces;
    Descriptors.TypeRef zuper;
    ClassDataCollector cd = null;
    Resource resource;
    FieldDef last = null;
    boolean deprecated;
    Set<Descriptors.PackageRef> api;
    final Analyzer analyzer;
    String classSignature;
    private Map<String, Object> defaults;
    public static final int TYPEUSE_INDEX_NONE = -1;
    public static final int TYPEUSE_TARGET_INDEX_EXTENDS = 65535;

    public Clazz(Analyzer analyzer, String path, Resource resource) {
        this.path = path;
        this.resource = resource;
        this.analyzer = analyzer;
    }

    public Set<Descriptors.TypeRef> parseClassFile() throws Exception {
        return this.parseClassFileWithCollector(null);
    }

    public Set<Descriptors.TypeRef> parseClassFile(InputStream in) throws Exception {
        return this.parseClassFile(in, null);
    }

    public Set<Descriptors.TypeRef> parseClassFileWithCollector(ClassDataCollector cd) throws Exception {
        ByteBuffer bb = this.resource.buffer();
        if (bb != null) {
            return this.parseClassFileData(ByteBufferDataInput.wrap(bb), cd);
        }
        return this.parseClassFile(this.resource.openInputStream(), cd);
    }

    public Set<Descriptors.TypeRef> parseClassFile(InputStream in, ClassDataCollector cd) throws Exception {
        try (DataInputStream din = new DataInputStream(in);){
            Set<Descriptors.TypeRef> set = this.parseClassFileData(din, cd);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Descriptors.TypeRef> parseClassFileData(DataInput in, ClassDataCollector cd) throws Exception {
        this.cds.push(this.cd);
        this.cd = cd;
        try {
            Set<Descriptors.TypeRef> set = this.parseClassFileData(in);
            return set;
        }
        finally {
            this.cd = this.cds.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Descriptors.TypeRef> parseClassFileData(DataInput in) throws Exception {
        ClassDataCollectorRecorder recorder;
        int interfaces_count;
        CONSTANT tag;
        logger.debug("parseClassFile(): path={} resource={}", (Object)this.path, (Object)this.resource);
        ++this.depth;
        this.xref = new HashSet<Descriptors.TypeRef>();
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor_version = in.readUnsignedShort();
        this.major_version = in.readUnsignedShort();
        int constant_pool_count = in.readUnsignedShort();
        this.pool = new Object[constant_pool_count];
        this.intPool = new int[constant_pool_count];
        CONSTANT[] tags = CONSTANT.values();
        for (int poolIndex = 1; poolIndex < constant_pool_count; poolIndex += tag.parse(this, in, poolIndex)) {
            int tagValue = in.readUnsignedByte();
            if (tagValue >= tags.length) {
                throw new IOException("Unrecognized constant pool tag value " + tagValue);
            }
            tag = tags[tagValue];
        }
        this.accessx = in.readUnsignedShort();
        if (this.isPublic()) {
            this.api = new HashSet<Descriptors.PackageRef>();
        }
        int this_class = in.readUnsignedShort();
        this.className = this.analyzer.getTypeRef((String)this.pool[this.intPool[this_class]]);
        int super_class = in.readUnsignedShort();
        if (super_class == 0) {
            if (!this.className.isObject() && !this.isModule()) {
                throw new IOException("Class does not have a super class and is not java.lang.Object or module-info");
            }
        } else {
            String superName = (String)this.pool[this.intPool[super_class]];
            this.zuper = this.analyzer.getTypeRef(superName);
        }
        if ((interfaces_count = in.readUnsignedShort()) > 0) {
            this.interfaces = new Descriptors.TypeRef[interfaces_count];
            for (int i = 0; i < interfaces_count; ++i) {
                String string = (String)this.pool[this.intPool[in.readUnsignedShort()]];
                this.interfaces[i] = this.analyzer.getTypeRef(string);
            }
        }
        if (this.cd != null) {
            if (!this.cd.classStart(this)) {
                return null;
            }
            this.cds.push(this.cd);
            recorder = new ClassDataCollectorRecorder();
            this.cd = recorder;
        } else {
            recorder = null;
        }
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (this.cd != null) {
                this.cd.version(this.minor_version, this.major_version);
            }
            block15: for (Object o : this.pool) {
                if (!(o instanceof Assoc)) continue;
                Assoc assoc = (Assoc)o;
                switch (assoc.tag) {
                    case Fieldref: 
                    case Methodref: 
                    case InterfaceMethodref: {
                        this.classConstRef(assoc.a);
                        continue block15;
                    }
                    case NameAndType: {
                        this.referTo(assoc.b, 0);
                        continue block15;
                    }
                    case MethodType: {
                        this.referTo(assoc.b, 0);
                        continue block15;
                    }
                }
            }
            if (!this.isModule()) {
                this.referTo(this.className, 1);
            }
            if (this.zuper != null) {
                this.referTo(this.zuper, this.accessx);
                if (this.cd != null) {
                    this.cd.extendsClass(this.zuper);
                }
            }
            if (interfaces_count > 0) {
                for (Descriptors.TypeRef i : this.interfaces) {
                    this.referTo(i, this.accessx);
                }
                if (this.cd != null) {
                    this.cd.implementsInterfaces(this.interfaces);
                }
            }
            boolean bl4 = this.cd != null;
            int fieldsCount = in.readUnsignedShort();
            for (int i = 0; i < fieldsCount; ++i) {
                int access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                String name = this.pool[name_index].toString();
                String descriptor = this.pool[descriptor_index].toString();
                if (name.startsWith("class$") || name.startsWith("$class$")) {
                    bl3 = true;
                }
                if (this.cd != null) {
                    FieldDef fdef;
                    this.last = fdef = new FieldDef(access_flags, name, descriptor);
                    this.cd.field(fdef);
                }
                this.referTo(descriptor_index, access_flags);
                this.doAttributes(in, ElementType.FIELD, false, access_flags);
            }
            if (bl3) {
                this.forName = this.findMethodReference("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                this.class$ = this.findMethodReference(this.className.getBinary(), "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            } else if (this.major_version == JAVA.JDK1_4.major) {
                this.forName = this.findMethodReference("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                if (this.forName > 0) {
                    bl2 = true;
                    this.class$ = this.findMethodReference(this.className.getBinary(), "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
                }
            }
            if (!bl2) {
                for (Object o : this.pool) {
                    if (!(o instanceof ClassConstant)) continue;
                    ClassConstant cc = (ClassConstant)o;
                    if (cc.referred) continue;
                    bl = true;
                    break;
                }
            }
            int methodCount = in.readUnsignedShort();
            for (int i = 0; i < methodCount; ++i) {
                int access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                String name = this.pool[name_index].toString();
                String descriptor = this.pool[descriptor_index].toString();
                if (this.cd != null) {
                    MethodDef mdef = new MethodDef(access_flags, name, descriptor);
                    this.last = mdef;
                    this.cd.method(mdef);
                }
                this.referTo(descriptor_index, access_flags);
                if ("<init>".equals(name)) {
                    if (Modifier.isPublic(access_flags) && "()V".equals(descriptor)) {
                        this.hasDefaultConstructor = true;
                    }
                    this.doAttributes(in, ElementType.CONSTRUCTOR, bl, access_flags);
                    continue;
                }
                this.doAttributes(in, ElementType.METHOD, bl, access_flags);
            }
            if (this.cd != null) {
                this.cd.memberEnd();
            }
            this.last = null;
            ElementType member = this.isAnnotation() ? ElementType.ANNOTATION_TYPE : (this.className.getBinary().endsWith("/package-info") ? ElementType.PACKAGE : ElementType.TYPE);
            this.doAttributes(in, member, false, this.accessx);
            Set<Descriptors.TypeRef> xref = this.xref;
            this.reset();
            Set<Descriptors.TypeRef> set = xref;
            return set;
        }
        finally {
            if (recorder != null) {
                this.cd = this.cds.pop();
                try {
                    recorder.play(this.cd);
                }
                finally {
                    this.cd.classEnd();
                }
            }
        }
    }

    void doUtf8_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        String name = in.readUTF();
        this.pool[poolIndex] = name;
    }

    void doInteger_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int i;
        this.intPool[poolIndex] = i = in.readInt();
        if (this.cd != null) {
            this.pool[poolIndex] = i;
        }
    }

    void doFloat_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = Float.valueOf(in.readFloat());
        } else {
            in.skipBytes(4);
        }
    }

    void doLong_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readLong();
        } else {
            in.skipBytes(8);
        }
    }

    void doDouble_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readDouble();
        } else {
            in.skipBytes(8);
        }
    }

    void doClass_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int class_index;
        this.intPool[poolIndex] = class_index = in.readUnsignedShort();
        ClassConstant c = new ClassConstant(class_index);
        this.pool[poolIndex] = c;
    }

    void doString_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int string_index;
        this.intPool[poolIndex] = string_index = in.readUnsignedShort();
    }

    void doFieldref_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, class_index, name_and_type_index);
    }

    void doMethodref_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, class_index, name_and_type_index);
    }

    void doInterfaceMethodref_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, class_index, name_and_type_index);
    }

    void doNameAndType_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, name_index, descriptor_index);
    }

    void doMethodHandle_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int reference_kind = in.readUnsignedByte();
        int reference_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, reference_kind, reference_index);
    }

    void doMethodType_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int descriptor_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, 0, descriptor_index);
    }

    void doDynamic_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int bootstrap_method_attr_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, bootstrap_method_attr_index, name_and_type_index);
    }

    void doInvokeDynamic_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        int bootstrap_method_attr_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(tag, bootstrap_method_attr_index, name_and_type_index);
    }

    void doModule_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        in.skipBytes(2);
    }

    void doPackage_info(CONSTANT tag, DataInput in, int poolIndex) throws IOException {
        in.skipBytes(2);
    }

    private int findMethodReference(String clazz, String methodname, String descriptor) {
        block3: for (int i = 1; i < this.pool.length; ++i) {
            if (!(this.pool[i] instanceof Assoc)) continue;
            Assoc methodref = (Assoc)this.pool[i];
            switch (methodref.tag) {
                case Methodref: 
                case InterfaceMethodref: {
                    int class_index = methodref.a;
                    int class_name_index = this.intPool[class_index];
                    if (!clazz.equals(this.pool[class_name_index])) continue block3;
                    int name_and_type_index = methodref.b;
                    Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                    if (name_and_type.tag != CONSTANT.NameAndType) continue block3;
                    int name_index = name_and_type.a;
                    int type_index = name_and_type.b;
                    if (!methodname.equals(this.pool[name_index]) || !descriptor.equals(this.pool[type_index])) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    private void doAttributes(DataInput in, ElementType member, boolean crawl, int access_flags) throws Exception {
        int attributesCount = in.readUnsignedShort();
        for (int j = 0; j < attributesCount; ++j) {
            this.doAttribute(in, member, crawl, access_flags);
        }
    }

    private void doAttribute(DataInput in, ElementType member, boolean crawl, int access_flags) throws Exception {
        int attribute_name_index = in.readUnsignedShort();
        String attributeName = (String)this.pool[attribute_name_index];
        int attribute_length = in.readInt();
        switch (attributeName) {
            case "Deprecated": {
                this.doDeprecated(in, member);
                break;
            }
            case "RuntimeVisibleAnnotations": {
                this.doAnnotations(in, member, RetentionPolicy.RUNTIME, access_flags);
                break;
            }
            case "RuntimeInvisibleAnnotations": {
                this.doAnnotations(in, member, RetentionPolicy.CLASS, access_flags);
                break;
            }
            case "RuntimeVisibleParameterAnnotations": {
                this.doParameterAnnotations(in, ElementType.PARAMETER, RetentionPolicy.RUNTIME, access_flags);
                break;
            }
            case "RuntimeInvisibleParameterAnnotations": {
                this.doParameterAnnotations(in, ElementType.PARAMETER, RetentionPolicy.CLASS, access_flags);
                break;
            }
            case "RuntimeVisibleTypeAnnotations": {
                this.doTypeAnnotations(in, ElementType.TYPE_USE, RetentionPolicy.RUNTIME, access_flags);
                break;
            }
            case "RuntimeInvisibleTypeAnnotations": {
                this.doTypeAnnotations(in, ElementType.TYPE_USE, RetentionPolicy.CLASS, access_flags);
                break;
            }
            case "InnerClasses": {
                this.doInnerClasses(in);
                break;
            }
            case "EnclosingMethod": {
                this.doEnclosingMethod(in);
                break;
            }
            case "SourceFile": {
                this.doSourceFile(in);
                break;
            }
            case "Code": {
                this.doCode(in, crawl);
                break;
            }
            case "Signature": {
                this.doSignature(in, member, access_flags);
                break;
            }
            case "ConstantValue": {
                this.doConstantValue(in);
                break;
            }
            case "AnnotationDefault": {
                this.doAnnotationDefault(in, member, access_flags);
                break;
            }
            case "Exceptions": {
                this.doExceptions(in, access_flags);
                break;
            }
            case "BootstrapMethods": {
                this.doBootstrapMethods(in);
                break;
            }
            case "StackMapTable": {
                this.doStackMapTable(in);
                break;
            }
            case "NestHost": {
                this.doNestHost(in);
                break;
            }
            case "NestMembers": {
                this.doNestMembers(in);
                break;
            }
            case "MethodParameters": {
                this.doMethodParameters(in);
                break;
            }
            default: {
                if (attribute_length < 0) {
                    throw new IllegalArgumentException("Attribute > 2Gb");
                }
                in.skipBytes(attribute_length);
            }
        }
    }

    private void doEnclosingMethod(DataInput in) throws IOException {
        int cIndex = in.readUnsignedShort();
        int mIndex = in.readUnsignedShort();
        this.classConstRef(cIndex);
        if (this.cd != null) {
            int nameIndex = this.intPool[cIndex];
            Descriptors.TypeRef cName = this.analyzer.getTypeRef((String)this.pool[nameIndex]);
            String mName = null;
            String mDescriptor = null;
            if (mIndex != 0) {
                Assoc nameAndType = (Assoc)this.pool[mIndex];
                mName = (String)this.pool[nameAndType.a];
                mDescriptor = (String)this.pool[nameAndType.b];
            }
            this.cd.enclosingMethod(cName, mName, mDescriptor);
        }
    }

    private void doInnerClasses(DataInput in) throws Exception {
        int number_of_classes = in.readUnsignedShort();
        for (int i = 0; i < number_of_classes; ++i) {
            int nameIndex;
            int inner_class_info_index = in.readUnsignedShort();
            int outer_class_info_index = in.readUnsignedShort();
            int inner_name_index = in.readUnsignedShort();
            int inner_class_access_flags = in.readUnsignedShort();
            if (this.cd == null) continue;
            Descriptors.TypeRef innerClass = null;
            Descriptors.TypeRef outerClass = null;
            String innerName = null;
            if (inner_class_info_index != 0) {
                nameIndex = this.intPool[inner_class_info_index];
                innerClass = this.analyzer.getTypeRef((String)this.pool[nameIndex]);
            }
            if (outer_class_info_index != 0) {
                nameIndex = this.intPool[outer_class_info_index];
                outerClass = this.analyzer.getTypeRef((String)this.pool[nameIndex]);
            }
            if (inner_name_index != 0) {
                innerName = (String)this.pool[inner_name_index];
            }
            this.cd.innerClass(innerClass, outerClass, innerName, inner_class_access_flags);
        }
    }

    void doSignature(DataInput in, ElementType member, int access_flags) throws IOException {
        int signature_index = in.readUnsignedShort();
        String signature = (String)this.pool[signature_index];
        try {
            Signature sig;
            switch (member) {
                case ANNOTATION_TYPE: 
                case TYPE: 
                case PACKAGE: {
                    this.classSignature = signature;
                    sig = this.analyzer.getClassSignature(signature);
                    break;
                }
                case FIELD: {
                    sig = this.analyzer.getFieldSignature(signature);
                    break;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    sig = this.analyzer.getMethodSignature(signature);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Signature \"" + signature + "\" found for unknown element type: " + (Object)((Object)member));
                }
            }
            Set<String> binaryRefs = sig.erasedBinaryReferences();
            for (String binary : binaryRefs) {
                Descriptors.TypeRef ref = this.analyzer.getTypeRef(binary);
                if (this.cd != null) {
                    this.cd.addReference(ref);
                }
                this.referTo(ref, access_flags);
            }
            if (this.last != null) {
                this.last.signature = signature;
            }
            if (this.cd != null) {
                this.cd.signature(signature);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Signature failed for " + signature, e);
        }
    }

    void doDeprecated(DataInput in, ElementType member) throws Exception {
        switch (member) {
            case ANNOTATION_TYPE: 
            case TYPE: 
            case PACKAGE: {
                this.deprecated = true;
                break;
            }
            case FIELD: 
            case CONSTRUCTOR: 
            case METHOD: {
                if (this.last == null) break;
                this.last.deprecated = true;
                break;
            }
        }
        if (this.cd != null) {
            this.cd.deprecated();
        }
    }

    void doAnnotationDefault(DataInput in, ElementType member, int access_flags) throws IOException {
        Object value = this.doElementValue(in, member, RetentionPolicy.RUNTIME, this.cd != null, access_flags);
        if (this.last instanceof MethodDef) {
            this.last.constant = value;
            this.cd.annotationDefault((MethodDef)this.last, value);
        }
    }

    void doConstantValue(DataInput in) throws IOException {
        int constantValue_index = in.readUnsignedShort();
        if (this.cd == null) {
            return;
        }
        Object object = this.pool[constantValue_index];
        if (object == null) {
            object = this.pool[this.intPool[constantValue_index]];
        }
        this.last.constant = object;
        this.cd.constant(object);
    }

    void doExceptions(DataInput in, int access_flags) throws IOException {
        int exception_count = in.readUnsignedShort();
        for (int i = 0; i < exception_count; ++i) {
            int index = in.readUnsignedShort();
            ClassConstant cc = (ClassConstant)this.pool[index];
            Descriptors.TypeRef clazz = this.analyzer.getTypeRef(cc.getName());
            this.referTo(clazz, access_flags);
        }
    }

    void doMethodParameters(DataInput in) throws IOException {
        int parameters_count = in.readUnsignedByte();
        MethodParameter[] parameters = new MethodParameter[parameters_count];
        for (int i = 0; i < parameters_count; ++i) {
            int name_index = in.readUnsignedShort();
            int access_flags = in.readUnsignedShort();
            String name = (String)this.pool[name_index];
            parameters[i] = new MethodParameter(name, access_flags);
        }
        if (this.last instanceof MethodDef) {
            MethodDef method = (MethodDef)this.last;
            method.parameters = parameters;
            this.cd.methodParameters(method, parameters);
        }
    }

    private void doCode(DataInput in, boolean crawl) throws Exception {
        in.readUnsignedShort();
        in.readUnsignedShort();
        int code_length = in.readInt();
        if (crawl) {
            ByteBuffer code = this.slice(in, code_length);
            this.crawl(code);
        } else {
            in.skipBytes(code_length);
        }
        int exception_table_length = in.readUnsignedShort();
        for (int i = 0; i < exception_table_length; ++i) {
            int start_pc = in.readUnsignedShort();
            int end_pc = in.readUnsignedShort();
            int handler_pc = in.readUnsignedShort();
            int catch_type = in.readUnsignedShort();
            this.classConstRef(catch_type);
        }
        this.doAttributes(in, ElementType.METHOD, false, 0);
    }

    private ByteBuffer slice(DataInput in, int length) throws Exception {
        if (in instanceof ByteBufferDataInput) {
            ByteBufferDataInput bbin = (ByteBufferDataInput)in;
            return bbin.slice(length);
        }
        byte[] array = new byte[length];
        in.readFully(array, 0, length);
        return ByteBuffer.wrap(array, 0, length);
    }

    private void crawl(ByteBuffer bb) {
        int lastReference = -1;
        block13: while (bb.hasRemaining()) {
            int instruction = Byte.toUnsignedInt(bb.get());
            switch (instruction) {
                case 18: {
                    lastReference = Byte.toUnsignedInt(bb.get());
                    this.classConstRef(lastReference);
                    continue block13;
                }
                case 19: {
                    lastReference = Short.toUnsignedInt(bb.getShort());
                    this.classConstRef(lastReference);
                    continue block13;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    int cref = Short.toUnsignedInt(bb.getShort());
                    this.classConstRef(cref);
                    lastReference = -1;
                    continue block13;
                }
                case 197: {
                    int cref = Short.toUnsignedInt(bb.getShort());
                    this.classConstRef(cref);
                    bb.get();
                    lastReference = -1;
                    continue block13;
                }
                case 183: {
                    int mref = Short.toUnsignedInt(bb.getShort());
                    if (this.cd == null) continue block13;
                    this.referenceMethod(0, mref);
                    continue block13;
                }
                case 182: {
                    int mref = Short.toUnsignedInt(bb.getShort());
                    if (this.cd == null) continue block13;
                    this.referenceMethod(0, mref);
                    continue block13;
                }
                case 185: {
                    int mref = Short.toUnsignedInt(bb.getShort());
                    if (this.cd != null) {
                        this.referenceMethod(0, mref);
                    }
                    bb.get();
                    bb.get();
                    continue block13;
                }
                case 184: {
                    int methodref = Short.toUnsignedInt(bb.getShort());
                    if (this.cd != null) {
                        this.referenceMethod(0, methodref);
                    }
                    if (methodref != this.forName && methodref != this.class$ || lastReference == -1 || !(this.pool[this.intPool[lastReference]] instanceof String)) continue block13;
                    String fqn = (String)this.pool[this.intPool[lastReference]];
                    if (!fqn.equals("class") && fqn.indexOf(46) > 0) {
                        Descriptors.TypeRef clazz = this.analyzer.getTypeRefFromFQN(fqn);
                        this.referTo(clazz, 0);
                    }
                    lastReference = -1;
                    continue block13;
                }
                case 196: {
                    int opcode = Byte.toUnsignedInt(bb.get());
                    bb.position(bb.position() + (opcode == 132 ? 4 : 2));
                    continue block13;
                }
                case 170: {
                    int rem = bb.position() % 4;
                    if (rem != 0) {
                        bb.position(bb.position() + 4 - rem);
                    }
                    int deflt = bb.getInt();
                    int low = bb.getInt();
                    int high = bb.getInt();
                    bb.position(bb.position() + (high - low + 1) * 4);
                    lastReference = -1;
                    continue block13;
                }
                case 171: {
                    int rem = bb.position() % 4;
                    if (rem != 0) {
                        bb.position(bb.position() + 4 - rem);
                    }
                    int deflt = bb.getInt();
                    int npairs = bb.getInt();
                    bb.position(bb.position() + npairs * 8);
                    lastReference = -1;
                    continue block13;
                }
            }
            lastReference = -1;
            bb.position(bb.position() + OpCodes.OFFSETS[instruction]);
        }
    }

    private void doSourceFile(DataInput in) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = this.pool[sourcefile_index].toString();
    }

    private void doParameterAnnotations(DataInput in, ElementType member, RetentionPolicy policy, int access_flags) throws Exception {
        boolean collect = this.cd != null;
        int num_parameters = in.readUnsignedByte();
        for (int p = 0; p < num_parameters; ++p) {
            int num_annotations = in.readUnsignedShort();
            if (num_annotations <= 0) continue;
            if (collect) {
                this.cd.parameter(p);
            }
            for (int a = 0; a < num_annotations; ++a) {
                Annotation annotation = this.doAnnotation(in, member, policy, collect, access_flags);
                if (!collect) continue;
                this.cd.annotation(annotation);
            }
        }
    }

    private void doTypeAnnotations(DataInput in, ElementType member, RetentionPolicy policy, int access_flags) throws Exception {
        int num_annotations = in.readUnsignedShort();
        for (int p = 0; p < num_annotations; ++p) {
            int target_index;
            byte[] target_info;
            int target_type = in.readUnsignedByte();
            switch (target_type) {
                case 0: 
                case 1: {
                    target_info = new byte[1];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]);
                    break;
                }
                case 16: {
                    target_info = new byte[2];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                    break;
                }
                case 17: 
                case 18: {
                    target_info = new byte[2];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]);
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    target_info = new byte[]{};
                    target_index = -1;
                    break;
                }
                case 22: {
                    target_info = new byte[1];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]);
                    break;
                }
                case 23: {
                    target_info = new byte[2];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                    break;
                }
                case 64: 
                case 65: {
                    int table_length = in.readUnsignedShort();
                    target_info = new byte[table_length * 6];
                    in.readFully(target_info);
                    target_index = -1;
                    break;
                }
                case 66: {
                    target_info = new byte[2];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                    break;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    target_info = new byte[2];
                    in.readFully(target_info);
                    target_index = -1;
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    target_info = new byte[3];
                    in.readFully(target_info);
                    target_index = Byte.toUnsignedInt(target_info[2]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown target_type: " + target_type);
                }
            }
            int path_length = in.readUnsignedByte();
            byte[] type_path = new byte[path_length * 2];
            in.readFully(type_path);
            if (this.cd != null) {
                this.cd.typeuse(target_type, target_index, target_info, type_path);
                Annotation annotation = this.doAnnotation(in, member, policy, true, access_flags);
                this.cd.annotation(annotation);
                continue;
            }
            this.doAnnotation(in, member, policy, false, access_flags);
        }
    }

    private void doAnnotations(DataInput in, ElementType member, RetentionPolicy policy, int access_flags) throws Exception {
        int num_annotations = in.readUnsignedShort();
        for (int a = 0; a < num_annotations; ++a) {
            if (this.cd == null) {
                this.doAnnotation(in, member, policy, false, access_flags);
                continue;
            }
            Annotation annotation = this.doAnnotation(in, member, policy, true, access_flags);
            this.cd.annotation(annotation);
        }
    }

    private Annotation doAnnotation(DataInput in, ElementType member, RetentionPolicy policy, boolean collect, int access_flags) throws IOException {
        int type_index = in.readUnsignedShort();
        if (this.annotations == null) {
            this.annotations = new HashSet<Descriptors.TypeRef>();
        }
        String typeName = (String)this.pool[type_index];
        Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(typeName);
        this.annotations.add(typeRef);
        if (typeRef.getFQN().equals("java.lang.Deprecated")) {
            switch (member) {
                case ANNOTATION_TYPE: 
                case TYPE: 
                case PACKAGE: {
                    this.deprecated = true;
                    break;
                }
                case FIELD: 
                case CONSTRUCTOR: 
                case METHOD: {
                    if (this.last == null) break;
                    this.last.deprecated = true;
                    break;
                }
            }
        }
        if (policy == RetentionPolicy.RUNTIME) {
            this.referTo(typeRef, 0);
            this.hasRuntimeAnnotations = true;
            if (this.api != null && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                this.api.add(typeRef.getPackageRef());
            }
        } else {
            this.hasClassAnnotations = true;
        }
        int num_element_value_pairs = in.readUnsignedShort();
        LinkedHashMap<String, Object> elements = null;
        for (int v = 0; v < num_element_value_pairs; ++v) {
            int element_name_index = in.readUnsignedShort();
            String element = (String)this.pool[element_name_index];
            Object value = this.doElementValue(in, member, policy, collect, access_flags);
            if (!collect) continue;
            if (elements == null) {
                elements = new LinkedHashMap<String, Object>();
            }
            elements.put(element, value);
        }
        if (collect) {
            return new Annotation(typeRef, elements, member, policy);
        }
        return null;
    }

    private Object doElementValue(DataInput in, ElementType member, RetentionPolicy policy, boolean collect, int access_flags) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 73: 
            case 83: {
                int const_value_index = in.readUnsignedShort();
                return this.intPool[const_value_index];
            }
            case 68: 
            case 70: 
            case 74: 
            case 115: {
                int const_value_index = in.readUnsignedShort();
                return this.pool[const_value_index];
            }
            case 90: {
                int const_value_index = in.readUnsignedShort();
                return this.intPool[const_value_index] != 0;
            }
            case 101: {
                int type_name_index = in.readUnsignedShort();
                if (policy == RetentionPolicy.RUNTIME) {
                    this.referTo(type_name_index, 0);
                    if (this.api != null && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                        Descriptors.TypeRef name = this.analyzer.getTypeRef((String)this.pool[type_name_index]);
                        this.api.add(name.getPackageRef());
                    }
                }
                int const_name_index = in.readUnsignedShort();
                return this.pool[const_name_index];
            }
            case 99: {
                int class_info_index = in.readUnsignedShort();
                Descriptors.TypeRef name = this.analyzer.getTypeRef((String)this.pool[class_info_index]);
                if (policy == RetentionPolicy.RUNTIME) {
                    this.referTo(name, 0);
                    if (this.api != null && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                        this.api.add(name.getPackageRef());
                    }
                }
                return name;
            }
            case 64: {
                return this.doAnnotation(in, member, policy, collect, access_flags);
            }
            case 91: {
                int num_values = in.readUnsignedShort();
                Object[] result = new Object[num_values];
                for (int i = 0; i < num_values; ++i) {
                    result[i] = this.doElementValue(in, member, policy, collect, access_flags);
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
    }

    private void doBootstrapMethods(DataInput in) throws IOException {
        int num_bootstrap_methods = in.readUnsignedShort();
        for (int v = 0; v < num_bootstrap_methods; ++v) {
            int bootstrap_method_ref = in.readUnsignedShort();
            int num_bootstrap_arguments = in.readUnsignedShort();
            for (int a = 0; a < num_bootstrap_arguments; ++a) {
                int bootstrap_argument = in.readUnsignedShort();
                this.classConstRef(bootstrap_argument);
            }
        }
    }

    private void doStackMapTable(DataInput in) throws IOException {
        int number_of_entries = in.readUnsignedShort();
        for (int v = 0; v < number_of_entries; ++v) {
            int n;
            int number_of_locals;
            int offset_delta;
            int frame_type = in.readUnsignedByte();
            if (frame_type <= 63) continue;
            if (frame_type <= 127) {
                this.verification_type_info(in);
                continue;
            }
            if (frame_type <= 246) continue;
            if (frame_type <= 247) {
                offset_delta = in.readUnsignedShort();
                this.verification_type_info(in);
                continue;
            }
            if (frame_type <= 250) {
                offset_delta = in.readUnsignedShort();
                continue;
            }
            if (frame_type <= 251) {
                offset_delta = in.readUnsignedShort();
                continue;
            }
            if (frame_type <= 254) {
                offset_delta = in.readUnsignedShort();
                number_of_locals = frame_type - 251;
                for (n = 0; n < number_of_locals; ++n) {
                    this.verification_type_info(in);
                }
                continue;
            }
            if (frame_type > 255) continue;
            offset_delta = in.readUnsignedShort();
            number_of_locals = in.readUnsignedShort();
            for (n = 0; n < number_of_locals; ++n) {
                this.verification_type_info(in);
            }
            int number_of_stack_items = in.readUnsignedShort();
            for (int n2 = 0; n2 < number_of_stack_items; ++n2) {
                this.verification_type_info(in);
            }
        }
    }

    private void verification_type_info(DataInput in) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 7: {
                int cpool_index = in.readUnsignedShort();
                this.classConstRef(cpool_index);
                break;
            }
            case 8: {
                int n = in.readUnsignedShort();
            }
        }
    }

    private void doNestHost(DataInput in) throws IOException {
        int host_class_index = in.readUnsignedShort();
    }

    private void doNestMembers(DataInput in) throws IOException {
        int number_of_classes = in.readUnsignedShort();
        for (int v = 0; v < number_of_classes; ++v) {
            int n = in.readUnsignedShort();
        }
    }

    void referTo(Descriptors.TypeRef typeRef, int modifiers) {
        if (this.xref != null) {
            this.xref.add(typeRef);
        }
        if (typeRef.isPrimitive()) {
            return;
        }
        Descriptors.PackageRef packageRef = typeRef.getPackageRef();
        if (packageRef.isPrimitivePackage()) {
            return;
        }
        this.imports.add(packageRef);
        if (this.api != null && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers))) {
            this.api.add(packageRef);
        }
        if (this.cd != null) {
            this.cd.referTo(typeRef, modifiers);
        }
    }

    void referTo(int index, int modifiers) {
        String descriptor = (String)this.pool[index];
        this.parseDescriptor(descriptor, modifiers);
    }

    public void parseDescriptor(String descriptor, int modifiers) {
        char c = descriptor.charAt(0);
        if (c != '(' && c != 'L' && c != '[' && c != '<' && c != 'T') {
            return;
        }
        MethodSignature sig = c == '(' || c == '<' ? this.analyzer.getMethodSignature(descriptor) : this.analyzer.getFieldSignature(descriptor);
        Set<String> binaryRefs = sig.erasedBinaryReferences();
        for (String binary : binaryRefs) {
            Descriptors.TypeRef ref = this.analyzer.getTypeRef(binary);
            if (this.cd != null) {
                this.cd.addReference(ref);
            }
            this.referTo(ref, modifiers);
        }
    }

    public Set<Descriptors.PackageRef> getReferred() {
        return this.imports;
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void reset() {
        if (--this.depth == 0) {
            this.pool = null;
            this.intPool = null;
            this.xref = null;
        }
    }

    private Stream<Clazz> hierarchyStream(final Analyzer analyzer) {
        Objects.requireNonNull(analyzer);
        Spliterators.AbstractSpliterator<Clazz> spliterator = new Spliterators.AbstractSpliterator<Clazz>(Long.MAX_VALUE, 273){
            private Clazz clazz;
            {
                super(x0, x1);
                this.clazz = Clazz.this;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Clazz> action) {
                Objects.requireNonNull(action);
                if (this.clazz == null) {
                    return false;
                }
                action.accept(this.clazz);
                Descriptors.TypeRef type = this.clazz.zuper;
                if (type == null) {
                    this.clazz = null;
                } else {
                    try {
                        this.clazz = analyzer.findClass(type);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                    if (this.clazz == null) {
                        analyzer.warning("While traversing the type tree for %s cannot find class %s", Clazz.this, type);
                    }
                }
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    private Stream<Descriptors.TypeRef> typeStream(final Analyzer analyzer, final Function<? super Clazz, Collection<? extends Descriptors.TypeRef>> func, final Set<Descriptors.TypeRef> visited) {
        Objects.requireNonNull(analyzer);
        Objects.requireNonNull(func);
        Spliterators.AbstractSpliterator<Descriptors.TypeRef> spliterator = new Spliterators.AbstractSpliterator<Descriptors.TypeRef>(Long.MAX_VALUE, 273){
            private final Deque<Descriptors.TypeRef> queue;
            private final Set<Descriptors.TypeRef> seen;
            {
                super(x0, x1);
                this.queue = new ArrayDeque<Descriptors.TypeRef>((Collection)func.apply(Clazz.this));
                this.seen = visited != null ? visited : new HashSet();
            }

            @Override
            public boolean tryAdvance(Consumer<? super Descriptors.TypeRef> action) {
                Descriptors.TypeRef type;
                Objects.requireNonNull(action);
                do {
                    if ((type = this.queue.poll()) != null) continue;
                    return false;
                } while (this.seen.contains(type));
                this.seen.add(type);
                action.accept(type);
                if (visited != null) {
                    Clazz clazz;
                    try {
                        clazz = analyzer.findClass(type);
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                    if (clazz == null) {
                        analyzer.warning("While traversing the type tree for %s cannot find class %s", Clazz.this, type);
                    } else {
                        this.queue.addAll((Collection)func.apply(clazz));
                    }
                }
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public boolean is(QUERY query, Instruction instr, Analyzer analyzer) throws Exception {
        switch (query) {
            case ANY: {
                return true;
            }
            case NAMED: {
                return instr.matches(this.getClassName().getDottedOnly()) ^ instr.isNegated();
            }
            case VERSION: {
                String v = this.major_version + "." + this.minor_version;
                return instr.matches(v) ^ instr.isNegated();
            }
            case IMPLEMENTS: {
                HashSet visited = new HashSet();
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::interfaces, visited)).map(Descriptors.TypeRef::getDottedOnly).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case EXTENDS: {
                return this.hierarchyStream(analyzer).skip(1L).map(Clazz::getClassName).map(Descriptors.TypeRef::getDottedOnly).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case PUBLIC: {
                return this.isPublic();
            }
            case CONCRETE: {
                return !this.isAbstract();
            }
            case ANNOTATED: {
                return this.typeStream(analyzer, Clazz::annotations, null).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case INDIRECTLY_ANNOTATED: {
                return this.typeStream(analyzer, Clazz::annotations, new HashSet<Descriptors.TypeRef>()).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case HIERARCHY_ANNOTATED: {
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::annotations, null)).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case HIERARCHY_INDIRECTLY_ANNOTATED: {
                HashSet visited = new HashSet();
                return this.hierarchyStream(analyzer).flatMap(c -> c.typeStream(analyzer, Clazz::annotations, visited)).map(Descriptors.TypeRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case RUNTIMEANNOTATIONS: {
                return this.hasRuntimeAnnotations;
            }
            case CLASSANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case IMPORTS: {
                return this.hierarchyStream(analyzer).map(Clazz::getReferred).flatMap(Collection::stream).distinct().map(Descriptors.PackageRef::getFQN).anyMatch(instr::matches) ^ instr.isNegated();
            }
            case DEFAULT_CONSTRUCTOR: {
                return this.hasPublicNoArgsConstructor();
            }
        }
        return instr == null ? false : instr.isNegated();
    }

    public String toString() {
        if (this.className != null) {
            return this.className.getFQN();
        }
        return this.resource.toString();
    }

    private void referenceMethod(int access, int methodRefPoolIndex) {
        if (methodRefPoolIndex == 0) {
            return;
        }
        Object o = this.pool[methodRefPoolIndex];
        if (o instanceof Assoc) {
            Assoc assoc = (Assoc)o;
            switch (assoc.tag) {
                case Methodref: 
                case InterfaceMethodref: {
                    int string_index = this.intPool[assoc.a];
                    Descriptors.TypeRef class_name = this.analyzer.getTypeRef((String)this.pool[string_index]);
                    int name_and_type_index = assoc.b;
                    Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                    if (name_and_type.tag == CONSTANT.NameAndType) {
                        int name_index = name_and_type.a;
                        int type_index = name_and_type.b;
                        String method = (String)this.pool[name_index];
                        String descriptor = (String)this.pool[type_index];
                        this.cd.referenceMethod(access, class_name, method, descriptor);
                        break;
                    }
                    throw new IllegalArgumentException("Invalid class file (or parsing is wrong), assoc is not type + name (12)");
                }
                default: {
                    throw new IllegalArgumentException("Invalid class file (or parsing is wrong), Assoc is not method ref! (10)");
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid class file (or parsing is wrong), Not an assoc at a method ref");
        }
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.accessx);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.accessx);
    }

    public boolean isEnum() {
        return this.zuper != null && this.zuper.getBinary().equals("java/lang/Enum");
    }

    public boolean isSynthetic() {
        return (0x1000 & this.accessx) != 0;
    }

    public boolean isModule() {
        return (0x8000 & this.accessx) != 0;
    }

    public JAVA getFormat() {
        return JAVA.format(this.major_version);
    }

    public static String objectDescriptorToFQN(String string) {
        if ((string.startsWith("L") || string.startsWith("T")) && string.endsWith(";")) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        switch (string.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'Z': {
                return "boolean";
            }
            case '[': {
                return Clazz.objectDescriptorToFQN(string.substring(1)) + "[]";
            }
        }
        throw new IllegalArgumentException("Invalid type character in descriptor " + string);
    }

    public static String unCamel(String id) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            boolean tolower;
            int n;
            char c = id.charAt(i);
            if (c == '_' || c == '$' || c == '-' || c == '.') {
                if (out.length() <= 0 || Character.isWhitespace(out.charAt(out.length() - 1))) continue;
                out.append(' ');
                continue;
            }
            for (n = i; n < id.length() && Character.isUpperCase(id.charAt(n)); ++n) {
            }
            if (n == i) {
                out.append(id.charAt(i));
                continue;
            }
            boolean bl = tolower = n - i == 1;
            if (i > 0 && !Character.isWhitespace(out.charAt(out.length() - 1))) {
                out.append(' ');
            }
            while (i < n) {
                if (tolower) {
                    out.append(Character.toLowerCase(id.charAt(i)));
                } else {
                    out.append(id.charAt(i));
                }
                ++i;
            }
            --i;
        }
        if (id.startsWith(".")) {
            out.append(" *");
        }
        out.replace(0, 1, Character.toUpperCase(out.charAt(0)) + "");
        return out.toString();
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessx);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessx);
    }

    public boolean hasPublicNoArgsConstructor() {
        return this.hasDefaultConstructor;
    }

    public int getAccess() {
        if (this.innerAccess == -1) {
            return this.accessx;
        }
        return this.innerAccess;
    }

    public Descriptors.TypeRef getClassName() {
        return this.className;
    }

    public MethodDef getMethodDef(int access, String name, String descriptor) {
        return new MethodDef(access, name, descriptor);
    }

    public Descriptors.TypeRef getSuper() {
        return this.zuper;
    }

    public String getFQN() {
        return this.className.getFQN();
    }

    public Descriptors.TypeRef[] getInterfaces() {
        return this.interfaces;
    }

    public List<Descriptors.TypeRef> interfaces() {
        return this.interfaces != null ? Arrays.asList(this.interfaces) : Collections.emptyList();
    }

    public Set<Descriptors.TypeRef> annotations() {
        return this.annotations != null ? this.annotations : Collections.emptySet();
    }

    public void setInnerAccess(int access) {
        this.innerAccess = access;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.accessx);
    }

    public void setDeprecated(boolean b) {
        this.deprecated = b;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isAnnotation() {
        return (this.accessx & 0x2000) != 0;
    }

    public Set<Descriptors.PackageRef> getAPIUses() {
        if (this.api == null) {
            return Collections.emptySet();
        }
        return this.api;
    }

    public TypeDef getExtends(Descriptors.TypeRef type) {
        return new TypeDef(type, false);
    }

    public TypeDef getImplements(Descriptors.TypeRef type) {
        return new TypeDef(type, true);
    }

    private void classConstRef(int index) {
        Object o = this.pool[index];
        if (o == null) {
            return;
        }
        if (o instanceof ClassConstant) {
            ClassConstant cc = (ClassConstant)o;
            if (cc.referred) {
                return;
            }
            cc.referred = true;
            String name = cc.getName();
            if (name != null) {
                Descriptors.TypeRef tr = this.analyzer.getTypeRef(name);
                this.referTo(tr, 0);
            }
        }
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public Map<String, Object> getDefaults() throws Exception {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, Object>();
            final HashMap<String, Object> map = this.defaults;
            this.parseClassFileWithCollector(new ClassDataCollector(){

                @Override
                public void annotationDefault(MethodDef last, Object value) {
                    map.put(last.name, value);
                }
            });
        }
        return this.defaults;
    }

    public class TypeDef
    extends Def {
        final Descriptors.TypeRef type;
        final boolean interf;

        public TypeDef(Descriptors.TypeRef type, boolean interf) {
            super(1);
            this.type = type;
            this.interf = interf;
        }

        public Descriptors.TypeRef getReference() {
            return this.type;
        }

        public boolean getImplements() {
            return this.interf;
        }

        @Override
        public String getName() {
            if (this.interf) {
                return "<implements>";
            }
            return "<extends>";
        }

        @Override
        public Descriptors.TypeRef getType() {
            return this.type;
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return null;
        }
    }

    public class MethodDef
    extends FieldDef {
        MethodParameter[] parameters;

        public MethodDef(int access, String method, String descriptor) {
            super(access, method, descriptor);
        }

        public boolean isConstructor() {
            return this.name.equals("<init>") || this.name.equals("<clinit>");
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return this.descriptor.getPrototype();
        }

        public boolean isBridge() {
            return (this.access & 0x40) != 0;
        }

        @Override
        public String getGenericReturnType() {
            MethodSignature sig = Clazz.this.analyzer.getMethodSignature(this.signature != null ? this.signature : this.descriptor.toString());
            return sig.resultType.toString();
        }

        public MethodParameter[] getParameters() {
            return this.parameters;
        }
    }

    public static class MethodParameter {
        final String name;
        final int access_flags;

        MethodParameter(String name, int access_flags) {
            this.name = name;
            this.access_flags = access_flags;
        }

        public String getName() {
            return this.name;
        }

        public int getAccess() {
            return this.access_flags;
        }

        public String toString() {
            return this.getName();
        }
    }

    public class FieldDef
    extends Def {
        final String name;
        final Descriptors.Descriptor descriptor;
        String signature;
        Object constant;
        boolean deprecated;

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public FieldDef(int access, String name, String descriptor) {
            super(access);
            this.name = name;
            this.descriptor = Clazz.this.analyzer.getDescriptor(descriptor);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Descriptors.TypeRef getType() {
            return this.descriptor.getType();
        }

        public Descriptors.TypeRef getContainingClass() {
            return Clazz.this.getClassName();
        }

        public Descriptors.Descriptor getDescriptor() {
            return this.descriptor;
        }

        public void setConstant(Object o) {
            this.constant = o;
        }

        public Object getConstant() {
            return this.constant;
        }

        public String getGenericReturnType() {
            FieldSignature sig = Clazz.this.analyzer.getFieldSignature(this.signature != null ? this.signature : this.descriptor.toString());
            return sig.type.toString();
        }

        @Override
        public Descriptors.TypeRef[] getPrototype() {
            return null;
        }

        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return this.name;
        }
    }

    public abstract class Def {
        final int access;
        Set<Descriptors.TypeRef> annotations;

        public Def(int access) {
            this.access = access;
        }

        public int getAccess() {
            return this.access;
        }

        public boolean isEnum() {
            return (this.access & 0x4000) != 0;
        }

        public boolean isPublic() {
            return Modifier.isPublic(this.access);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.access);
        }

        public boolean isProtected() {
            return Modifier.isProtected(this.access);
        }

        public boolean isFinal() {
            return Modifier.isFinal(this.access) || Clazz.this.isFinal();
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.access);
        }

        public boolean isPrivate() {
            return Modifier.isPrivate(this.access);
        }

        public boolean isNative() {
            return Modifier.isNative(this.access);
        }

        public boolean isTransient() {
            return Modifier.isTransient(this.access);
        }

        public boolean isVolatile() {
            return Modifier.isVolatile(this.access);
        }

        public boolean isInterface() {
            return Modifier.isInterface(this.access);
        }

        public boolean isSynthetic() {
            return (this.access & 0x1000) != 0;
        }

        void addAnnotation(Annotation a) {
            if (this.annotations == null) {
                this.annotations = Create.set();
            }
            this.annotations.add(Clazz.this.analyzer.getTypeRef(a.getName().getBinary()));
        }

        public Collection<Descriptors.TypeRef> getAnnotations() {
            return this.annotations;
        }

        public Descriptors.TypeRef getOwnerType() {
            return Clazz.this.className;
        }

        public abstract String getName();

        public abstract Descriptors.TypeRef getType();

        public abstract Descriptors.TypeRef[] getPrototype();

        public Object getClazz() {
            return Clazz.this;
        }
    }

    protected static class Assoc {
        final CONSTANT tag;
        final int a;
        final int b;

        Assoc(CONSTANT tag, int a, int b) {
            this.tag = tag;
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "Assoc[" + (Object)((Object)this.tag) + ", " + this.a + "," + this.b + "]";
        }
    }

    static enum CONSTANT {
        Zero(CONSTANT::invalid),
        Utf8(Clazz::doUtf8_info),
        Two(CONSTANT::invalid),
        Integer(Clazz::doInteger_info),
        Float(Clazz::doFloat_info),
        Long(Clazz::doLong_info),
        Double(Clazz::doDouble_info),
        Class(Clazz::doClass_info),
        String(Clazz::doString_info),
        Fieldref(Clazz::doFieldref_info),
        Methodref(Clazz::doMethodref_info),
        InterfaceMethodref(Clazz::doInterfaceMethodref_info),
        NameAndType(Clazz::doNameAndType_info),
        Thirteen(CONSTANT::invalid),
        Fourteen(CONSTANT::invalid),
        MethodHandle(Clazz::doMethodHandle_info),
        MethodType(Clazz::doMethodType_info),
        Dynamic(Clazz::doDynamic_info),
        InvokeDynamic(Clazz::doInvokeDynamic_info),
        Module(Clazz::doModule_info),
        Package(Clazz::doPackage_info);

        private final ConstantInfo info;
        private final int width;

        private CONSTANT(ConstantInfo info) {
            this.info = Objects.requireNonNull(info);
            int value = this.ordinal();
            this.width = value == 5 || value == 6 ? 2 : 1;
        }

        int parse(Clazz c, DataInput in, int poolIndex) throws IOException {
            this.info.accept(c, this, in, poolIndex);
            return this.width;
        }

        private static void invalid(Clazz c, CONSTANT tag, DataInput in, int poolIndex) throws IOException {
            throw new IOException("Invalid constant pool tag " + tag.ordinal());
        }
    }

    static interface ConstantInfo {
        public void accept(Clazz var1, CONSTANT var2, DataInput var3, int var4) throws IOException;
    }

    public static enum QUERY {
        IMPLEMENTS,
        EXTENDS,
        IMPORTS,
        NAMED,
        ANY,
        VERSION,
        CONCRETE,
        ABSTRACT,
        PUBLIC,
        ANNOTATED,
        INDIRECTLY_ANNOTATED,
        HIERARCHY_ANNOTATED,
        HIERARCHY_INDIRECTLY_ANNOTATED,
        RUNTIMEANNOTATIONS,
        CLASSANNOTATIONS,
        DEFAULT_CONSTRUCTOR;

    }

    public static enum JAVA {
        JDK1_1(45, "JRE-1.1", "(&(osgi.ee=JavaSE)(version=1.1))"),
        JDK1_2(46, "J2SE-1.2", "(&(osgi.ee=JavaSE)(version=1.2))"),
        JDK1_3(47, "J2SE-1.3", "(&(osgi.ee=JavaSE)(version=1.3))"),
        JDK1_4(48, "J2SE-1.4", "(&(osgi.ee=JavaSE)(version=1.4))"),
        J2SE5(49, "J2SE-1.5", "(&(osgi.ee=JavaSE)(version=1.5))"),
        J2SE6(50, "JavaSE-1.6", "(&(osgi.ee=JavaSE)(version=1.6))"),
        OpenJDK7(51, "JavaSE-1.7", "(&(osgi.ee=JavaSE)(version=1.7))"),
        OpenJDK8(52, "JavaSE-1.8", "(&(osgi.ee=JavaSE)(version=1.8))"){
            Map<String, Set<String>> profiles;

            @Override
            public Map<String, Set<String>> getProfiles() throws IOException {
                if (this.profiles == null) {
                    UTF8Properties p = new UTF8Properties();
                    try (InputStream in = Clazz.class.getResourceAsStream("profiles-" + (Object)((Object)this) + ".properties");){
                        ((Properties)p).load(in);
                    }
                    this.profiles = new HashMap<String, Set<String>>();
                    for (Map.Entry<Object, Object> prop : p.entrySet()) {
                        String list = (String)prop.getValue();
                        HashSet set = new HashSet();
                        Collections.addAll(set, list.split("\\s*,\\s*"));
                        this.profiles.put((String)prop.getKey(), set);
                    }
                }
                return this.profiles;
            }
        }
        ,
        OpenJDK9(53, "JavaSE-9", "(&(osgi.ee=JavaSE)(version=9))"),
        OpenJDK10(54, "JavaSE-10", "(&(osgi.ee=JavaSE)(version=10))"),
        OpenJDK11(55, "JavaSE-11", "(&(osgi.ee=JavaSE)(version=11))"),
        UNKNOWN(Integer.MAX_VALUE, "<UNKNOWN>", "(osgi.ee=UNKNOWN)");

        final int major;
        final String ee;
        final String filter;

        private JAVA(int major, String ee, String filter) {
            this.major = major;
            this.ee = ee;
            this.filter = filter;
        }

        static JAVA format(int n) {
            for (JAVA e : JAVA.values()) {
                if (e.major != n) continue;
                return e;
            }
            return UNKNOWN;
        }

        public int getMajor() {
            return this.major;
        }

        public boolean hasAnnotations() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasGenerics() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasEnums() {
            return this.major >= JAVA.J2SE5.major;
        }

        public static JAVA getJava(int major, int minor) {
            for (JAVA j : JAVA.values()) {
                if (j.major != major) continue;
                return j;
            }
            return UNKNOWN;
        }

        public String getEE() {
            return this.ee;
        }

        public String getFilter() {
            return this.filter;
        }

        public Map<String, Set<String>> getProfiles() throws IOException {
            return null;
        }
    }

    public class ClassConstant {
        final int cname;
        public boolean referred;

        public ClassConstant(int class_index) {
            this.cname = class_index;
        }

        public String getName() {
            return (String)Clazz.this.pool[this.cname];
        }

        public String toString() {
            return "ClassConstant[" + this.getName() + "]";
        }
    }
}

