/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import java.util.ArrayList;
import java.util.List;
import org.osgi.util.function.Consumer;

class ClassDataCollectorRecorder
extends ClassDataCollector {
    private final List<Consumer<ClassDataCollector>> actions = new ArrayList<Consumer<ClassDataCollector>>();
    private boolean start;

    ClassDataCollectorRecorder() {
    }

    void play(ClassDataCollector cdc) throws Exception {
        this.start = true;
        for (Consumer<ClassDataCollector> action : this.actions) {
            if (!this.start) break;
            action.accept(cdc);
        }
    }

    ClassDataCollectorRecorder reset() {
        this.actions.clear();
        return this;
    }

    @Override
    public void classBegin(int access, Descriptors.TypeRef name) {
        this.actions.add(cdc -> cdc.classBegin(access, name));
    }

    @Override
    public boolean classStart(int access, Descriptors.TypeRef className) {
        this.actions.add(cdc -> {
            if (!cdc.classStart(access, className)) {
                this.start = false;
            }
        });
        return true;
    }

    @Override
    public boolean classStart(Clazz c) {
        this.actions.add(cdc -> {
            if (!cdc.classStart(c)) {
                this.start = false;
            }
        });
        return true;
    }

    @Override
    public void extendsClass(Descriptors.TypeRef zuper) throws Exception {
        this.actions.add(cdc -> cdc.extendsClass(zuper));
    }

    @Override
    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) throws Exception {
        this.actions.add(cdc -> cdc.implementsInterfaces(interfaces));
    }

    @Override
    public void addReference(Descriptors.TypeRef ref) {
        this.actions.add(cdc -> cdc.addReference(ref));
    }

    @Override
    public void annotation(Annotation annotation) throws Exception {
        this.actions.add(cdc -> cdc.annotation(annotation));
    }

    @Override
    public void parameter(int p) {
        this.actions.add(cdc -> cdc.parameter(p));
    }

    @Override
    public void method(Clazz.MethodDef method) {
        this.actions.add(cdc -> cdc.method(method));
    }

    @Override
    public void field(Clazz.FieldDef field) {
        this.actions.add(cdc -> cdc.field(field));
    }

    @Override
    public void classEnd() throws Exception {
        this.actions.add(ClassDataCollector::classEnd);
    }

    @Override
    public void deprecated() throws Exception {
        this.actions.add(ClassDataCollector::deprecated);
    }

    @Override
    public void enclosingMethod(Descriptors.TypeRef cName, String mName, String mDescriptor) {
        this.actions.add(cdc -> cdc.enclosingMethod(cName, mName, mDescriptor));
    }

    @Override
    public void innerClass(Descriptors.TypeRef innerClass, Descriptors.TypeRef outerClass, String innerName, int innerClassAccessFlags) throws Exception {
        this.actions.add(cdc -> cdc.innerClass(innerClass, outerClass, innerName, innerClassAccessFlags));
    }

    @Override
    public void signature(String signature) {
        this.actions.add(cdc -> cdc.signature(signature));
    }

    @Override
    public void constant(Object object) {
        this.actions.add(cdc -> cdc.constant(object));
    }

    @Override
    public void memberEnd() {
        this.actions.add(ClassDataCollector::memberEnd);
    }

    @Override
    public void version(int minor, int major) {
        this.actions.add(cdc -> cdc.version(minor, major));
    }

    @Override
    public void referenceMethod(int access, Descriptors.TypeRef className, String method, String descriptor) {
        this.actions.add(cdc -> cdc.referenceMethod(access, className, method, descriptor));
    }

    @Override
    public void referTo(Descriptors.TypeRef typeRef, int modifiers) {
        this.actions.add(cdc -> cdc.referTo(typeRef, modifiers));
    }

    @Override
    public void annotationDefault(Clazz.MethodDef method) {
        this.actions.add(cdc -> cdc.annotationDefault(method));
    }

    @Override
    public void annotationDefault(Clazz.MethodDef method, Object value) {
        this.actions.add(cdc -> cdc.annotationDefault(method, value));
    }

    @Override
    public void typeuse(int target_type, int target_index, byte[] target_info, byte[] type_path) {
        this.actions.add(cdc -> cdc.typeuse(target_type, target_index, target_info, type_path));
    }

    @Override
    public void methodParameters(Clazz.MethodDef method, Clazz.MethodParameter[] parameters) {
        this.actions.add(cdc -> cdc.methodParameters(method, parameters));
    }
}

