/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.annotation.headers.BundleCategory;
import aQute.bnd.annotation.headers.BundleContributors;
import aQute.bnd.annotation.headers.BundleCopyright;
import aQute.bnd.annotation.headers.BundleDevelopers;
import aQute.bnd.annotation.headers.BundleDocURL;
import aQute.bnd.annotation.headers.BundleLicense;
import aQute.bnd.annotation.headers.Category;
import aQute.bnd.annotation.headers.ProvideCapability;
import aQute.bnd.annotation.headers.RequireCapability;
import aQute.bnd.bundle.annotations.Capabilities;
import aQute.bnd.bundle.annotations.Capability;
import aQute.bnd.bundle.annotations.Header;
import aQute.bnd.bundle.annotations.Headers;
import aQute.bnd.bundle.annotations.Requirement;
import aQute.bnd.bundle.annotations.Requirements;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.collections.MultiMap;
import aQute.lib.strings.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationHeaders
extends ClassDataCollector
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationHeaders.class);
    static final Pattern SIMPLE_PARAM_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
    static final Set<String> DO_NOT_SCAN = Stream.of("org.osgi.annotation.versioning.ProviderType", "org.osgi.annotation.versioning.ConsumerType", "org.osgi.annotation.versioning.Version").collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    final Analyzer analyzer;
    final MultiMap<String, String> headers = new MultiMap();
    static final String BUNDLE_LICENSE = "aQute.bnd.annotation.headers.BundleLicense";
    static final String REQUIRE_CAPABILITY = "aQute.bnd.annotation.headers.RequireCapability";
    static final String PROVIDE_CAPABILITY = "aQute.bnd.annotation.headers.ProvideCapability";
    static final String BUNDLE_CATEGORY = "aQute.bnd.annotation.headers.BundleCategory";
    static final String BUNDLE_DOC_URL = "aQute.bnd.annotation.headers.BundleDocURL";
    static final String BUNDLE_DEVELOPERS = "aQute.bnd.annotation.headers.BundleDevelopers";
    static final String BUNDLE_CONTRIBUTORS = "aQute.bnd.annotation.headers.BundleContributors";
    static final String BUNDLE_COPYRIGHT = "aQute.bnd.annotation.headers.BundleCopyright";
    static final String STD_REQUIREMENT = "org.osgi.annotation.bundle.Requirement";
    static final String STD_REQUIREMENTS = "org.osgi.annotation.bundle.Requirements";
    static final String STD_CAPABILITY = "org.osgi.annotation.bundle.Capability";
    static final String STD_CAPABILITIES = "org.osgi.annotation.bundle.Capabilities";
    static final String STD_HEADER = "org.osgi.annotation.bundle.Header";
    static final String STD_HEADERS = "org.osgi.annotation.bundle.Headers";
    static final String STD_ATTRIBUTE = "org.osgi.annotation.bundle.Attribute";
    static final String STD_DIRECTIVE = "org.osgi.annotation.bundle.Directive";
    Clazz current;
    final Set<String> loggedMissing = new HashSet<String>();
    boolean finalizing;

    AnnotationHeaders(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public boolean classStart(Clazz c) {
        if (!c.isAnnotation() && c.annotations != null) {
            this.current = c;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public void annotation(Annotation annotation) throws Exception {
        Descriptors.TypeRef name = annotation.getName();
        String fqn = name.getFQN();
        if (name.isJava() || DO_NOT_SCAN.contains(fqn)) {
            return;
        }
        switch (fqn) {
            case "aQute.bnd.annotation.headers.BundleCategory": {
                this.doBundleCategory(annotation.getAnnotation(BundleCategory.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleContributors": {
                this.doBundleContributors(annotation.getAnnotation(BundleContributors.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleCopyright": {
                this.doBundeCopyright(annotation.getAnnotation(BundleCopyright.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleDevelopers": {
                this.doBundleDevelopers(annotation.getAnnotation(BundleDevelopers.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleDocURL": {
                this.doBundleDocURL(annotation.getAnnotation(BundleDocURL.class));
                break;
            }
            case "aQute.bnd.annotation.headers.BundleLicense": {
                this.doLicense(annotation);
                break;
            }
            case "aQute.bnd.annotation.headers.ProvideCapability": {
                this.doProvideCapability(annotation);
                break;
            }
            case "aQute.bnd.annotation.headers.RequireCapability": {
                this.doRequireCapability(annotation);
                break;
            }
            case "org.osgi.annotation.bundle.Capabilities": {
                Capability[] capabilities = annotation.getAnnotation(Capabilities.class).value();
                Object[] capAnnotations = (Object[])annotation.get("value");
                for (int i = 0; i < capabilities.length; ++i) {
                    this.doCapability((Annotation)capAnnotations[i], capabilities[i]);
                }
                break;
            }
            case "org.osgi.annotation.bundle.Capability": {
                this.doCapability(annotation, annotation.getAnnotation(Capability.class));
                break;
            }
            case "org.osgi.annotation.bundle.Header": {
                Header header = annotation.getAnnotation(Header.class);
                this.add(header.name(), header.value());
                break;
            }
            case "org.osgi.annotation.bundle.Headers": {
                for (Header h : annotation.getAnnotation(Headers.class).value()) {
                    this.add(h.name(), h.value());
                }
                break;
            }
            case "org.osgi.annotation.bundle.Requirement": {
                this.doRequirement(annotation, annotation.getAnnotation(Requirement.class));
                break;
            }
            case "org.osgi.annotation.bundle.Requirements": {
                Requirement[] requirements = annotation.getAnnotation(Requirements.class).value();
                Object[] reqAnnotations = (Object[])annotation.get("value");
                for (int i = 0; i < requirements.length; ++i) {
                    this.doRequirement((Annotation)reqAnnotations[i], requirements[i]);
                }
                break;
            }
            default: {
                this.doAnnotatedAnnotation(annotation, name, Collections.emptySet(), new Attrs());
            }
        }
    }

    void doAnnotatedAnnotation(Annotation annotation, Descriptors.TypeRef name, Set<String> processed, Attrs baseAttrs) throws Exception {
        String fqn = name.getFQN();
        if (processed.contains(fqn)) {
            logger.debug("Detected an annotation cycle when processing %s. The cycled annotation was %s", (Object)this.current.getFQN(), (Object)fqn);
            return;
        }
        if (name.isJava() || DO_NOT_SCAN.contains(fqn)) {
            return;
        }
        Clazz c = this.analyzer.findClass(name);
        if (c != null && c.annotations != null) {
            c.parseClassFileWithCollector(new MetaAnnotationCollector(c, annotation, processed, baseAttrs));
        } else if (c == null && this.loggedMissing.add(fqn)) {
            if (this.analyzer.isPedantic()) {
                this.analyzer.warning("Unable to determine whether the meta annotation %s applied to type %s provides bundle annotations as it is not on the project build path. If this annotation does provide bundle annotations then it must be present on the build path in order to be processed", fqn, this.current.getFQN());
            } else {
                logger.info("Unable to determine whether the meta annotation {} applied to type {} provides bundle annotations as it is not on the project build path. If this annotation does provide bundle annotations then it must be present on the build path in order to be processed", (Object)fqn, (Object)this.current.getFQN());
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    private void doBundleDevelopers(BundleDevelopers annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (annotation.name() != null) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles() != null) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (annotation.organizationUrl() != null) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (annotation.organization() != null) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add("Bundle-Developers", sb.toString());
    }

    private void doBundleContributors(BundleContributors annotation) throws IOException {
        StringBuilder sb = new StringBuilder(annotation.value());
        if (annotation.name() != null) {
            sb.append(";name='");
            this.escape(sb, annotation.name());
            sb.append("'");
        }
        if (annotation.roles() != null) {
            sb.append(";roles='");
            this.escape(sb, annotation.roles());
            sb.append("'");
        }
        if (annotation.organizationUrl() != null) {
            sb.append(";organizationUrl='");
            this.escape(sb, annotation.organizationUrl());
            sb.append("'");
        }
        if (annotation.organization() != null) {
            sb.append(";organization='");
            this.escape(sb, annotation.organization());
            sb.append("'");
        }
        if (annotation.timezone() != 0) {
            sb.append(";timezone=").append(annotation.timezone());
        }
        this.add("Bundle-Contributors", sb.toString());
    }

    private void doBundeCopyright(BundleCopyright annotation) throws IOException {
        this.add("Bundle-Copyright", annotation.value());
    }

    private void doBundleDocURL(BundleDocURL annotation) throws IOException {
        this.add("Bundle-DocURL", annotation.value());
    }

    private void doBundleCategory(BundleCategory annotation) throws IOException {
        if (annotation.custom() != null) {
            for (String string : annotation.custom()) {
                this.add("Bundle-Category", string);
            }
        }
        if (annotation.value() != null) {
            for (Category category : annotation.value()) {
                this.add("Bundle-Category", category.toString());
            }
        }
    }

    private void doProvideCapability(Annotation a) throws Exception {
        ProvideCapability annotation = a.getAnnotation(ProvideCapability.class);
        Parameters p = new Parameters();
        Attrs attrs = this.getAttributes(a, "ns");
        this.directivesAndVersion(attrs, "uses", "mandatory", "effective");
        p.put(annotation.ns(), attrs);
        String value = attrs.remove("name");
        if (value != null) {
            attrs.put(annotation.ns(), value);
        }
        value = attrs.remove("value");
        String s = p.toString();
        if (value != null) {
            s = s + ";" + annotation.value();
        }
        this.add("Provide-Capability", s);
    }

    private void doRequireCapability(Annotation a) throws Exception {
        RequireCapability annotation = a.getAnnotation(RequireCapability.class);
        Parameters p = new Parameters();
        Attrs attrs = this.getAttributes(a, "ns");
        this.directivesAndVersion(attrs, "filter", "effective", "resolution");
        this.replaceParameters(attrs);
        if ("".equals(attrs.get("filter:"))) {
            attrs.remove("filter:");
        }
        p.put(annotation.ns(), attrs);
        String s = p.toString();
        String extra = annotation.extra();
        if (extra != null && (extra = extra.trim()).length() > 0) {
            s = s + ";" + extra;
        }
        this.add("Require-Capability", s);
    }

    private void replaceParameters(Attrs attrs) throws IllegalArgumentException {
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            boolean modified = false;
            StringBuffer sb = new StringBuffer();
            Matcher matcher = SIMPLE_PARAM_PATTERN.matcher(entry.getValue());
            while (matcher.find()) {
                modified = true;
                String key = matcher.group(1);
                String substitution = attrs.get(key);
                if (substitution == null) {
                    matcher.appendReplacement(sb, "");
                    sb.append(matcher.group(0));
                    continue;
                }
                if (SIMPLE_PARAM_PATTERN.matcher(substitution).find()) {
                    throw new IllegalArgumentException("nested substitutions not permitted");
                }
                matcher.appendReplacement(sb, substitution);
            }
            if (!modified) continue;
            matcher.appendTail(sb);
            entry.setValue(sb.toString());
        }
    }

    private void doLicense(Annotation a) throws Exception {
        BundleLicense annotation = a.getAnnotation(BundleLicense.class);
        Parameters p = new Parameters();
        p.put(annotation.name(), this.getAttributes(a, "name"));
        this.add("Bundle-License", p.toString());
    }

    private void doRequirement(Annotation a, Requirement annotation) throws Exception {
        StringBuilder req = new StringBuilder();
        req.append(annotation.namespace());
        String filter = this.getFilter(a, annotation);
        if (!filter.isEmpty()) {
            try {
                Verifier.verifyFilter(filter, 0);
            }
            catch (Exception e) {
                this.analyzer.exception(e, "The Requirement annotation with namespace %s applied to class %s has invalid filter information.", annotation.namespace(), this.current.getFQN());
            }
            req.append(";filter:='").append(filter).append('\'');
        }
        if (a.containsKey("resolution")) {
            req.append(";resolution:=").append((Object)annotation.resolution());
        }
        if (a.containsKey("cardinality")) {
            req.append(";cardinality:=").append((Object)annotation.cardinality());
        }
        if (a.containsKey("effective")) {
            req.append(";effective:=");
            this.escape(req, annotation.effective());
        }
        for (String attr : annotation.attribute()) {
            req.append(';').append(attr);
        }
        this.add("Require-Capability", req.toString());
    }

    private String getFilter(Annotation a, Requirement annotation) {
        StringBuilder filter = new StringBuilder();
        boolean addAnd = false;
        if (a.containsKey("filter")) {
            filter.append(annotation.filter());
            addAnd = true;
        }
        boolean andAdded = false;
        if (a.containsKey("name")) {
            filter.append('(').append(annotation.namespace()).append('=').append(annotation.name()).append(')');
            if (addAnd) {
                filter.insert(0, "(&").append(')');
                andAdded = true;
            }
            addAnd = true;
        }
        if (a.containsKey("version")) {
            Version floor;
            try {
                floor = Version.parseVersion(annotation.version());
            }
            catch (Exception e) {
                floor = null;
                this.analyzer.exception(e, "The version declared by the Requirement annotation attached to type %s is invalid", this.current.getFQN());
            }
            if (floor != null) {
                int current = filter.lastIndexOf(")");
                VersionRange range = new VersionRange(floor, floor.bumpMajor());
                String rangeFilter = range.toFilter();
                filter.append(rangeFilter.substring(2, rangeFilter.length() - 1));
                if (andAdded) {
                    filter.deleteCharAt(current).append(')');
                } else if (addAnd) {
                    filter.insert(0, "(&").append(')');
                }
            }
        }
        return filter.toString();
    }

    private void doCapability(Annotation a, Capability annotation) throws Exception {
        StringBuilder cap = new StringBuilder();
        cap.append(annotation.namespace());
        if (a.containsKey("name")) {
            cap.append(';').append(annotation.namespace()).append('=').append(annotation.name());
        }
        if (a.containsKey("version")) {
            try {
                Version.parseVersion(annotation.version());
            }
            catch (Exception e) {
                this.analyzer.exception(e, "The version declared by the Capability annotation attached to type %s is invalid", this.current.getFQN());
            }
            cap.append(";version:Version=").append(annotation.version());
        }
        for (String attr : annotation.attribute()) {
            cap.append(';').append(attr);
        }
        if (a.containsKey("uses")) {
            cap.append(a.stream("uses", Descriptors.TypeRef.class).map(Descriptors.TypeRef::getPackageRef).map(Descriptors.PackageRef::getFQN).distinct().collect(Strings.joining(",", ";uses:=\"", "\"", "")));
        }
        if (a.containsKey("effective")) {
            cap.append(";effective:=");
            this.escape(cap, annotation.effective());
        }
        this.add("Provide-Capability", cap.toString());
    }

    private void directivesAndVersion(Attrs attrs, String ... directives) {
        for (String directive : directives) {
            String s = attrs.remove(directive);
            if (s == null) continue;
            attrs.put(directive + ":", s);
        }
        String remove = attrs.remove("version");
        if (remove != null) {
            attrs.putTyped("version", Version.parseVersion(remove));
        }
    }

    private Attrs getAttributes(Annotation a, String ... ignores) {
        Attrs attrs = new Attrs();
        block0: for (Map.Entry<String, Object> entry : a.entrySet()) {
            String key = entry.getKey();
            for (String ignore : ignores) {
                if (key.equals(ignore)) continue block0;
            }
            attrs.putTyped(key, entry.getValue());
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        Processor next = new Processor(this.analyzer);
        next.setProperty("@class", this.current.getFQN());
        next.setProperty("@class-short", this.current.getClassName().getShortName());
        Descriptors.PackageRef pref = this.current.getClassName().getPackageRef();
        next.setProperty("@package", pref.getFQN());
        Attrs info = this.analyzer.getClasspathExports().get(pref);
        if (info == null) {
            info = this.analyzer.getContained().get(pref);
        }
        if (info != null && info.containsKey("version")) {
            next.setProperty("@version", info.get("version"));
        }
        Macro macro = next.getReplacer();
        boolean prev = macro.setNosystem(true);
        try {
            value = macro.process(value);
            this.headers.add(name, value);
            if (!this.analyzer.keySet().contains(name)) {
                this.analyzer.set(name, value);
            }
            next.close();
        }
        finally {
            macro.setNosystem(prev);
        }
    }

    public String getHeader(String name) {
        String value = this.analyzer.getProperty(name);
        if (this.headers.containsKey(name)) {
            TreeSet set = new TreeSet((Collection)this.headers.get(name));
            ArrayList<String> result = new ArrayList<String>(set.size() + 1);
            if (value != null && !set.contains(value)) {
                result.add(value);
            }
            result.addAll(set);
            return Strings.join(result);
        }
        return value;
    }

    private void escape(StringBuilder app, String[] s) throws IOException {
        String joined = Strings.join(s);
        this.escape(app, joined);
    }

    private void escape(StringBuilder app, String s) throws IOException {
        Processor.quote(app, s);
    }

    private final class MetaAnnotationCollector
    extends ClassDataCollector {
        private final Clazz c;
        private final Annotation annotation;
        private String lastMethodSeen;
        private Set<String> processed;
        private Attrs attributesAndDirectives = new Attrs();

        private MetaAnnotationCollector(Clazz c, Annotation annotation, Set<String> processed, Attrs baseAttrs) {
            this.c = c;
            this.annotation = annotation;
            this.processed = processed;
            this.attributesAndDirectives = new Attrs(baseAttrs);
        }

        @Override
        public void annotation(Annotation a) throws Exception {
            String fqn;
            switch (fqn = a.getName().getFQN()) {
                case "aQute.bnd.annotation.headers.BundleCategory": 
                case "aQute.bnd.annotation.headers.BundleContributors": 
                case "aQute.bnd.annotation.headers.BundleCopyright": 
                case "aQute.bnd.annotation.headers.BundleDevelopers": 
                case "aQute.bnd.annotation.headers.BundleDocURL": 
                case "aQute.bnd.annotation.headers.BundleLicense": 
                case "aQute.bnd.annotation.headers.ProvideCapability": 
                case "aQute.bnd.annotation.headers.RequireCapability": {
                    a.merge(this.annotation);
                    a.addDefaults(this.c);
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Capabilities": 
                case "org.osgi.annotation.bundle.Capability": 
                case "org.osgi.annotation.bundle.Requirement": 
                case "org.osgi.annotation.bundle.Requirements": {
                    this.mergeAttributesAndDirectives(a);
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Header": 
                case "org.osgi.annotation.bundle.Headers": {
                    AnnotationHeaders.this.annotation(a);
                    break;
                }
                case "org.osgi.annotation.bundle.Attribute": 
                case "org.osgi.annotation.bundle.Directive": {
                    this.handleAttributeOrDirective(a);
                    break;
                }
                default: {
                    HashSet<String> processed = new HashSet<String>(this.processed);
                    processed.add(this.c.getFQN());
                    AnnotationHeaders.this.doAnnotatedAnnotation(a, a.getName(), processed, this.attributesAndDirectives);
                }
            }
        }

        private void mergeAttributesAndDirectives(Annotation a) {
            String fqn;
            switch (fqn = a.getName().getFQN()) {
                case "org.osgi.annotation.bundle.Capabilities": 
                case "org.osgi.annotation.bundle.Requirements": {
                    Object[] annotations = (Object[])a.get("value");
                    for (int i = 0; i < annotations.length; ++i) {
                        this.mergeAttributesAndDirectives((Annotation)annotations[i]);
                    }
                    break;
                }
                default: {
                    if (this.attributesAndDirectives.isEmpty()) break;
                    Object[] original = (Object[])a.get("attribute");
                    int length = original != null ? original.length : 0;
                    Object[] updated = new Object[length + this.attributesAndDirectives.size()];
                    if (length > 0) {
                        System.arraycopy(original, 0, updated, 0, length);
                    }
                    for (String key : this.attributesAndDirectives.keySet()) {
                        updated[length++] = this.attributesAndDirectives.toString(key);
                    }
                    a.put("attribute", updated);
                }
            }
        }

        private void handleAttributeOrDirective(Annotation a) {
            Object o = this.annotation.get(this.lastMethodSeen);
            if (o != null) {
                String attributeName = (String)a.get("value");
                if (attributeName == null) {
                    attributeName = this.lastMethodSeen;
                }
                if (AnnotationHeaders.STD_DIRECTIVE.equals(a.getName().getFQN())) {
                    attributeName = attributeName + ":";
                }
                if (!this.attributesAndDirectives.containsKey(attributeName)) {
                    this.attributesAndDirectives.putTyped(attributeName, o);
                }
            }
        }

        @Override
        public void method(Clazz.MethodDef defined) {
            this.lastMethodSeen = defined.getName();
        }
    }
}

