/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.component;

import aQute.bnd.component.DSAnnotations;
import aQute.bnd.component.HeaderReader;
import aQute.bnd.component.TagResource;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.make.metatype.MetaTypeReader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.strings.Strings;
import aQute.lib.tag.Tag;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class ServiceComponent
implements AnalyzerPlugin {
    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        ComponentMaker m = new ComponentMaker(analyzer);
        Set<String> l = m.doServiceComponent().keySet();
        List<String> names = DSAnnotations.removeOverlapInServiceComponentHeader(l);
        analyzer.setProperty("Service-Component", Strings.join(names));
        analyzer.getInfo(m, "Service-Component: ");
        m.close();
        return false;
    }

    private static class ComponentMaker
    extends Processor {
        Analyzer analyzer;

        ComponentMaker(Analyzer analyzer) {
            super(analyzer);
            this.analyzer = analyzer;
        }

        Map<String, Map<String, String>> doServiceComponent() throws Exception {
            Map<String, Map<String, String>> serviceComponents = ComponentMaker.newMap();
            String header = this.getProperty("Service-Component");
            Parameters sc = this.parseHeader(header);
            for (Map.Entry<String, Attrs> entry : sc.entrySet()) {
                String name = entry.getKey();
                Map info = entry.getValue();
                try {
                    if (name.indexOf(47) >= 0 || name.endsWith(".xml")) {
                        serviceComponents.put(name, EMPTY);
                        continue;
                    }
                    this.componentEntry(serviceComponents, name, info);
                }
                catch (Exception e) {
                    this.error("Invalid Service-Component header: %s %s, throws %s", name, info, e);
                    throw e;
                }
            }
            return serviceComponents;
        }

        private void componentEntry(Map<String, Map<String, String>> serviceComponents, String name, Map<String, String> info) throws Exception, IOException {
            boolean fqn = Verifier.isFQN(name);
            if (fqn) {
                this.createComponentResource(serviceComponents, name, info);
            } else {
                this.reportInvalidUseOfServiceComponentHeader(name);
            }
        }

        private void reportInvalidUseOfServiceComponentHeader(String name) throws Exception, IOException {
            Reporter.SetLocation warning = this.warning("Service-Component is normally generated by bnd. If you want to point at specific component XML files (wildcards are allowed, see findEntries) make sure it ends in '.xml'. Found %s", name);
            Processor.FileLine where = this.getHeader(Pattern.compile("Service-Component"), Pattern.compile(Pattern.quote(name)));
            if (where != null) {
                where.set(warning);
            }
            warning.reference("https://osgi.org/specification/osgi.cmpn/7.0.0/service.component.html#d0e36857");
            Collection<Clazz> classes = this.analyzer.getClasses(null, "NAMED", name, "ANNOTATED", "aQute.bnd.annotation.component.Component");
            for (Clazz clazz : classes) {
                File f;
                Reporter.SetLocation loc = this.error("Service-Component refers to %s that is annotated with the deprecated bnd Component annotation. Support for this was removed in 4.0.0 because they were taken over by OSGi. Please update to the comparable OSGi annotations", clazz.getFQN());
                Descriptors.TypeRef cname = clazz.getClassName();
                String source = this.analyzer.getSourceFileFor(cname);
                if (source == null || !(f = this.getFile(source)).isFile()) continue;
                Pattern pattern = Pattern.compile("^.*@.*Component.*$", 2);
                where = ComponentMaker.findHeader(f, pattern);
                if (where != null) {
                    where.set(loc);
                    continue;
                }
                loc.file(source);
                loc.line(1);
            }
        }

        private void createComponentResource(Map<String, Map<String, String>> components, String name, Map<String, String> info) throws Exception {
            boolean designate;
            if (info.containsKey("name:")) {
                name = info.get("name:");
            }
            String impl = name;
            if (info.containsKey("implementation:")) {
                impl = info.get("implementation:");
            }
            Descriptors.TypeRef implRef = this.analyzer.getTypeRefFromFQN(impl);
            this.analyzer.referTo(implRef);
            boolean bl = designate = this.designate(name, info.get("designate:"), false) || this.designate(name, info.get("designateFactory:"), true);
            if (designate && info.get("configuration-policy:") == null) {
                info.put("configuration-policy:", "require");
            }
            Resource resource = this.createComponentResource(name, impl, info);
            String pathSegment = this.analyzer.validResourcePath(name, "Invalid component name");
            this.analyzer.getJar().putResource("OSGI-INF/" + pathSegment + ".xml", resource);
            components.put("OSGI-INF/" + pathSegment + ".xml", EMPTY);
        }

        private boolean designate(String name, String config, boolean factory) throws Exception {
            if (config == null) {
                return false;
            }
            for (String c : Processor.split(config)) {
                Descriptors.TypeRef ref = this.analyzer.getTypeRefFromFQN(c);
                Clazz clazz = this.analyzer.findClass(ref);
                if (clazz != null) {
                    this.analyzer.referTo(ref);
                    MetaTypeReader r = new MetaTypeReader(clazz, this.analyzer);
                    r.setDesignate(name, factory);
                    String rname = "OSGI-INF/metatype/" + name + ".xml";
                    this.analyzer.getJar().putResource(rname, r);
                    continue;
                }
                this.analyzer.error("Cannot find designated configuration class %s for component %s", c, name);
            }
            return true;
        }

        Resource createComponentResource(String name, String impl, Map<String, String> info) throws Exception {
            HeaderReader hr = new HeaderReader(this.analyzer);
            Tag tag = hr.createComponentTag(name, impl, info);
            hr.close();
            return new TagResource(tag);
        }
    }
}

