/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.help.AttrsHandler;
import aQute.lib.converter.Converter;
import aQute.lib.strings.Strings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class SpecialConverter
extends Converter {
    private static final Object[] EMPTY = new Object[0];

    SpecialConverter() {
        this.hook(null, (type, object) -> {
            if (!(object instanceof String)) {
                return null;
            }
            if (SpecialConverter.isSyntaxInterface(type)) {
                Attrs attrs = OSGiHeader.parseProperties((String)object);
                return AttrsHandler.getProperties(attrs, (Class)type);
            }
            String value = (String)object;
            if (type == Attrs.class) {
                return OSGiHeader.parseProperties(value);
            }
            if (type == Parameters.class) {
                return new Parameters(value);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Class rawClass = (Class)ptype.getRawType();
                if (rawClass == Map.class) {
                    if (ptype.getActualTypeArguments()[0] == String.class) {
                        Type valueType = ptype.getActualTypeArguments()[1];
                        Class valueClass = (Class)valueType;
                        Parameters parameters = new Parameters(value);
                        return parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AttrsHandler.getProperties((Attrs)e.getValue(), valueClass)));
                    }
                } else if (Iterable.class.isAssignableFrom(rawClass)) {
                    List<String> parts = Strings.split(value);
                    return this.convert(type, parts);
                }
            }
            return null;
        });
    }

    public static boolean isSyntaxInterface(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class clazz = (Class)type;
        return clazz.isInterface() && !Iterable.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz);
    }

    Object convertNeverNull(Type type, Object value) throws Exception {
        if ((value = super.convert(type, value)) == null) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type rawType = pType.getRawType();
                if (rawType instanceof Class) {
                    Class rawClass = (Class)rawType;
                    if (Map.class.isAssignableFrom(rawClass)) {
                        return super.convert(type, Collections.emptyMap());
                    }
                    if (Iterable.class.isAssignableFrom(rawClass)) {
                        return super.convert(type, (Object)EMPTY);
                    }
                }
            } else {
                if (SpecialConverter.isSyntaxInterface(type)) {
                    return AttrsHandler.getProperties(new Attrs(), (Class)type);
                }
                if (type == Parameters.class) {
                    return new Parameters();
                }
                if (type == Attrs.class) {
                    return new Attrs();
                }
            }
        }
        return value;
    }
}

