/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository.providers;

import aQute.bnd.deployer.repository.api.CheckResult;
import aQute.bnd.deployer.repository.api.Decision;
import aQute.bnd.deployer.repository.api.IRepositoryContentProvider;
import aQute.bnd.deployer.repository.api.IRepositoryIndexProcessor;
import aQute.bnd.deployer.repository.api.Referral;
import aQute.bnd.deployer.repository.providers.AttributeType;
import aQute.bnd.osgi.repository.SimpleIndexer;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.Registry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.resource.Resource;
import org.osgi.service.log.LogService;

public class R5RepoContentProvider
implements IRepositoryContentProvider {
    public static final String NAME = "R5";
    private static final String NS_URI = "http://www.osgi.org/xmlns/repository/v1.0.0";
    private static final String INDEX_NAME_COMPRESSED = "index.xml.gz";
    private static final String INDEX_NAME_PRETTY = "index.xml";
    private static final String TAG_REPOSITORY = "repository";
    private static final String TAG_REFERRAL = "referral";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_CAPABILITY = "capability";
    private static final String TAG_REQUIREMENT = "requirement";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String TAG_DIRECTIVE = "directive";
    private static final String ATTR_REFERRAL_URL = "url";
    private static final String ATTR_REFERRAL_DEPTH = "depth";
    private static final String ATTR_NAMESPACE = "namespace";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDefaultIndexName(boolean pretty) {
        return pretty ? INDEX_NAME_PRETTY : INDEX_NAME_COMPRESSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckResult checkStream(String name, InputStream stream) throws IOException {
        XMLStreamReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
            inputFactory.setProperty("javax.xml.stream.isValidating", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            reader = inputFactory.createXMLStreamReader(stream);
            ParserState state = ParserState.beforeRoot;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        String localName = reader.getLocalName();
                        switch (state) {
                            case beforeRoot: {
                                String nsUri = reader.getNamespaceURI();
                                if (nsUri != null) {
                                    CheckResult checkResult = CheckResult.fromBool(NS_URI.equals(nsUri), "Corrent namespace", "Incorrect namespace: " + nsUri, null);
                                    return checkResult;
                                }
                                if (!TAG_REPOSITORY.equals(localName)) {
                                    CheckResult checkResult = new CheckResult(Decision.reject, "Incorrect root element name", null);
                                    return checkResult;
                                }
                                state = ParserState.inRoot;
                                break;
                            }
                            case inRoot: {
                                if (!TAG_RESOURCE.equals(localName)) break;
                                state = ParserState.inResource;
                                break;
                            }
                            case inResource: {
                                if (TAG_REQUIREMENT.equals(localName)) {
                                    CheckResult checkResult = new CheckResult(Decision.accept, "Recognised element 'requirement' in 'resource'", null);
                                    return checkResult;
                                }
                                if (!TAG_CAPABILITY.equals(localName)) break;
                                state = ParserState.inCapability;
                                break;
                            }
                            case inCapability: {
                                if (!TAG_ATTRIBUTE.equals(localName) && !TAG_DIRECTIVE.equals(localName)) break;
                                CheckResult checkResult = new CheckResult(Decision.accept, "Recognised element '%s' in 'capability'", null);
                                return checkResult;
                            }
                        }
                        break;
                    }
                    case 2: {
                        String localName = reader.getLocalName();
                        if (state == ParserState.inResource && TAG_RESOURCE.equals(localName)) {
                            state = ParserState.inRoot;
                        }
                        if (state != ParserState.inCapability || !TAG_CAPABILITY.equals(localName)) break;
                        state = ParserState.inResource;
                        break;
                    }
                }
            }
            CheckResult checkResult = new CheckResult(Decision.undecided, "Reached end of stream", null);
            return checkResult;
        }
        catch (XMLStreamException e) {
            CheckResult checkResult = new CheckResult(Decision.reject, "Invalid XML", e);
            return checkResult;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseIndex(InputStream stream, URI baseUri, IRepositoryIndexProcessor listener, LogService log) throws Exception {
        XMLStreamReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
            inputFactory.setProperty("javax.xml.stream.isValidating", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            reader = inputFactory.createXMLStreamReader(stream);
            ResourceBuilder resourceBuilder = null;
            CapReqBuilder capReqBuilder = null;
            block11: while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        String valueStr;
                        String name;
                        String localName = reader.getLocalName();
                        if (TAG_REFERRAL.equals(localName)) {
                            String url = reader.getAttributeValue(null, ATTR_REFERRAL_URL);
                            String depth = reader.getAttributeValue(null, ATTR_REFERRAL_DEPTH);
                            Referral referral = new Referral(url, R5RepoContentProvider.parseInt(depth));
                            listener.processReferral(baseUri, referral, 0, 0);
                            break;
                        }
                        if (TAG_RESOURCE.equals(localName)) {
                            resourceBuilder = new ResourceBuilder();
                            break;
                        }
                        if (TAG_CAPABILITY.equals(localName) || TAG_REQUIREMENT.equals(localName)) {
                            String namespace = reader.getAttributeValue(null, ATTR_NAMESPACE);
                            capReqBuilder = new CapReqBuilder(namespace);
                            break;
                        }
                        if (TAG_ATTRIBUTE.equals(localName)) {
                            name = reader.getAttributeValue(null, ATTR_NAME);
                            valueStr = reader.getAttributeValue(null, ATTR_VALUE);
                            String typeAttr = reader.getAttributeValue(null, ATTR_TYPE);
                            if (capReqBuilder == null) continue block11;
                            if ("osgi.content".equals(capReqBuilder.getNamespace()) && ATTR_REFERRAL_URL.equals(name)) {
                                URI resolvedUri = R5RepoContentProvider.resolveUri(valueStr, baseUri);
                                capReqBuilder.addAttribute(name, resolvedUri);
                                break;
                            }
                            Object convertedAttr = R5RepoContentProvider.convertAttribute(valueStr, typeAttr);
                            capReqBuilder.addAttribute(name, convertedAttr);
                            break;
                        }
                        if (!TAG_DIRECTIVE.equals(localName)) break;
                        name = reader.getAttributeValue(null, ATTR_NAME);
                        valueStr = reader.getAttributeValue(null, ATTR_VALUE);
                        if (capReqBuilder == null) continue block11;
                        capReqBuilder.addDirective(name, valueStr);
                        break;
                    }
                    case 2: {
                        String localName = reader.getLocalName();
                        if (TAG_CAPABILITY.equals(localName)) {
                            if (resourceBuilder != null && capReqBuilder != null) {
                                resourceBuilder.addCapability(capReqBuilder);
                            }
                            capReqBuilder = null;
                            break;
                        }
                        if (TAG_REQUIREMENT.equals(localName)) {
                            if (resourceBuilder != null && capReqBuilder != null) {
                                resourceBuilder.addRequirement(capReqBuilder);
                            }
                            capReqBuilder = null;
                            break;
                        }
                        if (!TAG_RESOURCE.equals(localName) || resourceBuilder == null) break;
                        Resource resource = resourceBuilder.build();
                        listener.processResource(resource);
                        resourceBuilder = null;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static URI resolveUri(String uriStr, URI baseUri) throws URISyntaxException {
        URI resourceUri = new URI(uriStr);
        URI resolved = resourceUri.isAbsolute() ? resourceUri : baseUri.resolve(resourceUri);
        return resolved;
    }

    private static int parseInt(String value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    private static Object convertAttribute(String value, String type) {
        AttributeType attType = AttributeType.parseTypeName(type);
        return attType.parseString(value);
    }

    @Override
    public boolean supportsGeneration() {
        return true;
    }

    @Override
    public void generateIndex(Set<File> files, OutputStream output, String repoName, URI baseUri, boolean pretty, Registry registry, LogService log) throws Exception {
        long modified = files.stream().mapToLong(File::lastModified).max().orElse(-1L);
        new SimpleIndexer().files(files).base(baseUri).compress(!pretty).name(repoName).increment(modified).index(output);
    }

    private static enum ParserState {
        beforeRoot,
        inRoot,
        inResource,
        inCapability;

    }
}

