/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.service.reporter.Reporter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterLogService
implements LogService {
    private static final Logger logger = LoggerFactory.getLogger(ReporterLogService.class);
    private final Reporter reporter;

    public ReporterLogService(Reporter reporter) {
        this.reporter = reporter;
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable t) {
        this.log(null, level, message, t);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        switch (level) {
            case 1: {
                if (t == null) {
                    this.reporter.error("%s", message);
                    break;
                }
                this.reporter.exception(t, "%s", message);
                break;
            }
            case 2: {
                if (t == null) {
                    this.reporter.warning("%s", message);
                    break;
                }
                this.reporter.warning("%s [%s]", message, t);
                break;
            }
            case 3: {
                logger.info("{}", (Object)message, (Object)t);
                break;
            }
            default: {
                logger.debug("{}", (Object)message, (Object)t);
            }
        }
    }
}

