/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.deployer.repository.AbstractIndexedRepo;
import aQute.bnd.deployer.repository.RepoConstants;
import aQute.bnd.deployer.repository.api.IRepositoryContentProvider;
import aQute.bnd.filerepo.FileRepo;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResourceHandle;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.cryptography.SHA1;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;

public class LocalIndexedRepo
extends AbstractIndexedRepo
implements Refreshable,
Participant,
Actionable {
    private final String UPWARDS_ARROW = " \u2191";
    private final String DOWNWARDS_ARROW = " \u2193";
    Pattern REPO_FILE = Pattern.compile("([-a-zA-z0-9_\\.]+)(-|_)([0-9\\.]+)(-[-a-zA-z0-9_]+)?\\.(jar|lib)");
    private static final String CACHE_PATH = ".cache";
    public static final String PROP_LOCAL_DIR = "local";
    public static final String PROP_READONLY = "readonly";
    public static final String PROP_PRETTY = "pretty";
    public static final String PROP_OVERWRITE = "overwrite";
    public static final String PROP_ONLYDIRS = "onlydirs";
    private boolean readOnly;
    private boolean pretty = false;
    private boolean overwrite = true;
    private File storageDir;
    private String onlydirs = null;
    private final List<URI> newFilesInCoordination = new LinkedList<URI>();
    private static final String EMPTY_LOCATION = "";
    public static final String PROP_LOCATIONS = "locations";
    public static final String PROP_CACHE = "cache";
    private String locations;
    protected File cacheDir = new File(System.getProperty("user.home") + File.separator + RepoConstants.DEFAULT_CACHE_DIR);

    @Override
    public synchronized void setProperties(Map<String, String> map) {
        String localDirPath;
        super.setProperties(map);
        this.locations = map.get(PROP_LOCATIONS);
        String cachePath = map.get(PROP_CACHE);
        if (cachePath != null) {
            this.cacheDir = new File(cachePath);
            if (!this.cacheDir.isDirectory()) {
                try {
                    throw new IllegalArgumentException(String.format("Cache path '%s' does not exist, or is not a directory.", this.cacheDir.getCanonicalPath()));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not get cacheDir canonical path", e);
                }
            }
        }
        if ((localDirPath = map.get(PROP_LOCAL_DIR)) == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' must be set on %s plugin.", PROP_LOCAL_DIR, this.getClass().getName()));
        }
        this.storageDir = new File(localDirPath);
        if (this.storageDir.exists() && !this.storageDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Local path '%s' exists and is not a directory.", localDirPath));
        }
        this.readOnly = Boolean.parseBoolean(map.get(PROP_READONLY));
        this.pretty = Boolean.parseBoolean(map.get(PROP_PRETTY));
        this.overwrite = map.get(PROP_OVERWRITE) == null ? true : Boolean.parseBoolean(map.get(PROP_OVERWRITE));
        this.onlydirs = map.get(PROP_ONLYDIRS);
        this.cacheDir = new File(this.storageDir, CACHE_PATH);
        if (this.cacheDir.exists() && !this.cacheDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot create repository cache: '%s' already exists but is not directory.", this.cacheDir.getAbsolutePath()));
        }
    }

    @Override
    protected synchronized List<URI> loadIndexes() throws Exception {
        List<Object> remotes;
        try {
            remotes = this.locations != null ? LocalIndexedRepo.parseLocations(this.locations) : Collections.emptyList();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid location, unable to parse as URL list: %s", this.locations), e);
        }
        ArrayList<URI> indexes = new ArrayList<URI>(remotes.size() + this.generatingProviders.size());
        for (IRepositoryContentProvider contentProvider : this.generatingProviders) {
            File indexFile = this.getIndexFile(contentProvider);
            try {
                if (indexFile.exists()) {
                    indexes.add(indexFile.toURI());
                    continue;
                }
                if (!contentProvider.supportsGeneration()) continue;
                this.generateIndex(indexFile, contentProvider);
                indexes.add(indexFile.toURI());
            }
            catch (Exception e) {
                this.logService.log(1, String.format("Unable to load/generate index file '%s' for repository type %s", indexFile, contentProvider.getName()), (Throwable)e);
            }
        }
        indexes.addAll(remotes);
        return indexes;
    }

    @Override
    public synchronized File getCacheDirectory() {
        return this.cacheDir;
    }

    public void setCacheDirectory(File cacheDir) {
        if (cacheDir == null) {
            throw new IllegalArgumentException("null cache directory not permitted");
        }
        this.cacheDir = cacheDir;
    }

    @Override
    public synchronized String getName() {
        if (this.name != null && !this.name.equals(this.getClass().getName())) {
            return this.name;
        }
        return this.locations;
    }

    private File getIndexFile(IRepositoryContentProvider contentProvider) {
        String indexFileName = contentProvider.getDefaultIndexName(this.pretty);
        File indexFile = new File(this.storageDir, indexFileName);
        return indexFile;
    }

    synchronized void regenerateAllIndexes() {
        for (IRepositoryContentProvider provider : this.generatingProviders) {
            if (!provider.supportsGeneration()) {
                this.logService.log(2, String.format("Repository type '%s' does not support index generation.", provider.getName()));
                continue;
            }
            File indexFile = this.getIndexFile(provider);
            try {
                this.generateIndex(indexFile, provider);
            }
            catch (Exception e) {
                this.logService.log(1, String.format("Unable to regenerate index file '%s' for repository type %s", indexFile, provider.getName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void generateIndex(File indexFile, IRepositoryContentProvider provider) throws Exception {
        if (indexFile.exists() && !indexFile.isFile()) {
            throw new IllegalArgumentException(String.format("Cannot create file: '%s' already exists but is not a plain file.", indexFile.getAbsoluteFile()));
        }
        HashSet<File> allFiles = new HashSet<File>();
        this.gatherFiles(allFiles);
        IO.mkdirs(this.storageDir);
        File shaFile = new File(indexFile.getPath() + ".sha");
        try (OutputStream out = IO.outputStream(indexFile);){
            URI rootUri = this.storageDir.getCanonicalFile().toURI();
            provider.generateIndex(allFiles, out, this.getName(), rootUri, this.pretty, this.registry, this.logService);
        }
        finally {
            IO.delete(shaFile);
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        IO.copy(indexFile, md);
        IO.store((Object)Hex.toHexString(md.digest()).toLowerCase(), shaFile);
    }

    private void gatherFiles(Set<File> allFiles) throws Exception {
        if (!this.storageDir.isDirectory()) {
            return;
        }
        LinkedList<File> files = new LinkedList<File>();
        String[] onlydirsFiles = null;
        if (this.onlydirs != null) {
            String[] onlydirs2 = this.onlydirs.split(",");
            onlydirsFiles = new String[onlydirs2.length];
            for (int i = 0; i < onlydirs2.length; ++i) {
                onlydirsFiles[i] = new File(this.storageDir.getAbsolutePath(), onlydirs2[i]).getAbsolutePath();
            }
        }
        this.listRecurse(this.REPO_FILE, onlydirsFiles, this.storageDir, this.storageDir, files);
        allFiles.addAll(files);
    }

    private void listRecurse(final Pattern pattern, final String[] onlydirsFiles, File root, File dir, LinkedList<File> files) {
        final LinkedList dirs = new LinkedList();
        File[] moreFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    boolean addit = true;
                    if (onlydirsFiles != null) {
                        String fabs = f.getAbsolutePath();
                        addit = false;
                        for (String dirtest : onlydirsFiles) {
                            if (!dirtest.startsWith(fabs) && !fabs.startsWith(dirtest)) continue;
                            addit = true;
                            break;
                        }
                    }
                    if (addit) {
                        dirs.add(f);
                    }
                } else if (f.isFile()) {
                    Matcher matcher = pattern.matcher(f.getName());
                    return matcher.matches();
                }
                return false;
            }
        });
        files.addAll(Arrays.asList(moreFiles));
        for (File d : dirs) {
            this.listRecurse(pattern, onlydirsFiles, root, d, files);
        }
    }

    @Override
    public boolean canWrite() {
        return !this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void finishPut() throws Exception {
        this.reset();
        this.regenerateAllIndexes();
        ArrayList<URI> clone = new ArrayList<URI>(this.newFilesInCoordination);
        List<URI> list = this.newFilesInCoordination;
        synchronized (list) {
            this.newFilesInCoordination.clear();
        }
        for (URI entry : clone) {
            File file = new File(entry);
            this.fireBundleAdded(file);
        }
    }

    @Override
    public synchronized void ended(Coordination coordination) throws Exception {
        this.finishPut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Coordination coordination) throws Exception {
        ArrayList<URI> clone;
        List<URI> list = this.newFilesInCoordination;
        synchronized (list) {
            clone = new ArrayList<URI>(this.newFilesInCoordination);
            this.newFilesInCoordination.clear();
        }
        for (URI entry : clone) {
            try {
                IO.deleteWithException(new File(entry));
            }
            catch (Exception e) {
                this.reporter.warning("Failed to remove repository entry %s on coordination rollback: %s", entry, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File putArtifact(File tmpFile) throws Exception {
        assert (tmpFile != null);
        assert (tmpFile.isFile());
        this.init();
        try (Jar jar = new Jar(tmpFile);){
            Coordinator coordinator;
            String bsn = jar.getBsn();
            if (bsn == null || !Verifier.isBsn(bsn)) {
                throw new IllegalArgumentException("Jar does not have a symbolic name");
            }
            File dir = new File(this.storageDir, bsn);
            if (dir.exists() && !dir.isDirectory()) {
                throw new IllegalArgumentException("Path already exists but is not a directory: " + dir.getAbsolutePath());
            }
            IO.mkdirs(dir);
            String versionString = jar.getVersion();
            if (versionString == null) {
                versionString = "0";
            } else if (!Verifier.isVersion(versionString)) {
                throw new IllegalArgumentException("Invalid version " + versionString + " in file " + tmpFile);
            }
            Version version = Version.parseVersion(versionString);
            String fName = bsn + "-" + version.getWithoutQualifier() + ".jar";
            File file = new File(dir, fName);
            if (!this.overwrite && file.exists()) {
                File file2 = null;
                return file2;
            }
            jar.close();
            IO.rename(tmpFile, file);
            List<URI> list = this.newFilesInCoordination;
            synchronized (list) {
                this.newFilesInCoordination.add(file.toURI());
            }
            Coordinator coordinator2 = coordinator = this.registry != null ? this.registry.getPlugin(Coordinator.class) : null;
            if (coordinator == null || !coordinator.addParticipant(this)) {
                this.finishPut();
            }
            File file3 = file;
            return file3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        if (this.readOnly) {
            throw new IOException("Repository is read-only");
        }
        if (options == null) {
            options = DEFAULTOPTIONS;
        }
        if (stream == null) {
            throw new IllegalArgumentException("No stream and/or options specified");
        }
        if (!this.storageDir.isDirectory()) {
            throw new IOException("Repository directory " + this.storageDir + " is not a directory");
        }
        DigestInputStream dis = new DigestInputStream(stream, MessageDigest.getInstance("SHA-1"));
        File tmpFile = null;
        try {
            tmpFile = IO.createTempFile(this.storageDir, "put", ".bnd");
            IO.copy((InputStream)dis, tmpFile);
            byte[] disDigest = dis.getMessageDigest().digest();
            if (options.digest != null && !Arrays.equals(options.digest, disDigest)) {
                throw new IOException("Retrieved artifact digest doesn't match specified digest");
            }
            File file = this.putArtifact(tmpFile);
            RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
            if (file != null) {
                result.digest = disDigest;
                result.artifact = file.toURI();
            }
            RepositoryPlugin.PutResult putResult = result;
            return putResult;
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                IO.delete(tmpFile);
            }
        }
    }

    @Override
    public boolean refresh() {
        this.reset();
        this.regenerateAllIndexes();
        return true;
    }

    @Override
    public synchronized File getRoot() {
        return this.storageDir;
    }

    protected void fireBundleAdded(File file) throws Exception {
        if (this.registry == null) {
            return;
        }
        List<RepositoryListenerPlugin> listeners = this.registry.getPlugins(RepositoryListenerPlugin.class);
        if (listeners.isEmpty()) {
            return;
        }
        try (Jar jar = new Jar(file);){
            for (RepositoryListenerPlugin listener : listeners) {
                try {
                    listener.bundleAdded(this, jar, file);
                }
                catch (Exception e) {
                    if (this.reporter == null) continue;
                    this.reporter.warning("Repository listener threw an unexpected exception: %s", e);
                }
            }
        }
    }

    @Override
    public synchronized String getLocation() {
        String otherPaths;
        StringBuilder builder = new StringBuilder();
        builder.append(this.storageDir.getAbsolutePath());
        String string = otherPaths = this.locations == null ? EMPTY_LOCATION : this.locations.toString();
        if (otherPaths != null && otherPaths.length() > 0) {
            builder.append(", ").append(otherPaths);
        }
        return builder.toString();
    }

    public void setLocations(String locations) throws MalformedURLException, URISyntaxException {
        LocalIndexedRepo.parseLocations(locations);
        this.locations = locations;
    }

    @Override
    public Map<String, Runnable> actions(Object ... target) throws Exception {
        String version;
        String bsn;
        FileRepo storageRepo;
        File f;
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("Refresh", new Runnable(){

            @Override
            public void run() {
                LocalIndexedRepo.this.regenerateAllIndexes();
            }
        });
        if (target.length == 3 && (f = (storageRepo = new FileRepo(this.storageDir)).get(bsn = (String)target[1], new VersionRange(version = (String)target[2], version), 0)) != null) {
            map.put("Delete", new Runnable(){

                @Override
                public void run() {
                    this.deleteEntry(f);
                    LocalIndexedRepo.this.regenerateAllIndexes();
                }

                private void deleteEntry(File f2) {
                    File parent = f2.getParentFile();
                    IO.delete(f2);
                    File[] listFiles = parent.listFiles();
                    if (listFiles.length == 1 && listFiles[0].getName().endsWith("-latest.jar")) {
                        IO.delete(listFiles[0]);
                    }
                    if ((listFiles = parent.listFiles()).length == 0) {
                        IO.delete(parent);
                    }
                }
            });
        }
        return map;
    }

    @Override
    public String tooltip(Object ... target) throws Exception {
        if (target == null || target.length == 0) {
            return "LocalIndexedRepo @ " + this.getLocation();
        }
        if (target.length == 2) {
            ResourceHandle h = this.getHandle(target);
            if (h == null) {
                this.regenerateAllIndexes();
                this.refresh();
                return null;
            }
            if (h.getLocation() == ResourceHandle.Location.remote) {
                return h.getName() + " (remote, not yet cached)";
            }
            return h.request().getAbsolutePath() + "\n" + SHA1.digest(h.request()).asHex() + "\n" + (Object)((Object)h.getLocation());
        }
        return null;
    }

    private ResourceHandle getHandle(Object ... target) throws Exception {
        String bsn = (String)target[0];
        Version v = (Version)target[1];
        VersionRange r = new VersionRange("[" + v.getWithoutQualifier() + "," + v.getWithoutQualifier() + "]");
        ResourceHandle[] handles = this.getHandles(bsn, r.toString());
        if (handles == null || handles.length == 0) {
            return null;
        }
        ResourceHandle h = handles[0];
        return h;
    }

    @Override
    public String title(Object ... target) throws Exception {
        ResourceHandle handle;
        if (target == null) {
            return null;
        }
        if (target.length == 2 && (handle = this.getHandle(target)) != null) {
            String where = EMPTY_LOCATION;
            switch (handle.getLocation()) {
                case local: {
                    where = EMPTY_LOCATION;
                    break;
                }
                case remote: {
                    where = " \u2191";
                    break;
                }
                case remote_cached: {
                    where = " \u2193";
                    break;
                }
                default: {
                    where = "?";
                }
            }
            return target[1] + " " + where;
        }
        return null;
    }

    public void close() {
    }
}

