/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.deployer.repository.MapToDictionaryAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class CapabilityIndex {
    private final Map<String, List<Capability>> capabilityMap = new HashMap<String, List<Capability>>();

    public synchronized void clear() {
        this.capabilityMap.clear();
    }

    public void addResource(Resource resource) {
        this.addCapabilities(resource.getCapabilities(null));
    }

    public void addCapability(Capability cap) {
        this.addCapabilities(Collections.singletonList(cap));
    }

    private synchronized void addCapabilities(Iterable<Capability> capabilities) {
        for (Capability cap : capabilities) {
            List<Capability> list = this.capabilityMap.get(cap.getNamespace());
            if (list == null) {
                list = new LinkedList<Capability>();
                this.capabilityMap.put(cap.getNamespace(), list);
            }
            list.add(cap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMatchingCapabilities(Requirement requirement, Collection<? super Capability> capabilities) {
        List<Capability> caps;
        CapabilityIndex capabilityIndex = this;
        synchronized (capabilityIndex) {
            caps = this.capabilityMap.containsKey(requirement.getNamespace()) ? new ArrayList<Capability>((Collection)this.capabilityMap.get(requirement.getNamespace())) : Collections.emptyList();
        }
        if (caps.isEmpty()) {
            return;
        }
        try {
            String filterStr = (String)requirement.getDirectives().get("filter");
            Filter filter = filterStr != null ? FrameworkUtil.createFilter((String)filterStr) : null;
            for (Capability cap : caps) {
                boolean match = filter == null ? true : filter.match((Dictionary)new MapToDictionaryAdapter(cap.getAttributes()));
                if (!match) continue;
                capabilities.add((Capability)cap);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }
}

