/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.service.ResourceHandle;
import aQute.bnd.service.url.URLConnector;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CachingUriResourceHandle
implements ResourceHandle {
    static final int BUFFER_SIZE = 4096;
    private static final String SHA_256 = "SHA-256";
    static final String FILE_SCHEME = "file";
    static final String FILE_PREFIX = "file:";
    static final String HTTP_SCHEME = "http";
    static final String HTTP_PREFIX = "http:";
    static final String UTF_8 = "UTF-8";
    final File cacheDir;
    final URLConnector connector;
    final URL url;
    String sha;
    final File localFile;
    final File cachedFile;
    final File shaFile;
    final CachingMode mode;
    Reporter reporter;

    public CachingUriResourceHandle(URI uri, File cacheDir, URLConnector connector, String sha) throws IOException {
        this.cacheDir = cacheDir;
        this.connector = connector;
        this.mode = CachingMode.PreferRemote;
        this.sha = sha;
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Relative URIs are not permitted " + uri);
        }
        if (FILE_SCHEME.equals(uri.getScheme())) {
            this.localFile = new File(uri.getPath());
            this.url = uri.toURL();
            this.cachedFile = null;
            this.shaFile = null;
        } else {
            this.url = uri.toURL();
            this.localFile = null;
            this.cachedFile = this.mapRemoteURL(this.url);
            this.shaFile = CachingUriResourceHandle.mapSHAFile(this.cachedFile);
        }
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    static File resolveFile(String baseFileName, String fileName) {
        File resolved;
        File baseFile = new File(baseFileName);
        if (baseFile.isDirectory()) {
            resolved = new File(baseFile, fileName);
        } else if (baseFile.isFile()) {
            resolved = new File(baseFile.getParentFile(), fileName);
        } else {
            throw new IllegalArgumentException("Cannot resolve relative to non-existant base file path: " + baseFileName);
        }
        return resolved;
    }

    private File mapRemoteURL(URL url) throws UnsupportedEncodingException, IOException {
        String localFileName;
        File localDir;
        String fullUrl = url.toExternalForm();
        int lastSlashIndex = fullUrl.lastIndexOf(47);
        if (lastSlashIndex > -1) {
            String localDirName = URLEncoder.encode(fullUrl.substring(0, lastSlashIndex), UTF_8);
            localDir = new File(this.cacheDir, localDirName);
            if (localDir.exists() && !localDir.isDirectory()) {
                localDir = this.cacheDir;
                localFileName = URLEncoder.encode(fullUrl, UTF_8);
            } else {
                localFileName = URLEncoder.encode(fullUrl.substring(lastSlashIndex + 1), UTF_8);
            }
        } else {
            localDir = this.cacheDir;
            localFileName = URLEncoder.encode(fullUrl, UTF_8);
        }
        IO.mkdirs(localDir);
        return new File(localDir, localFileName);
    }

    private static File mapSHAFile(File cachedFile) {
        return new File(cachedFile.getAbsolutePath() + ".sha");
    }

    @Override
    public String getName() {
        return this.url.toString();
    }

    @Override
    public ResourceHandle.Location getLocation() {
        ResourceHandle.Location result = this.localFile != null ? ResourceHandle.Location.local : (this.cachedFile.exists() ? ResourceHandle.Location.remote_cached : ResourceHandle.Location.remote);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File request() throws Exception {
        if (this.localFile != null) {
            return this.localFile;
        }
        if (this.cachedFile == null) {
            throw new IllegalStateException("Invalid URLResourceHandle: both local file and cache file location are uninitialised.");
        }
        boolean cacheExists = this.cachedFile.isFile();
        boolean cacheValidated = false;
        if (cacheExists && this.sha != null) {
            String cachedSHA = this.getCachedSHA();
            cacheValidated = this.sha.equalsIgnoreCase(cachedSHA);
        }
        if (cacheValidated) {
            return this.cachedFile;
        }
        try (InputStream data = this.connector.connect(this.url);){
            this.ensureCacheDirExists();
            String serverSHA = this.copyWithSHA(data, IO.outputStream(this.cachedFile));
            if (this.sha != null && !this.sha.equalsIgnoreCase(serverSHA)) {
                IO.delete(this.shaFile);
                IO.delete(this.cachedFile);
                throw new IOException(String.format("Invalid SHA on remote resource at %s", this.url));
            }
            this.saveSHAFile(serverSHA);
            File file = this.cachedFile;
            return file;
        }
        catch (IOException e) {
            if (this.sha == null) {
                if (cacheExists) {
                    if (this.reporter == null) return this.cachedFile;
                    this.reporter.warning("Using local cache; downloading %s failed (%s).", this.url, e);
                    return this.cachedFile;
                }
                if (this.reporter != null) {
                    this.reporter.error("Downloading %s failed (%s) and cache file %s is not available. Trace: %s", this.url, e, this.cachedFile, CachingUriResourceHandle.collectStackTrace(e));
                }
                throw new IOException(String.format("Downloading %s failed and cache file %s is not available, see log for details.", this.url, this.cachedFile));
            }
            if (this.reporter != null) {
                this.reporter.error("Downloading %s failed (%s) and cache file %s is not available or doesn't match the expected checksum. Trace: %s", this.url, e, this.cachedFile, CachingUriResourceHandle.collectStackTrace(e));
            }
            throw new IOException(String.format("Downloading %s failed and cache file %s is not available or doesn't match the expected checksum, see log for details.", this.url, this.cachedFile));
        }
    }

    private String copyWithSHA(InputStream input, OutputStream output) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA_256);
            DigestOutputStream digestOutput = new DigestOutputStream(output, digest);
            IO.copy(input, (OutputStream)digestOutput);
            String string = Hex.toHexString(digest.digest());
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            IO.close(input);
            IO.close(output);
        }
    }

    private void ensureCacheDirExists() throws IOException {
        if (this.cacheDir.isDirectory()) {
            return;
        }
        if (this.cacheDir.exists()) {
            String message = String.format("Cannot create cache directory in path %s: the path exists but is not a directory", this.cacheDir.getCanonicalPath());
            if (this.reporter != null) {
                this.reporter.error(message, new Object[0]);
            }
            throw new IOException(message);
        }
        try {
            IO.mkdirs(this.cacheDir);
        }
        catch (IOException e) {
            if (this.reporter != null) {
                String message = String.format("Failed to create cache directory in path %s", this.cacheDir.getCanonicalPath());
                this.reporter.exception(e, message, new Object[0]);
            }
            throw e;
        }
    }

    private static String collectStackTrace(Throwable t) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            PrintStream pps = new PrintStream((OutputStream)buffer, false, UTF_8);
            t.printStackTrace(pps);
            return buffer.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    String getCachedSHA() throws IOException {
        String content = this.readSHAFile();
        if (content == null && (content = CachingUriResourceHandle.calculateSHA(this.cachedFile)) != null) {
            this.saveSHAFile(content);
        }
        return content;
    }

    static String calculateSHA(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA_256);
            IO.copy(file, digest);
            return Hex.toHexString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    String readSHAFile() throws IOException {
        String result = this.shaFile != null && this.shaFile.isFile() ? IO.collect(this.shaFile) : null;
        return result;
    }

    void saveSHAFile(String contents) {
        block2: {
            try {
                IO.store((Object)contents, this.shaFile);
            }
            catch (IOException e) {
                IO.delete(this.shaFile);
                if (this.reporter == null) break block2;
                this.reporter.exception(e, "Failed to save SHA file %s (%s)", this.shaFile, e);
            }
        }
    }

    @Deprecated
    public static enum CachingMode {
        PreferCache,
        PreferRemote;

    }
}

