/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.http;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.deployer.http.HttpsUtil;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.service.url.URLConnector;
import aQute.lib.base64.Base64;
import aQute.lib.io.IO;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.glob.Glob;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(name="urlconnector", parameters=Config.class)
public class HttpBasicAuthURLConnector
implements URLConnector,
Plugin {
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthURLConnector.class);
    private static final String PREFIX_PATTERN = "pattern.";
    private static final String PREFIX_USER = "uid.";
    private static final String PREFIX_PASSWORD = "pwd.";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String PREFIX_BASIC_AUTH = "Basic ";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_ETAG = "ETag";
    private static final int RESPONSE_NOT_MODIFIED = 304;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final List<Mapping> mappings = new LinkedList<Mapping>();
    private Reporter reporter;
    private String configFileList;
    private boolean disableSslVerify = false;

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        this.configFileList = map.get("configs");
        if (this.configFileList == null) {
            throw new IllegalArgumentException("'configs' must be specified on HttpBasicAuthURLConnector");
        }
        this.disableSslVerify = "true".equalsIgnoreCase(map.get("disableServerVerify"));
    }

    protected void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.mappings.clear();
            StringTokenizer tokenizer = new StringTokenizer(this.configFileList, ",");
            while (tokenizer.hasMoreTokens()) {
                String configFileName = tokenizer.nextToken().trim();
                File file = new File(configFileName);
                if (!file.exists()) continue;
                UTF8Properties props = new UTF8Properties();
                try {
                    InputStream stream = IO.stream(file);
                    Throwable throwable = null;
                    try {
                        ((Properties)props).load(stream);
                        for (Object key : props.keySet()) {
                            String name = (String)key;
                            if (!name.startsWith(PREFIX_PATTERN)) continue;
                            String id = name.substring(PREFIX_PATTERN.length());
                            Glob glob = new Glob(props.getProperty(name));
                            String uid = props.getProperty(PREFIX_USER + id);
                            String pwd = props.getProperty(PREFIX_PASSWORD + id);
                            this.mappings.add(new Mapping(id, glob, uid, pwd));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException e) {
                    if (this.reporter == null) continue;
                    this.reporter.error("Failed to load %s", configFileName);
                }
            }
        }
    }

    @Override
    public InputStream connect(URL url) throws Exception {
        TaggedData data = this.connectTagged(url, null);
        if (data == null) {
            throw new IOException("HTTP server did not respond with data.");
        }
        return data.getInputStream();
    }

    @Override
    public TaggedData connectTagged(URL url) throws Exception {
        return this.connectTagged(url, null);
    }

    @Override
    public TaggedData connectTagged(URL url, String tag) throws Exception {
        this.init();
        for (Mapping mapping : this.mappings) {
            Matcher matcher = mapping.urlPattern.matcher(url.toString());
            if (!matcher.find()) continue;
            logger.debug("Found username {}, password ***** for URL '{}'. Matched on pattern {}={}", mapping.user, url, mapping.name, mapping.urlPattern);
            return this.connectTagged(url, tag, mapping.user, mapping.pass);
        }
        logger.debug("No username/password found for URL '{}'.", (Object)url);
        return this.connectTagged(url, tag, null, null);
    }

    private TaggedData connectTagged(URL url, String tag, String user, String pass) throws Exception {
        TaggedData result;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            if (this.disableSslVerify) {
                HttpsUtil.disableServerVerification(connection);
            }
        }
        catch (GeneralSecurityException e) {
            if (this.reporter != null) {
                this.reporter.error("Error attempting to disable SSL server certificate verification: %s", e);
            }
            throw new IOException("Error attempting to disable SSL server certificate verification.");
        }
        if (user != null && pass != null) {
            String authString = user + ":" + pass;
            String encoded = Base64.encodeBase64(authString.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty(HEADER_AUTHORIZATION, PREFIX_BASIC_AUTH + encoded);
        }
        if (tag != null) {
            connection.setRequestProperty(HEADER_IF_NONE_MATCH, tag);
        }
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode == 304) {
            result = null;
        } else {
            String responseTag = connection.getHeaderField(HEADER_ETAG);
            result = new TaggedData(connection, connection.getInputStream());
        }
        return result;
    }

    private static class Mapping {
        String name;
        Glob urlPattern;
        String user;
        String pass;

        Mapping(String name, Glob urlPattern, String user, String pass) {
            this.name = name;
            this.urlPattern = urlPattern;
            this.user = user;
            this.pass = pass;
        }
    }

    static @interface Config {
        public String configs();

        public boolean disableServerVerify() default false;
    }
}

