/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.lib.collections.MultiMap;
import aQute.lib.tag.Tag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PropertyDef {
    static final String MARKER = new String("|marker");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*(?<key>[^=\\s:]+)\\s*(?::\\s*(?<type>Boolean|Byte|Character|Short|Integer|Long|Float|Double|String)\\s*)?=(?<value>.*)");
    private final Analyzer analyzer;
    private final MultiMap<String, String> property = new MultiMap();
    private final Map<String, String> propertyType = new HashMap<String, String>();

    PropertyDef(Analyzer analyzer) {
        this.analyzer = Objects.requireNonNull(analyzer);
    }

    boolean isEmpty() {
        return this.property.isEmpty();
    }

    boolean containsKey(String key) {
        return this.property.containsKey(key);
    }

    PropertyDef setProperty(String key, String type, List<String> values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (!values.isEmpty()) {
            this.property.put(key, (String)((Object)values));
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef setProperty(String key, String type, String ... values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (PropertyDef.notEmpty(values)) {
            ArrayList list = new ArrayList(values.length);
            Collections.addAll(list, values);
            this.property.put(key, (String)((Object)list));
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef addProperty(String key, String type, String ... values) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (PropertyDef.notEmpty(values)) {
            this.property.addAll(key, Arrays.asList(values));
            this.propertyType.put(key, type);
        }
        return this;
    }

    PropertyDef setTypedProperty(Descriptors.TypeRef className, String ... props) {
        if (PropertyDef.notEmpty(props)) {
            MultiMap<String, String> map = new MultiMap<String, String>();
            for (String p : props) {
                Matcher m = PROPERTY_PATTERN.matcher(p);
                if (m.matches()) {
                    String key = m.group("key");
                    String type = m.group("type");
                    if (type == null) {
                        type = "String";
                    }
                    this.propertyType.put(key, type);
                    String value = m.group("value");
                    map.add(key, value);
                    continue;
                }
                this.analyzer.error("Malformed property '%s' on component: %s", p, className);
            }
            this.property.putAll(map);
        }
        return this;
    }

    private static boolean notEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    PropertyDef addAll(PropertyDef propertyDef) {
        this.property.putAll(propertyDef.property);
        this.propertyType.putAll(propertyDef.propertyType);
        return this;
    }

    PropertyDef addAll(Collection<PropertyDef> propertyDefs) {
        propertyDefs.forEach(this::addAll);
        return this;
    }

    PropertyDef copy(Function<String, String> keyMapper) {
        PropertyDef copy = new PropertyDef(this.analyzer);
        this.property.keySet().forEach(key -> copy.setProperty((String)keyMapper.apply((String)key), this.propertyType.get(key), (List)this.property.get(key)));
        return copy;
    }

    Stream<Tag> propertyTags(String element) {
        return this.property.keySet().stream().map(name -> {
            Tag tag = new Tag(element, new Object[0]).addAttribute("name", (String)name);
            String type = this.propertyType.get(name);
            tag.addAttribute("type", type);
            List values = (List)this.property.get(name);
            switch (values.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    tag.addAttribute("value", this.check(type, (String)values.get(0)));
                    break;
                }
                default: {
                    tag.addContent(values.stream().filter(v -> v != MARKER).map(v -> this.check(type, (String)v)).collect(Collectors.joining("\n")));
                }
            }
            return tag;
        }).filter(Objects::nonNull);
    }

    private String check(String type, String v) {
        if (type == null) {
            return v;
        }
        try {
            Class<Object> c;
            if (type.equals("Char")) {
                type = "Character";
            }
            if ((c = Class.forName("java.lang." + type)) == String.class) {
                return v;
            }
            v = v.trim();
            if (c == Character.class) {
                c = Integer.class;
            }
            Method m = c.getMethod("valueOf", String.class);
            try {
                m.invoke(null, v);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (ClassNotFoundException e) {
            this.analyzer.error("Invalid data type %s", type);
        }
        catch (NoSuchMethodException e) {
            this.analyzer.error("Cannot convert data %s to type %s", v, type);
        }
        catch (NumberFormatException e) {
            this.analyzer.error("Not a valid number %s for %s, %s", v, type, e.getMessage());
        }
        catch (Throwable e) {
            this.analyzer.error("Cannot convert data %s to type %s", v, type);
        }
        return v;
    }

    public String toString() {
        Iterator i = this.property.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder().append('{');
        while (true) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            b.append(key);
            String type = this.propertyType.get(key);
            if (!type.equals("String")) {
                b.append(':').append(type);
            }
            b.append('=').append(e.getValue());
            if (!i.hasNext()) {
                return b.append('}').toString();
            }
            b.append(',').append(' ');
        }
    }
}

