/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.annotation.xml.XMLAttribute;
import aQute.bnd.component.ComponentDef;
import aQute.bnd.component.DSAnnotations;
import aQute.bnd.component.PropertyDef;
import aQute.bnd.component.ReferenceDef;
import aQute.bnd.component.annotations.CollectionType;
import aQute.bnd.component.annotations.Component;
import aQute.bnd.component.annotations.ConfigurationPolicy;
import aQute.bnd.component.annotations.FieldOption;
import aQute.bnd.component.annotations.Reference;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.component.annotations.ReferencePolicy;
import aQute.bnd.component.annotations.ServiceScope;
import aQute.bnd.component.error.DeclarativeServicesAnnotationError;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.signatures.BaseType;
import aQute.bnd.signatures.ClassResolver;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.FieldResolver;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodResolver;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.VoidDescriptor;
import aQute.bnd.version.Version;
import aQute.bnd.xmlattribute.ExtensionDef;
import aQute.bnd.xmlattribute.XMLAttributeFinder;
import aQute.lib.collections.MultiMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSAnnotationReader
extends ClassDataCollector {
    private static final Logger logger = LoggerFactory.getLogger(DSAnnotationReader.class);
    public static final Version V1_0 = new Version("1.0.0");
    public static final Version V1_1 = new Version("1.1.0");
    public static final Version V1_2 = new Version("1.2.0");
    public static final Version V1_3 = new Version("1.3.0");
    public static final Version V1_4 = new Version("1.4.0");
    private static final Pattern BINDNAME = Pattern.compile("(?:set|add|bind)?(?<name>.*)");
    static final Pattern IDENTIFIERTOPROPERTY = Pattern.compile("(__)|(_)|(\\$_\\$)|(\\$\\$)|(\\$)");
    private static final Instruction COMPONENT_INSTR = new Instruction("org.osgi.service.component.annotations.Component");
    private static final Instruction COMPONENT_PROPERTY_INSTR = new Instruction("org.osgi.service.component.annotations.ComponentPropertyType");
    static final Map<String, Class<?>> wrappers;
    private static final Map.Entry<Pattern, String> unbind1;
    private static final Map.Entry<Pattern, String> unbind2;
    private static final Map.Entry<Pattern, String> updated1;
    private static final Map.Entry<Pattern, String> updated2;
    private static final String constructorArgFormat = "$%03d";
    ComponentDef component;
    final Clazz clazz;
    final ClassSignature classSig;
    Descriptors.TypeRef[] interfaces;
    Clazz.FieldDef member;
    MethodSignature methodSig;
    FieldSignature fieldSig;
    MethodSignature constructorSig;
    int parameter;
    int constructorArg;
    Descriptors.TypeRef className;
    Analyzer analyzer;
    MultiMap<String, Clazz.MethodDef> methods = new MultiMap();
    Descriptors.TypeRef extendsClass;
    boolean baseclass = true;
    final Set<DSAnnotations.Options> options;
    final Map<Object, ReferenceDef> referencesByTarget = new HashMap<Object, ReferenceDef>();
    final XMLAttributeFinder finder;
    Map<String, List<DeclarativeServicesAnnotationError>> mismatchedAnnotations = new HashMap<String, List<DeclarativeServicesAnnotationError>>();
    private int componentPropertyTypeCount = 0;

    DSAnnotationReader(Analyzer analyzer, Clazz clazz, Set<DSAnnotations.Options> options, XMLAttributeFinder finder, Version minVersion) {
        this.analyzer = Objects.requireNonNull(analyzer);
        this.clazz = clazz;
        this.options = options;
        this.finder = finder;
        this.component = new ComponentDef(analyzer, finder, minVersion);
        String signature = clazz.getClassSignature();
        this.classSig = analyzer.getClassSignature(signature != null ? signature : "Ljava/lang/Object;");
    }

    public static ComponentDef getDefinition(Clazz c, Analyzer analyzer, Set<DSAnnotations.Options> options, XMLAttributeFinder finder, Version minVersion) throws Exception {
        DSAnnotationReader r = new DSAnnotationReader(analyzer, c, options, finder, minVersion);
        return r.getDef();
    }

    private ComponentDef getDef() throws Exception {
        if (this.clazz.isEnum() || this.clazz.isInterface() || this.clazz.isAnnotation()) {
            if (this.clazz.is(Clazz.QUERY.ANNOTATED, COMPONENT_INSTR, this.analyzer)) {
                this.analyzer.error("The type %s is not a class and therfore not suitable for the @Component annotation", this.clazz.getFQN()).details(new DeclarativeServicesAnnotationError(this.clazz.getFQN(), null, DeclarativeServicesAnnotationError.ErrorType.INVALID_COMPONENT_TYPE));
            }
            return null;
        }
        if (!this.clazz.is(Clazz.QUERY.ANNOTATED, COMPONENT_INSTR, this.analyzer)) {
            return null;
        }
        this.clazz.parseClassFileWithCollector(this);
        if (this.component.implementation == null) {
            return null;
        }
        if (this.options.contains((Object)DSAnnotations.Options.inherit)) {
            this.baseclass = false;
            while (this.extendsClass != null && !this.extendsClass.isJava()) {
                Clazz ec = this.analyzer.findClass(this.extendsClass);
                if (ec == null) {
                    this.analyzer.error("Missing super class for DS annotations: %s from %s", this.extendsClass, this.clazz.getClassName()).details(new DeclarativeServicesAnnotationError(this.className.getFQN(), null, null, DeclarativeServicesAnnotationError.ErrorType.UNABLE_TO_LOCATE_SUPER_CLASS));
                    break;
                }
                ec.parseClassFileWithCollector(this);
            }
        }
        for (ReferenceDef rdef : this.component.references.values()) {
            if (rdef.bind == null) continue;
            rdef.unbind = this.referredMethod(this.analyzer, rdef, rdef.unbind, unbind1, unbind2);
            rdef.updated = this.referredMethod(this.analyzer, rdef, rdef.updated, updated1, updated2);
            if (rdef.policy != ReferencePolicy.DYNAMIC || rdef.unbind != null) continue;
            this.analyzer.error("In component class %s, reference %s is dynamic but has no unbind method.", this.className.getFQN(), rdef.name).details(this.getDetails(rdef, DeclarativeServicesAnnotationError.ErrorType.DYNAMIC_REFERENCE_WITHOUT_UNBIND));
        }
        return this.component;
    }

    @SafeVarargs
    private final String referredMethod(Analyzer analyzer, ReferenceDef rdef, String value, Map.Entry<Pattern, String> ... matches) {
        if (value == null) {
            String bind = rdef.bind;
            for (Map.Entry<Pattern, String> match : matches) {
                Matcher m = match.getKey().matcher(bind);
                if (!m.matches()) continue;
                value = m.replaceFirst(match.getValue());
                break;
            }
        } else if (value.equals("-")) {
            return null;
        }
        if (this.methods.containsKey(value)) {
            for (Clazz.MethodDef method : (List)this.methods.get(value)) {
                String service = this.determineMethodReferenceType(rdef, method, this.getMethodSignature(method), rdef.service);
                if (service == null) continue;
                return value;
            }
            analyzer.warning("None of the methods related to '%s' in the class '%s' named '%s' for service type '%s' have an acceptable signature. The descriptors found are:", rdef.bind, this.component.implementation, value, rdef.service);
            for (Clazz.MethodDef method : (List)this.methods.get(value)) {
                analyzer.warning("  methodname: %s descriptor: %s", value, method.getDescriptor().toString()).details(this.getDetails(rdef, DeclarativeServicesAnnotationError.ErrorType.UNSET_OR_MODIFY_WITH_WRONG_SIGNATURE));
            }
        }
        return null;
    }

    @Override
    public void annotation(Annotation annotation) {
        try {
            switch (annotation.getName().getFQN()) {
                case "org.osgi.service.component.annotations.Component": {
                    this.doComponent(annotation.getAnnotation(Component.class), annotation);
                    break;
                }
                case "org.osgi.service.component.annotations.Reference": {
                    this.doReference(annotation.getAnnotation(Reference.class), annotation);
                    break;
                }
                case "org.osgi.service.component.annotations.Activate": {
                    this.doActivate(annotation);
                    break;
                }
                case "org.osgi.service.component.annotations.Deactivate": {
                    this.doDeactivate(annotation);
                    break;
                }
                case "org.osgi.service.component.annotations.Modified": {
                    this.doModified(annotation);
                    break;
                }
                case "org.osgi.service.metatype.annotations.Designate": {
                    this.doDesignate(annotation);
                    break;
                }
                case "aQute.bnd.annotation.component.Activate": 
                case "aQute.bnd.annotation.component.Component": 
                case "aQute.bnd.annotation.component.Deactivate": 
                case "aQute.bnd.annotation.component.Modified": 
                case "aQute.bnd.annotation.component.Reference": {
                    this.handleMixedUsageError(annotation);
                    break;
                }
                default: {
                    this.handlePossibleComponentPropertyAnnotation(annotation);
                    XMLAttribute xmlAttr = this.finder.getXMLAttribute(annotation);
                    if (xmlAttr != null) {
                        this.doXmlAttribute(annotation, xmlAttr);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.analyzer.exception(e, "During generation of a component on class %s, exception %s", this.clazz, e);
        }
    }

    private void handleMixedUsageError(Annotation annotation) throws Exception {
        DeclarativeServicesAnnotationError errorDetails;
        switch (annotation.getElementType()) {
            case METHOD: {
                errorDetails = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), this.member.getDescriptor().toString(), DeclarativeServicesAnnotationError.ErrorType.MIXED_USE_OF_DS_ANNOTATIONS_STD);
                break;
            }
            case FIELD: {
                errorDetails = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), DeclarativeServicesAnnotationError.ErrorType.MIXED_USE_OF_DS_ANNOTATIONS_STD);
                break;
            }
            default: {
                errorDetails = new DeclarativeServicesAnnotationError(this.className.getFQN(), null, DeclarativeServicesAnnotationError.ErrorType.MIXED_USE_OF_DS_ANNOTATIONS_STD);
            }
        }
        String fqn = annotation.getName().getFQN();
        List<DeclarativeServicesAnnotationError> errors = this.mismatchedAnnotations.get(fqn);
        if (errors == null) {
            errors = new ArrayList<DeclarativeServicesAnnotationError>();
            this.mismatchedAnnotations.put(fqn, errors);
        }
        errors.add(errorDetails);
    }

    private void handlePossibleComponentPropertyAnnotation(Annotation annotation) throws Exception {
        DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), null, null, DeclarativeServicesAnnotationError.ErrorType.COMPONENT_PROPERTY_ANNOTATION_PROBLEM);
        try {
            Clazz clazz = this.analyzer.findClass(annotation.getName());
            if (clazz == null) {
                this.analyzer.warning("Unable to determine whether the annotation %s applied to type %s is a component property type as it is not on the project build path. If this annotation is a component property type then it must be present on the build path in order to be processed", annotation.getName().getFQN(), this.className.getFQN()).details(details);
                return;
            }
            if (!clazz.is(Clazz.QUERY.ANNOTATED, COMPONENT_PROPERTY_INSTR, this.analyzer)) {
                logger.debug("The annotation {} on component type {} will not be used for properties as the annotation is not annotated with @ComponentPropertyType", (Object)clazz.getFQN(), (Object)this.className.getFQN());
                return;
            }
            String propertyDefKey = String.format("6-annotation-%04d", ++this.componentPropertyTypeCount);
            clazz.parseClassFileWithCollector(new ComponentPropertyTypeDataCollector(propertyDefKey, annotation, details));
        }
        catch (Exception e) {
            this.analyzer.exception(e, "An error occurred when attempting to process annotation %s, applied to component %s", annotation.getName().getFQN(), this.className.getFQN()).details(details);
        }
    }

    private void doXmlAttribute(Annotation annotation, XMLAttribute xmlAttr) {
        ExtensionDef def;
        switch (annotation.getElementType()) {
            case METHOD: 
            case FIELD: {
                def = this.referencesByTarget.computeIfAbsent(this.member, m -> new ReferenceDef(this.finder));
                break;
            }
            case PARAMETER: {
                def = this.referencesByTarget.computeIfAbsent(String.format(constructorArgFormat, this.parameter), m -> new ReferenceDef(this.finder));
                break;
            }
            case TYPE: {
                def = this.component;
                break;
            }
            default: {
                return;
            }
        }
        this.component.updateVersion(V1_1);
        def.addExtensionAttribute(xmlAttr, annotation);
    }

    private void doDesignate(Annotation annotation) {
        if (Boolean.TRUE.equals(annotation.get("factory")) && this.component.configurationPolicy == null) {
            this.component.configurationPolicy = ConfigurationPolicy.REQUIRE;
        }
    }

    private void doActivate(Annotation annotation) {
        String memberDescriptor = this.member.getDescriptor().toString();
        switch (annotation.getElementType()) {
            case METHOD: {
                DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), memberDescriptor, DeclarativeServicesAnnotationError.ErrorType.ACTIVATE_SIGNATURE_ERROR);
                this.component.activate = this.member.getName();
                if (!this.member.isProtected() || !"activate".equals(this.member.getName())) {
                    this.component.updateVersion(V1_1);
                }
                this.processMethodActivationArgs("3-activate-%04d", memberDescriptor, details, false);
                break;
            }
            case FIELD: {
                FieldResolver resolver;
                ReferenceTypeSignature type;
                DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), DeclarativeServicesAnnotationError.ErrorType.ACTIVATE_SIGNATURE_ERROR);
                if (this.fieldSig != null && (type = (resolver = new FieldResolver(this.classSig, this.fieldSig)).resolveField()) instanceof ClassTypeSignature) {
                    this.component.activation_fields.add(this.member.getName());
                    this.component.updateVersion(V1_4);
                    ClassTypeSignature param = (ClassTypeSignature)type;
                    String propertyDefKey = String.format("2-field-%s", this.member.getName());
                    this.processActivationObject(propertyDefKey, param, memberDescriptor, details, false);
                    break;
                }
                this.analyzer.error("Invalid activation object, type %s for field %s", this.member.getDescriptor(), details.fieldName).details(details);
                break;
            }
            case CONSTRUCTOR: {
                DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), memberDescriptor, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR);
                if (this.component.init != null) {
                    this.analyzer.error("Multiple constructors for %s are annotated @Activate.", details.className).details(details);
                    break;
                }
                if (!this.member.isPublic()) {
                    this.analyzer.error("Constructors must be public access.", new Object[0]).details(details);
                    break;
                }
                this.constructorSig = this.methodSig;
                this.component.init = this.constructorSig.parameterTypes.length;
                this.component.updateVersion(V1_4);
                this.constructorArg = 0;
                break;
            }
        }
    }

    private void doDeactivate(Annotation annotation) {
        switch (annotation.getElementType()) {
            case METHOD: {
                String memberDescriptor = this.member.getDescriptor().toString();
                DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), memberDescriptor, DeclarativeServicesAnnotationError.ErrorType.DEACTIVATE_SIGNATURE_ERROR);
                this.component.deactivate = this.member.getName();
                if (!this.member.isProtected() || !"deactivate".equals(this.member.getName())) {
                    this.component.updateVersion(V1_1);
                }
                this.processMethodActivationArgs("5-deactivate-%04d", memberDescriptor, details, true);
                break;
            }
        }
    }

    private void doModified(Annotation annotation) {
        switch (annotation.getElementType()) {
            case METHOD: {
                String memberDescriptor = this.member.getDescriptor().toString();
                DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), memberDescriptor, DeclarativeServicesAnnotationError.ErrorType.MODIFIED_SIGNATURE_ERROR);
                this.component.modified = this.member.getName();
                this.component.updateVersion(V1_1);
                this.processMethodActivationArgs("4-modified-%04d", memberDescriptor, details, false);
                break;
            }
        }
    }

    private void processMethodActivationArgs(String propertyDefKeyFormat, String memberDescriptor, DeclarativeServicesAnnotationError details, boolean deactivate) {
        MethodResolver resolver = new MethodResolver(this.classSig, this.methodSig);
        for (int arg = 0; arg < this.methodSig.parameterTypes.length; ++arg) {
            JavaTypeSignature type = resolver.resolveParameter(arg);
            if (type instanceof ClassTypeSignature) {
                ClassTypeSignature param = (ClassTypeSignature)type;
                String propertyDefKey = String.format(propertyDefKeyFormat, arg);
                this.processActivationObject(propertyDefKey, param, memberDescriptor, details, deactivate);
                continue;
            }
            if (deactivate && type == BaseType.I) {
                this.component.updateVersion(V1_1);
                continue;
            }
            this.analyzer.error("Invalid activation object type %s for parameter %s", type, arg).details(details);
        }
        Result resultType = resolver.resolveResult();
        if (resultType instanceof VoidDescriptor) {
            return;
        }
        if (resultType instanceof ClassTypeSignature && ((ClassTypeSignature)resultType).binary.equals("java/util/Map")) {
            this.checkMapReturnType(details);
        } else {
            this.analyzer.error("Invalid return type type %s", resultType).details(details);
        }
    }

    private void processConstructorActivationArgs(int toArg) {
        String memberDescriptor = this.member.getDescriptor().toString();
        DeclarativeServicesAnnotationError details = new DeclarativeServicesAnnotationError(this.className.getFQN(), this.member.getName(), memberDescriptor, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR);
        MethodResolver resolver = new MethodResolver(this.classSig, this.constructorSig);
        for (int arg = this.constructorArg; arg < toArg; ++arg) {
            JavaTypeSignature type = resolver.resolveParameter(arg);
            if (type instanceof ClassTypeSignature) {
                ClassTypeSignature param = (ClassTypeSignature)type;
                String propertyDefKey = String.format("1-<init>-%04d", arg);
                this.processActivationObject(propertyDefKey, param, memberDescriptor, details, false);
                continue;
            }
            this.analyzer.error("Invalid activation object type %s for constructor parameter %s", type, arg).details(details);
        }
    }

    private void processActivationObject(String propertyDefKey, ClassTypeSignature param, String memberDescriptor, DeclarativeServicesAnnotationError details, boolean deactivate) {
        switch (param.binary) {
            case "org/osgi/service/component/ComponentContext": {
                break;
            }
            case "org/osgi/framework/BundleContext": 
            case "java/util/Map": {
                this.component.updateVersion(V1_1);
                break;
            }
            case "java/lang/Integer": {
                if (deactivate) {
                    this.component.updateVersion(V1_1);
                    break;
                }
            }
            default: {
                Descriptors.TypeRef typeRef = this.analyzer.getTypeRef(param.binary);
                try {
                    Clazz clazz = this.analyzer.findClass(typeRef);
                    if (clazz.isAnnotation()) {
                        this.component.updateVersion(V1_3);
                        clazz.parseClassFileWithCollector(new ComponentPropertyTypeDataCollector(propertyDefKey, memberDescriptor, details));
                        break;
                    }
                    if (clazz.isInterface() && this.options.contains((Object)DSAnnotations.Options.felixExtensions)) {
                        this.component.updateVersion(V1_3);
                        break;
                    }
                    this.analyzer.error("Non annotation type for activation object with descriptor %s, type %s", memberDescriptor, param.binary).details(details);
                    break;
                }
                catch (Exception e) {
                    this.analyzer.exception(e, "Exception looking at annotation type for activation object with descriptor %s, type %s", memberDescriptor, param.binary).details(details);
                }
            }
        }
    }

    private void doReference(Reference reference, Annotation annotation) throws Exception {
        String error;
        Descriptors.TypeRef annoServiceTR;
        ReferenceDef def;
        String paramName = null;
        switch (annotation.getElementType()) {
            case METHOD: 
            case FIELD: {
                def = this.referencesByTarget.computeIfAbsent(this.member, m -> new ReferenceDef(this.finder));
                break;
            }
            case PARAMETER: {
                paramName = String.format(constructorArgFormat, this.parameter);
                def = this.referencesByTarget.computeIfAbsent(paramName, m -> new ReferenceDef(this.finder));
                break;
            }
            default: {
                def = new ReferenceDef(this.finder);
            }
        }
        def.className = this.className.getFQN();
        if (annotation.get("name") != null) {
            def.name = reference.name();
        }
        if (annotation.get("bind") != null) {
            def.bind = reference.bind();
        }
        if (annotation.get("unbind") != null) {
            def.unbind = reference.unbind();
        }
        if (annotation.get("updated") != null) {
            def.updated = reference.updated();
        }
        if (annotation.get("field") != null) {
            def.field = reference.field();
        }
        if (annotation.get("fieldOption") != null) {
            def.fieldOption = reference.fieldOption();
        }
        if (annotation.get("cardinality") != null) {
            def.cardinality = reference.cardinality();
        }
        if (annotation.get("policy") != null) {
            def.policy = reference.policy();
        }
        if (annotation.get("policyOption") != null) {
            def.policyOption = reference.policyOption();
        }
        if (annotation.get("scope") != null) {
            def.scope = reference.scope();
        }
        if (annotation.get("target") != null) {
            def.target = reference.target();
        }
        String annoService = (annoServiceTR = (Descriptors.TypeRef)annotation.get("service")) != null ? annoServiceTR.getFQN() : null;
        switch (annotation.getElementType()) {
            case METHOD: {
                def.bindDescriptor = this.member.getDescriptor().toString();
                def.bind = this.member.getName();
                if (def.name == null) {
                    Matcher m2 = BINDNAME.matcher(this.member.getName());
                    if (m2.matches()) {
                        def.name = m2.group("name");
                    } else {
                        this.analyzer.error("Invalid name for bind method %s", this.member.getName()).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.INVALID_REFERENCE_BIND_METHOD_NAME));
                    }
                }
                def.service = this.determineMethodReferenceType(def, (Clazz.MethodDef)this.member, this.methodSig, annoService);
                if (def.service != null) break;
                this.analyzer.error("In component %s, method %s,  cannot recognize the signature of the descriptor: %s", this.component.effectiveName(), def.name, this.member.getDescriptor()).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.REFERENCE));
                break;
            }
            case FIELD: {
                ClassResolver resolver;
                def.updateVersion(V1_3);
                def.field = this.member.getName();
                if (def.name == null) {
                    def.name = def.field;
                }
                if (this.fieldSig != null) {
                    resolver = new FieldResolver(this.classSig, this.fieldSig);
                    ReferenceTypeSignature type = ((FieldResolver)resolver).resolveField();
                    def.service = this.determineReferenceType(def, type, resolver, annoService);
                }
                if (def.service != null) {
                    if (def.policy == null && this.member.isVolatile()) {
                        def.policy = ReferencePolicy.DYNAMIC;
                    }
                    if (def.isCollection) {
                        if (def.cardinality == null) {
                            def.cardinality = ReferenceCardinality.MULTIPLE;
                        }
                        if (annotation.get("collectionType") != null) {
                            def.collectionType = reference.collectionType();
                        }
                        if (def.isCollectionSubClass && (def.policy != ReferencePolicy.DYNAMIC || def.fieldOption != FieldOption.UPDATE)) {
                            this.analyzer.error("In component %s, collection type field: %s is a subclass of Collection but is not marked policy 'dynamic' and fieldOption 'update'. Changing this to 'dynamic' and 'update'.", this.className, def.field).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.COLLECTION_SUBCLASS_FIELD_WITH_REPLACE));
                            def.policy = ReferencePolicy.DYNAMIC;
                            def.fieldOption = FieldOption.UPDATE;
                        }
                    }
                    if (def.policy != ReferencePolicy.DYNAMIC || def.cardinality != ReferenceCardinality.MULTIPLE && def.cardinality != ReferenceCardinality.AT_LEAST_ONE || !this.member.isFinal()) break;
                    if (def.fieldOption == FieldOption.REPLACE) {
                        this.analyzer.error("In component %s, collection type field: %s is final and dynamic but marked with 'replace' fieldOption. Changing this to 'update'.", this.className, def.field).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.DYNAMIC_FINAL_FIELD_WITH_REPLACE));
                    }
                    def.fieldOption = FieldOption.UPDATE;
                    break;
                }
                this.analyzer.error("In component %s, field %s, cannot recognize the signature of the descriptor: %s", this.component.effectiveName(), def.name, this.member.getDescriptor()).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.REFERENCE));
                break;
            }
            case PARAMETER: {
                if (!"<init>".equals(this.member.getName())) {
                    this.analyzer.error("In component %s, @Reference cannot be used for method parameters", this.className).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.REFERENCE));
                    return;
                }
                if (this.constructorSig == null) {
                    this.analyzer.error("In component %s, @Reference can only be used for parameters on the constructor annotated @Activate", this.className).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR));
                    return;
                }
                this.processConstructorActivationArgs(this.parameter);
                this.constructorArg = this.parameter + 1;
                def.parameter = this.parameter;
                if (def.name == null) {
                    Clazz.MethodParameter[] parameters = ((Clazz.MethodDef)this.member).getParameters();
                    def.name = parameters != null && this.parameter < parameters.length ? parameters[this.parameter].getName() : paramName;
                }
                ClassResolver resolver = new MethodResolver(this.classSig, this.constructorSig);
                JavaTypeSignature type = ((MethodResolver)resolver).resolveParameter(this.parameter);
                def.service = this.determineReferenceType(def, type, resolver, annoService);
                if (def.service != null) {
                    if (def.policy == ReferencePolicy.DYNAMIC) {
                        this.analyzer.error("In component %s, constructor parameters may not be dynamic", this.className).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR));
                        def.policy = ReferencePolicy.STATIC;
                    }
                    if (def.isCollection) {
                        if (def.cardinality == null) {
                            def.cardinality = ReferenceCardinality.MULTIPLE;
                        }
                        if (annotation.get("collectionType") != null) {
                            def.collectionType = reference.collectionType();
                        }
                        if (def.isCollectionSubClass) {
                            this.analyzer.error("In component %s, collection type argument: %s is a subclass of Collection but this is not allowed for a constructor parameter", this.className, def.parameter).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR));
                        }
                    }
                    if (def.fieldOption != FieldOption.UPDATE) break;
                    this.analyzer.error("In component %s, collection type argument: %s is marked with 'update' fieldOption. Changing this to 'replace'.", this.className, def.parameter).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.CONSTRUCTOR_SIGNATURE_ERROR));
                    def.fieldOption = null;
                    break;
                }
                this.analyzer.error("In component %s, constructor argument %s, cannot recognize the signature of the descriptor: %s", this.className, def.parameter, this.member.getDescriptor()).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.REFERENCE));
                break;
            }
            case TYPE: {
                def.service = annoService;
                if (def.name != null) break;
                this.analyzer.error("Name must be supplied for a @Reference specified in the @Component annotation. Service: %s", def.service).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.MISSING_REFERENCE_NAME));
                return;
            }
        }
        if (def.target != null && (error = Verifier.validateFilter(def.target)) != null) {
            this.analyzer.error("Invalid target filter %s for %s: %s", def.target, def.name, error).details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.INVALID_TARGET_FILTER));
        }
        if (this.component.references.containsKey(def.name)) {
            this.analyzer.error("In component %s, multiple references with the same name: %s. Previous def: %s, this def: %s", this.className, this.component.references.get(def.name), def.service, "").details(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.MULTIPLE_REFERENCES_SAME_NAME));
        } else {
            this.component.references.put(def.name, def);
        }
    }

    private DeclarativeServicesAnnotationError getDetails(ReferenceDef def, DeclarativeServicesAnnotationError.ErrorType type) {
        if (def == null) {
            return null;
        }
        if (def.bindDescriptor != null) {
            return new DeclarativeServicesAnnotationError(this.className.getFQN(), def.bind, def.bindDescriptor, type);
        }
        return new DeclarativeServicesAnnotationError(this.className.getFQN(), def.field, type);
    }

    private String determineReferenceType(ReferenceDef def, JavaTypeSignature type, ClassResolver resolver, String annoService) {
        String paramType = null;
        String inferredService = null;
        if (type instanceof ClassTypeSignature) {
            ClassTypeSignature param = (ClassTypeSignature)type;
            switch (paramType = Descriptors.binaryToFQN(param.binary)) {
                default: {
                    if (!this.analyzer.assignable(paramType, "java.util.Collection")) break;
                    def.isCollectionSubClass = true;
                }
                case "java.util.Collection": 
                case "java.util.List": {
                    ReferenceTypeSignature inferred;
                    def.isCollection = true;
                    TypeArgument[] typeArguments = param.classType.typeArguments;
                    if (typeArguments.length == 0 || !((inferred = resolver.resolveType(typeArguments[0])) instanceof ClassTypeSignature)) break;
                    def.collectionType = CollectionType.SERVICE;
                    param = (ClassTypeSignature)inferred;
                    paramType = Descriptors.binaryToFQN(param.binary);
                }
            }
            boolean tryInfer = annoService == null || !annoService.equals(paramType);
            switch (paramType) {
                case "org.osgi.service.component.ComponentServiceObjects": {
                    ReferenceTypeSignature inferred;
                    TypeArgument[] typeArguments;
                    if (!tryInfer) break;
                    if (def.isCollection) {
                        def.collectionType = CollectionType.SERVICEOBJECTS;
                    }
                    if ((typeArguments = param.classType.typeArguments).length == 0 || !((inferred = resolver.resolveType(typeArguments[0])) instanceof ClassTypeSignature)) break;
                    inferredService = Descriptors.binaryToFQN(((ClassTypeSignature)inferred).binary);
                    break;
                }
                case "org.osgi.framework.ServiceReference": {
                    ReferenceTypeSignature inferred;
                    TypeArgument[] typeArguments;
                    if (!tryInfer) break;
                    if (def.isCollection) {
                        def.collectionType = CollectionType.REFERENCE;
                    }
                    if ((typeArguments = param.classType.typeArguments).length == 0 || !((inferred = resolver.resolveType(typeArguments[0])) instanceof ClassTypeSignature)) break;
                    inferredService = Descriptors.binaryToFQN(((ClassTypeSignature)inferred).binary);
                    break;
                }
                case "java.util.Map": {
                    if (!tryInfer || !def.isCollection) break;
                    def.collectionType = CollectionType.PROPERTIES;
                    break;
                }
                case "java.util.Map$Entry": {
                    ReferenceTypeSignature inferred;
                    TypeArgument[] typeArguments;
                    if (!tryInfer) break;
                    if (def.isCollection) {
                        def.collectionType = CollectionType.TUPLE;
                    }
                    if ((typeArguments = param.innerTypes[0].typeArguments).length == 0 || !((inferred = resolver.resolveType(typeArguments[1])) instanceof ClassTypeSignature)) break;
                    inferredService = Descriptors.binaryToFQN(((ClassTypeSignature)inferred).binary);
                    break;
                }
                default: {
                    if (def.isCollection && def.collectionType == null) {
                        def.collectionType = CollectionType.SERVICE;
                        break;
                    }
                    inferredService = paramType;
                }
            }
        }
        if (!this.analyzer.assignable(annoService, inferredService)) {
            if (!def.isCollection && "org.osgi.service.log.LoggerFactory".equals(annoService) && ("org.osgi.service.log.Logger".equals(paramType) || "org.osgi.service.log.FormatterLogger".equals(paramType))) {
                def.updateVersion(V1_4);
            } else {
                return null;
            }
        }
        return annoService != null ? annoService : inferredService;
    }

    private String determineMethodReferenceType(ReferenceDef def, Clazz.MethodDef method, MethodSignature signature, String annoService) {
        JavaTypeSignature first;
        int parameterCount = signature.parameterTypes.length;
        if (parameterCount == 0) {
            return null;
        }
        MethodResolver resolver = new MethodResolver(this.classSig, signature);
        boolean hasMapResultType = false;
        Result resultType = resolver.resolveResult();
        if (!(resultType instanceof VoidDescriptor)) {
            if (resultType instanceof ClassTypeSignature && ((ClassTypeSignature)resultType).binary.equals("java/util/Map")) {
                hasMapResultType = true;
            } else {
                return null;
            }
        }
        if (!((first = resolver.resolveParameter(0)) instanceof ClassTypeSignature)) {
            return null;
        }
        ClassTypeSignature param = (ClassTypeSignature)first;
        Version minVersion = null;
        switch (parameterCount) {
            case 1: {
                if (method.isProtected()) break;
                minVersion = V1_1;
                break;
            }
            case 2: {
                JavaTypeSignature type = resolver.resolveParameter(1);
                if (type instanceof ClassTypeSignature && ((ClassTypeSignature)type).binary.equals("java/util/Map")) {
                    minVersion = V1_1;
                    break;
                }
                minVersion = V1_3;
                break;
            }
            default: {
                minVersion = V1_3;
            }
        }
        String paramType = Descriptors.binaryToFQN(param.binary);
        boolean tryInfer = annoService == null || !annoService.equals(paramType);
        String inferredService = null;
        switch (paramType) {
            case "org.osgi.service.component.ComponentServiceObjects": {
                ReferenceTypeSignature inferred;
                if (!tryInfer) break;
                minVersion = V1_3;
                TypeArgument[] typeArguments = param.classType.typeArguments;
                if (typeArguments.length == 0 || !((inferred = resolver.resolveType(typeArguments[0])) instanceof ClassTypeSignature)) break;
                inferredService = Descriptors.binaryToFQN(((ClassTypeSignature)inferred).binary);
                break;
            }
            case "org.osgi.framework.ServiceReference": {
                ReferenceTypeSignature inferred;
                TypeArgument[] typeArguments;
                if (!tryInfer || (typeArguments = param.classType.typeArguments).length == 0 || !((inferred = resolver.resolveType(typeArguments[0])) instanceof ClassTypeSignature)) break;
                inferredService = Descriptors.binaryToFQN(((ClassTypeSignature)inferred).binary);
                break;
            }
            case "java.util.Map": {
                if (!tryInfer) break;
                minVersion = V1_3;
                break;
            }
            default: {
                inferredService = paramType;
            }
        }
        if (!this.analyzer.assignable(annoService, inferredService)) {
            if ("org.osgi.service.log.LoggerFactory".equals(annoService) && ("org.osgi.service.log.Logger".equals(paramType) || "org.osgi.service.log.FormatterLogger".equals(paramType))) {
                minVersion = V1_4;
            } else {
                return null;
            }
        }
        if (hasMapResultType) {
            this.checkMapReturnType(this.getDetails(def, DeclarativeServicesAnnotationError.ErrorType.REFERENCE));
        }
        if (minVersion != null) {
            def.updateVersion(minVersion);
        }
        return annoService != null ? annoService : inferredService;
    }

    private void checkMapReturnType(DeclarativeServicesAnnotationError details) {
        if (!this.options.contains((Object)DSAnnotations.Options.felixExtensions)) {
            this.analyzer.error("In component %s, to use a return type of Map you must specify the -dsannotations-options felixExtensions flag  and use a felix extension attribute or explicitly specify the appropriate xmlns.", this.className).details(details);
        }
    }

    private void doComponent(Component comp, Annotation annotation) throws Exception {
        String componentName;
        String string = componentName = annotation.containsKey("name") ? comp.name() : this.className.getFQN();
        if (!this.mismatchedAnnotations.isEmpty()) {
            for (Map.Entry<String, List<DeclarativeServicesAnnotationError>> e : this.mismatchedAnnotations.entrySet()) {
                for (DeclarativeServicesAnnotationError errorDetails : e.getValue()) {
                    if (errorDetails.fieldName != null) {
                        this.analyzer.error("The DS component %s uses standard annotations to declare it as a component, but also uses the bnd DS annotation: %s on field %s. It is an error to mix these two types of annotations", componentName, e.getKey(), errorDetails.fieldName).details(errorDetails);
                        continue;
                    }
                    if (errorDetails.methodName != null) {
                        this.analyzer.error("The DS component %s uses standard annotations to declare it as a component, but also uses the bnd DS annotation: %s on method %s with signature %s. It is an error to mix these two types of annotations", componentName, e.getKey(), errorDetails.methodName, errorDetails.methodSignature).details(errorDetails);
                        continue;
                    }
                    this.analyzer.error("The DS component %s uses standard annotations to declare it as a component, but also uses the bnd DS annotation: %s. It is an error to mix these two types of annotations", componentName, e.getKey()).details(errorDetails);
                }
            }
            return;
        }
        if (this.component.implementation != null) {
            return;
        }
        this.component.implementation = this.clazz.getClassName();
        this.component.name = componentName;
        if (annotation.get("factory") != null) {
            this.component.factory = comp.factory();
        }
        if (annotation.get("configurationPolicy") != null) {
            this.component.configurationPolicy = comp.configurationPolicy();
        }
        if (annotation.get("enabled") != null) {
            this.component.enabled = comp.enabled();
        }
        if (annotation.get("factory") != null) {
            this.component.factory = comp.factory();
        }
        if (annotation.get("immediate") != null) {
            this.component.immediate = comp.immediate();
        }
        if (annotation.get("servicefactory") != null) {
            boolean servicefactory = comp.servicefactory();
            ServiceScope serviceScope = this.component.scope = servicefactory ? ServiceScope.BUNDLE : ServiceScope.SINGLETON;
        }
        if (annotation.get("scope") != null && comp.scope() != ServiceScope.DEFAULT) {
            this.component.scope = comp.scope();
            if (comp.scope() == ServiceScope.PROTOTYPE) {
                this.component.updateVersion(V1_3);
            }
        }
        if (annotation.get("configurationPid") != null) {
            this.component.configurationPid = comp.configurationPid();
            if (this.component.configurationPid.length > 1) {
                this.component.updateVersion(V1_3);
            } else {
                this.component.updateVersion(V1_2);
            }
        }
        if (annotation.get("xmlns") != null) {
            this.component.xmlns = comp.xmlns();
        }
        this.component.property.setTypedProperty(this.className, comp.property());
        this.component.factoryProperty.setTypedProperty(this.className, comp.factoryProperty());
        this.component.properties.addProperties(comp.properties());
        this.component.factoryProperties.addProperties(comp.factoryProperties());
        Object[] declaredServices = (Object[])annotation.get("service");
        if (declaredServices == null) {
            if (this.interfaces != null) {
                Descriptors.TypeRef scalaObject = this.analyzer.getTypeRef("scala/ScalaObject");
                this.component.service = (Descriptors.TypeRef[])Stream.of(this.interfaces).filter(i -> !Objects.equals(i, scalaObject)).toArray(Descriptors.TypeRef[]::new);
            }
        } else {
            this.component.service = (Descriptors.TypeRef[])Stream.of(declaredServices).map(Descriptors.TypeRef.class::cast).peek(typeRef -> {
                try {
                    Clazz service = this.analyzer.findClass((Descriptors.TypeRef)typeRef);
                    if (!this.analyzer.assignable(this.clazz, service)) {
                        this.analyzer.error("Class %s is not assignable to specified service %s", this.clazz.getFQN(), typeRef.getFQN()).details(new DeclarativeServicesAnnotationError(this.className.getFQN(), null, null, DeclarativeServicesAnnotationError.ErrorType.INCOMPATIBLE_SERVICE));
                    }
                }
                catch (Exception e) {
                    this.analyzer.exception(e, "An error occurred when attempting to process service %s, applied to component %s", typeRef.getFQN(), this.className.getFQN()).details(new DeclarativeServicesAnnotationError(this.className.getFQN(), null, null, DeclarativeServicesAnnotationError.ErrorType.INCOMPATIBLE_SERVICE));
                }
            }).toArray(Descriptors.TypeRef[]::new);
        }
        this.member = null;
        Object[] refAnnotations = (Object[])annotation.get("reference");
        if (refAnnotations != null) {
            for (Object o : refAnnotations) {
                Annotation refAnnotation = (Annotation)o;
                Reference ref = refAnnotation.getAnnotation(Reference.class);
                this.doReference(ref, refAnnotation);
            }
        }
    }

    @Override
    public void classBegin(int access, Descriptors.TypeRef name) {
        this.className = name;
    }

    @Override
    public void extendsClass(Descriptors.TypeRef name) {
        this.extendsClass = name;
    }

    @Override
    public void implementsInterfaces(Descriptors.TypeRef[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void field(Clazz.FieldDef field) {
        if (field.isStatic()) {
            return;
        }
        this.member = field;
        this.fieldSig = this.getFieldSignature(field);
    }

    private FieldSignature getFieldSignature(Clazz.FieldDef field) {
        String signature = field.getSignature();
        if (signature != null) {
            return this.analyzer.getFieldSignature(signature);
        }
        signature = field.getDescriptor().toString();
        switch (signature.charAt(0)) {
            case 'L': 
            case 'T': 
            case '[': {
                return this.analyzer.getFieldSignature(signature);
            }
        }
        return null;
    }

    @Override
    public void method(Clazz.MethodDef method) {
        if (method.isAbstract() || method.isStatic() || method.isBridge() || method.isSynthetic()) {
            return;
        }
        if (!this.baseclass && method.isPrivate()) {
            return;
        }
        if (this.constructorSig != null) {
            this.processConstructorActivationArgs(this.constructorSig.parameterTypes.length);
            this.constructorSig = null;
        }
        this.member = method;
        this.methods.add(method.getName(), method);
        this.methodSig = this.getMethodSignature(method);
    }

    private MethodSignature getMethodSignature(Clazz.MethodDef method) {
        String signature = method.getSignature();
        return this.analyzer.getMethodSignature(signature != null ? signature : method.getDescriptor().toString());
    }

    @Override
    public void memberEnd() {
        if (this.constructorSig != null) {
            this.processConstructorActivationArgs(this.constructorSig.parameterTypes.length);
            this.constructorSig = null;
        }
        this.member = null;
    }

    @Override
    public void parameter(int p) {
        this.parameter = p;
    }

    static {
        unbind1 = new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("add(.*)"), "remove$1");
        unbind2 = new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("(.*)"), "un$1");
        updated1 = new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("(?:add|set|bind)(.*)"), "updated$1");
        updated2 = new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("(.*)"), "updated$1");
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("boolean", Boolean.class);
        map.put("byte", Byte.class);
        map.put("short", Short.class);
        map.put("char", Character.class);
        map.put("int", Integer.class);
        map.put("long", Long.class);
        map.put("float", Float.class);
        map.put("double", Double.class);
        wrappers = Collections.unmodifiableMap(map);
    }

    final class ComponentPropertyTypeDataCollector
    extends ClassDataCollector {
        private final String propertyDefKey;
        private final String memberDescriptor;
        private final DeclarativeServicesAnnotationError details;
        private final PropertyDef propertyDef;
        private int hasNoDefault;
        private boolean hasValue;
        private boolean hasMethods;
        private Clazz.FieldDef prefixField;
        private Descriptors.TypeRef typeRef;

        ComponentPropertyTypeDataCollector(String propertyDefKey, String memberDescriptor, DeclarativeServicesAnnotationError details) {
            this.propertyDef = new PropertyDef(DSAnnotationReader.this.analyzer);
            this.hasNoDefault = 0;
            this.hasValue = false;
            this.hasMethods = false;
            this.prefixField = null;
            this.typeRef = null;
            this.propertyDefKey = Objects.requireNonNull(propertyDefKey);
            this.memberDescriptor = memberDescriptor;
            this.details = details;
        }

        ComponentPropertyTypeDataCollector(String propertyDefKey, Annotation componentPropertyAnnotation, DeclarativeServicesAnnotationError details) {
            this.propertyDef = new PropertyDef(DSAnnotationReader.this.analyzer);
            this.hasNoDefault = 0;
            this.hasValue = false;
            this.hasMethods = false;
            this.prefixField = null;
            this.typeRef = null;
            this.propertyDefKey = Objects.requireNonNull(propertyDefKey);
            this.memberDescriptor = null;
            this.details = details;
            for (Map.Entry<String, Object> entry : componentPropertyAnnotation.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.handleValue(key, value, value instanceof Descriptors.TypeRef, null);
            }
        }

        @Override
        public void classBegin(int access, Descriptors.TypeRef name) {
            this.typeRef = name;
        }

        @Override
        public void field(Clazz.FieldDef defined) {
            if (defined.isStatic() && defined.getName().equals("PREFIX_")) {
                this.prefixField = defined;
            }
        }

        @Override
        public void method(Clazz.MethodDef defined) {
            if (defined.isStatic()) {
                return;
            }
            this.hasMethods = true;
            if (defined.getName().equals("value")) {
                this.hasValue = true;
            } else {
                ++this.hasNoDefault;
            }
        }

        @Override
        public void annotationDefault(Clazz.MethodDef defined, Object value) {
            Class<?> typeClass;
            boolean isClass;
            String name;
            block10: {
                name = defined.getName();
                if (!name.equals("value")) {
                    --this.hasNoDefault;
                }
                isClass = false;
                typeClass = null;
                Descriptors.TypeRef type = defined.getType().getClassRef();
                if (!type.isPrimitive()) {
                    if (type == DSAnnotationReader.this.analyzer.getTypeRef("java/lang/Class")) {
                        isClass = true;
                    } else {
                        try {
                            Clazz r = DSAnnotationReader.this.analyzer.findClass(type);
                            if (r.isAnnotation()) {
                                DSAnnotationReader.this.analyzer.warning("Nested annotation type found in member %s, %s", name, type.getFQN()).details(this.details);
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (this.memberDescriptor != null) {
                                DSAnnotationReader.this.analyzer.exception(e, "Exception looking at annotation type on member with descriptor %s, type %s", this.memberDescriptor, type).details(this.details);
                                break block10;
                            }
                            DSAnnotationReader.this.analyzer.exception(e, "Exception looking at annotation %s applied to type %s", this.typeRef.getFQN(), DSAnnotationReader.this.className.getFQN()).details(this.details);
                        }
                    }
                } else {
                    typeClass = wrappers.get(type.getFQN());
                }
            }
            if (value != null && !this.propertyDef.containsKey(name)) {
                this.handleValue(name, value, isClass, typeClass);
            }
        }

        @Override
        public void classEnd() throws Exception {
            String singleElementAnnotation;
            String prefix;
            if (this.prefixField != null) {
                Object c = this.prefixField.getConstant();
                if (this.prefixField.isFinal() && this.prefixField.getType() == DSAnnotationReader.this.analyzer.getTypeRef("java/lang/String") && c instanceof String) {
                    prefix = (String)c;
                    if (this.memberDescriptor != null) {
                        DSAnnotationReader.this.component.updateVersion(V1_4);
                    }
                } else {
                    prefix = null;
                    DSAnnotationReader.this.analyzer.warning("Field PREFIX_ in %s is not a static final String field with a compile-time constant value: %s", this.typeRef.getFQN(), c).details(this.details);
                }
            } else {
                prefix = null;
            }
            if (!this.hasMethods) {
                this.hasValue = true;
                this.handleValue("value", Boolean.TRUE, false, Boolean.class);
            }
            if (this.hasValue && this.hasNoDefault == 0) {
                StringBuilder sb = new StringBuilder(this.typeRef.getShorterName());
                boolean lastLowerCase = false;
                for (int i = 0; i < sb.length(); ++i) {
                    char c = sb.charAt(i);
                    if (Character.isUpperCase(c)) {
                        sb.setCharAt(i, Character.toLowerCase(c));
                        if (lastLowerCase) {
                            sb.insert(i++, '.');
                        }
                        lastLowerCase = false;
                        continue;
                    }
                    lastLowerCase = Character.isLowerCase(c);
                }
                singleElementAnnotation = sb.toString();
                if (this.memberDescriptor != null) {
                    DSAnnotationReader.this.component.updateVersion(V1_4);
                }
            } else {
                singleElementAnnotation = null;
            }
            if (!this.propertyDef.isEmpty()) {
                DSAnnotationReader.this.component.propertyDefs.put(this.propertyDefKey, this.propertyDef.copy(key -> {
                    key = singleElementAnnotation != null && key.equals("value") ? singleElementAnnotation : this.identifierToPropertyName((String)key);
                    if (prefix != null) {
                        key = prefix + key;
                    }
                    return key;
                }));
            }
        }

        private void handleValue(String name, Object value, boolean isClass, Class<?> typeClass) {
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                switch (array.length) {
                    case 0: {
                        String type = this.valueType(typeClass, "", isClass);
                        this.propertyDef.setProperty(name, type, new ArrayList<String>());
                        break;
                    }
                    case 1: {
                        value = array[0];
                        String type = this.valueType(typeClass, value, isClass);
                        ArrayList<String> values = new ArrayList<String>(2);
                        values.add(value.toString());
                        values.add(PropertyDef.MARKER);
                        this.propertyDef.setProperty(name, type, values);
                        break;
                    }
                    default: {
                        String type = this.valueType(typeClass, array[0], isClass);
                        List<String> values = Stream.of(array).map(Object::toString).collect(Collectors.toList());
                        this.propertyDef.setProperty(name, type, values);
                        break;
                    }
                }
            } else {
                String type = this.valueType(typeClass, value, isClass);
                this.propertyDef.setProperty(name, type, value.toString());
            }
        }

        private String valueType(Class<?> typeClass, Object value, boolean isClass) {
            if (typeClass != null) {
                return typeClass.getSimpleName();
            }
            if (isClass) {
                return "String";
            }
            return value.getClass().getSimpleName();
        }

        private String identifierToPropertyName(String name) {
            Matcher m = IDENTIFIERTOPROPERTY.matcher(name);
            if (!m.find()) {
                return name;
            }
            StringBuffer b = new StringBuffer();
            do {
                switch (m.group()) {
                    case "__": {
                        m.appendReplacement(b, "_");
                        break;
                    }
                    case "_": {
                        m.appendReplacement(b, ".");
                        break;
                    }
                    case "$_$": {
                        m.appendReplacement(b, "-");
                        break;
                    }
                    case "$$": {
                        m.appendReplacement(b, "\\$");
                        break;
                    }
                    case "$": {
                        m.appendReplacement(b, "");
                        break;
                    }
                    default: {
                        m.appendReplacement(b, m.group());
                        DSAnnotationReader.this.analyzer.error("unknown mapping %s in property name %s", m.group(), name);
                    }
                }
            } while (m.find());
            m.appendTail(b);
            return b.toString();
        }
    }
}

