/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.cdi;

import aQute.bnd.cdi.BeanDef;
import aQute.bnd.cdi.CDIAnnotationReader;
import aQute.bnd.cdi.ReferenceDef;
import aQute.bnd.component.MergedRequirement;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.version.Version;
import aQute.lib.strings.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CDIAnnotations
implements AnalyzerPlugin {
    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Parameters header = OSGiHeader.parseHeader(analyzer.getProperty("-cdiannotations", "*"));
        if (header.size() == 0) {
            return false;
        }
        Instructions instructions = new Instructions(header);
        Collection<Clazz> list = analyzer.getClassspace().values();
        ArrayList<String> names = new ArrayList<String>();
        TreeSet<String> provides = new TreeSet<String>();
        TreeSet<String> requires = new TreeSet<String>();
        block2: for (Clazz c : list) {
            for (Map.Entry<Instruction, Attrs> entry : instructions.entrySet()) {
                List<BeanDef> definitions;
                Instruction instruction = entry.getKey();
                Attrs attrs = entry.getValue();
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated()) continue block2;
                String discover = attrs.get("discover");
                EnumSet<Discover> options = EnumSet.noneOf(Discover.class);
                try {
                    Discover.parse(discover, options, this);
                }
                catch (IllegalArgumentException e) {
                    analyzer.error("Unrecognized discover '%s', expected values are %s", discover, EnumSet.allOf(Discover.class));
                }
                if (options.isEmpty()) {
                    options.add(Discover.annotated_by_bean);
                }
                if (options.contains((Object)Discover.none) || (definitions = CDIAnnotationReader.getDefinition(c, analyzer, options)) == null) continue block2;
                names.add(definitions.get((int)0).implementation.getFQN());
                if (!attrs.containsKey("noservicecapabilities")) {
                    for (BeanDef beanDef : definitions) {
                        if (beanDef.service.isEmpty()) continue;
                        int length = beanDef.service.size();
                        Object[] objectClass = new String[length];
                        for (int i = 0; i < length; ++i) {
                            Descriptors.TypeRef tr = beanDef.service.get(i);
                            objectClass[i] = tr.getFQN();
                        }
                        Arrays.sort(objectClass);
                        this.addServiceCapability((String[])objectClass, provides);
                    }
                }
                if (attrs.containsKey("noservicerequirements")) continue block2;
                MergedRequirement serviceReqMerge = new MergedRequirement("osgi.service");
                for (ReferenceDef ref : definitions.get((int)0).references) {
                    this.addServiceRequirement(ref, serviceReqMerge);
                }
                requires.addAll(serviceReqMerge.toStringList());
                continue block2;
            }
        }
        if (!names.isEmpty()) {
            this.addExtenderRequirement(requires, names, CDIAnnotationReader.V1_0);
        }
        this.updateHeader(analyzer, "Require-Capability", requires);
        this.updateHeader(analyzer, "Provide-Capability", provides);
        return false;
    }

    private void addServiceCapability(String[] objectClass, Set<String> provides) {
        if (objectClass.length > 0) {
            Parameters p = new Parameters();
            Attrs a = new Attrs();
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String oc : objectClass) {
                sb.append(sep).append(oc);
                sep = ",";
            }
            a.put("objectClass:List<String>", sb.toString());
            p.put("osgi.service", a);
            String s = p.toString();
            provides.add(s);
        }
    }

    private void addServiceRequirement(ReferenceDef ref, MergedRequirement requires) {
        String objectClass = ref.service;
        ReferenceCardinality cardinality = ref.cardinality;
        boolean optional = cardinality == ReferenceCardinality.OPTIONAL || cardinality == ReferenceCardinality.MULTIPLE;
        boolean multiple = cardinality == ReferenceCardinality.MULTIPLE || cardinality == ReferenceCardinality.AT_LEAST_ONE;
        String filter = "(objectClass=" + objectClass + ")";
        requires.put(filter, "active", optional, multiple);
    }

    private void addExtenderRequirement(Set<String> requires, List<String> beans, Version version) {
        Version next = version.bumpMajor();
        Parameters p = new Parameters();
        Attrs a = new Attrs();
        a.put("filter:", "\"(&(osgi.extender=osgi.cdi)(version>=" + version + ")(!(version>=" + next + ")))\"");
        a.put("beans:List<String>", String.join((CharSequence)",", beans));
        p.put("osgi.extender", a);
        String s = p.toString();
        requires.add(s);
    }

    private void updateHeader(Analyzer analyzer, String name, TreeSet<String> set) {
        if (!set.isEmpty()) {
            String value = analyzer.getProperty(name);
            if (value != null) {
                Parameters p = OSGiHeader.parseHeader(value);
                for (Map.Entry<String, Attrs> entry : p.entrySet()) {
                    StringBuilder sb = new StringBuilder(entry.getKey());
                    if (entry.getValue() != null) {
                        sb.append(";");
                        entry.getValue().append(sb);
                    }
                    set.add(sb.toString());
                }
            }
            String header = Strings.join(set);
            analyzer.setProperty(name, header);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static enum Discover {
        all,
        annotated,
        annotated_by_bean,
        none;


        static void parse(String s, EnumSet<Discover> options, CDIAnnotations state) {
            if (s == null) {
                return;
            }
            boolean negation = false;
            if (s.startsWith("!")) {
                negation = true;
                s = s.substring(1);
            }
            Discover option = Discover.valueOf(s);
            if (negation) {
                options.remove((Object)option);
            } else {
                options.add(option);
            }
        }
    }
}

