/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.Upload;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.BaseStore;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.s3.S3FileCache;
import com.liferay.portal.store.s3.S3KeyTransformer;
import com.liferay.portal.store.s3.configuration.S3StoreConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.store.s3.configuration.S3StoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.ranking:Integer=0", "store.type=com.liferay.portal.store.s3.S3Store"}, service={Store.class})
public class S3Store
extends BaseStore {
    private static final int _DELETE_MAX = 1000;
    private static final String _ERROR_CODE_FILE_NOT_FOUND = "NoSuchKey";
    private static final int _STATUS_CODE_FILE_NOT_FOUND = 404;
    private static final Log _log = LogFactoryUtil.getLog(S3Store.class);
    private static volatile S3StoreConfiguration _s3StoreConfiguration;
    private AmazonS3 _amazonS3;
    private AWSCredentialsProvider _awsCredentialsProvider;
    private String _bucketName;
    private S3FileCache _s3FileCache;
    private S3KeyTransformer _s3KeyTransformer;
    private StorageClass _storageClass;
    private TransferManager _transferManager;

    public void addDirectory(long companyId, long repositoryId, String dirName) {
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        this.updateFile(companyId, repositoryId, fileName, "1.0", is);
    }

    public void checkRoot(long companyId) {
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        String oldKey = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, fromVersionLabel);
        if (!this._amazonS3.doesObjectExist(this._bucketName, oldKey)) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, fromVersionLabel);
        }
        String newKey = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, toVersionLabel);
        if (this._amazonS3.doesObjectExist(this._bucketName, newKey)) {
            throw new DuplicateFileException(companyId, repositoryId, fileName, toVersionLabel);
        }
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this._bucketName, oldKey, this._bucketName, newKey);
        this._amazonS3.copyObject(copyObjectRequest);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        String key = this._s3KeyTransformer.getDirectoryKey(companyId, repositoryId, dirName);
        this.deleteObjects(key);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) {
        String key = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        this.deleteObjects(key);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        try {
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this._bucketName, key);
            this._amazonS3.deleteObject(deleteObjectRequest);
        }
        catch (AmazonClientException ace) {
            throw this.transform(ace);
        }
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        try {
            S3Object s3Object = this.getS3Object(companyId, repositoryId, fileName, versionLabel);
            File file = this._s3FileCache.getCacheFile(s3Object, fileName);
            this._s3FileCache.cleanUpCacheFiles();
            return file;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        File file = this.getFile(companyId, repositoryId, fileName, versionLabel);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new SystemException((Throwable)fnfe);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) {
        return this.getFileNames(companyId, repositoryId, "");
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String key = null;
        key = Validator.isNull((String)dirName) ? this._s3KeyTransformer.getRepositoryKey(companyId, repositoryId) : this._s3KeyTransformer.getDirectoryKey(companyId, repositoryId, dirName);
        List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(key);
        Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
        String[] fileNames = new String[s3ObjectSummaries.size()];
        for (int i = 0; i < fileNames.length; ++i) {
            S3ObjectSummary s3ObjectSummary = iterator.next();
            fileNames[i] = this._s3KeyTransformer.getFileName(s3ObjectSummary.getKey());
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        String headVersionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, headVersionLabel);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(this._bucketName, key);
        ObjectMetadata objectMetadata = this._amazonS3.getObjectMetadata(getObjectMetadataRequest);
        if (objectMetadata == null) {
            throw new NoSuchFileException(companyId, repositoryId, fileName);
        }
        return objectMetadata.getContentLength();
    }

    public TransferManager getTransferManager() {
        return this._transferManager;
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        return true;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        try {
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            return this._amazonS3.doesObjectExist(this._bucketName, key);
        }
        catch (AmazonClientException ace) {
            if (this.isFileNotFound(ace)) {
                return false;
            }
            throw this.transform(ace);
        }
        catch (NoSuchFileException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            return false;
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        if (repositoryId == newRepositoryId) {
            throw new DuplicateFileException(companyId, newRepositoryId, fileName);
        }
        String oldKey = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        String newKey = this._s3KeyTransformer.getFileKey(companyId, newRepositoryId, fileName);
        this.moveObjects(oldKey, newKey);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException {
        if (fileName.equals(newFileName)) {
            throw new DuplicateFileException(companyId, repositoryId, fileName);
        }
        String oldKey = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        String newKey = this._s3KeyTransformer.getFileKey(companyId, repositoryId, newFileName);
        this.moveObjects(oldKey, newKey);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException {
        if (this.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            throw new DuplicateFileException(companyId, repositoryId, fileName, versionLabel);
        }
        this.putObject(companyId, repositoryId, fileName, versionLabel, file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException {
        if (this.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            throw new DuplicateFileException(companyId, repositoryId, fileName, versionLabel);
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)is);
            this.putObject(companyId, repositoryId, fileName, versionLabel, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        String oldKey = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, fromVersionLabel);
        String newKey = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, toVersionLabel);
        this.moveObjects(oldKey, newKey);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        block2: {
            _s3StoreConfiguration = (S3StoreConfiguration)ConfigurableUtil.createConfigurable(S3StoreConfiguration.class, properties);
            this._awsCredentialsProvider = this.getAWSCredentialsProvider();
            this._amazonS3 = this.getAmazonS3(this._awsCredentialsProvider);
            this._bucketName = _s3StoreConfiguration.bucketName();
            this._transferManager = this.getTransferManager(this._amazonS3);
            try {
                this._storageClass = StorageClass.fromValue((String)_s3StoreConfiguration.s3StorageClass());
            }
            catch (IllegalArgumentException iae) {
                this._storageClass = StorageClass.Standard;
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)(_s3StoreConfiguration.s3StorageClass() + " is not a valid value for the storage class"), (Throwable)iae);
            }
        }
    }

    protected void configureProxySettings(ClientConfiguration clientConfiguration) {
        String proxyHost = _s3StoreConfiguration.proxyHost();
        if (Validator.isNull((String)proxyHost)) {
            return;
        }
        clientConfiguration.setProxyHost(proxyHost);
        clientConfiguration.setProxyPort(_s3StoreConfiguration.proxyPort());
        String proxyAuthType = _s3StoreConfiguration.proxyAuthType();
        if (proxyAuthType.equals("ntlm") || proxyAuthType.equals("username-password")) {
            clientConfiguration.setProxyPassword(_s3StoreConfiguration.proxyPassword());
            clientConfiguration.setProxyUsername(_s3StoreConfiguration.proxyUsername());
            if (proxyAuthType.equals("ntlm")) {
                clientConfiguration.setProxyDomain(_s3StoreConfiguration.ntlmProxyDomain());
                clientConfiguration.setProxyWorkstation(_s3StoreConfiguration.ntlmProxyWorkstation());
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this._amazonS3 = null;
        this._awsCredentialsProvider = null;
        this._bucketName = null;
        _s3StoreConfiguration = null;
    }

    protected void deleteObjects(String prefix) {
        try {
            String[] keys = new String[1000];
            List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(prefix);
            Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
            while (iterator.hasNext()) {
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this._bucketName);
                for (int i = 0; i < keys.length; ++i) {
                    if (!iterator.hasNext()) {
                        keys = Arrays.copyOfRange(keys, 0, i);
                        break;
                    }
                    S3ObjectSummary s3ObjectSummary = iterator.next();
                    keys[i] = s3ObjectSummary.getKey();
                }
                deleteObjectsRequest.withKeys(keys);
                this._amazonS3.deleteObjects(deleteObjectsRequest);
            }
        }
        catch (AmazonClientException ace) {
            throw this.transform(ace);
        }
    }

    protected AmazonS3 getAmazonS3(AWSCredentialsProvider awsCredentialsProvider) {
        ClientConfiguration clientConfiguration = this.getClientConfiguration();
        AmazonS3Client amazonS3 = new AmazonS3Client(awsCredentialsProvider, clientConfiguration);
        Region region = Region.getRegion((Regions)Regions.fromName((String)_s3StoreConfiguration.s3Region()));
        amazonS3.setRegion(region);
        return amazonS3;
    }

    protected AWSCredentialsProvider getAWSCredentialsProvider() {
        if (Validator.isNotNull((String)_s3StoreConfiguration.accessKey()) && Validator.isNotNull((String)_s3StoreConfiguration.secretKey())) {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(_s3StoreConfiguration.accessKey(), _s3StoreConfiguration.secretKey());
            return new StaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        return new DefaultAWSCredentialsProviderChain();
    }

    protected ClientConfiguration getClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setConnectionTimeout(_s3StoreConfiguration.connectionTimeout());
        clientConfiguration.setMaxErrorRetry(_s3StoreConfiguration.httpClientMaxErrorRetry());
        clientConfiguration.setMaxConnections(_s3StoreConfiguration.httpClientMaxConnections());
        this.configureProxySettings(clientConfiguration);
        return clientConfiguration;
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) throws NoSuchFileException {
        String key = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(key);
        Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
        Object[] keys = new String[s3ObjectSummaries.size()];
        for (int i = 0; i < keys.length; ++i) {
            S3ObjectSummary s3ObjectSummary = iterator.next();
            keys[i] = s3ObjectSummary.getKey();
        }
        if (keys.length > 0) {
            Arrays.sort(keys);
            Object headVersionKey = keys[keys.length - 1];
            int x = ((String)headVersionKey).lastIndexOf(47);
            return ((String)headVersionKey).substring(x + 1);
        }
        throw new NoSuchFileException(companyId, repositoryId, fileName);
    }

    protected S3Object getS3Object(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        try {
            String key;
            GetObjectRequest getObjectRequest;
            S3Object s3Object;
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            if ((s3Object = this._amazonS3.getObject(getObjectRequest = new GetObjectRequest(this._bucketName, key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel)))) == null) {
                throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
            }
            return s3Object;
        }
        catch (AmazonClientException ace) {
            if (this.isFileNotFound(ace)) {
                throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
            }
            throw this.transform(ace);
        }
    }

    protected List<S3ObjectSummary> getS3ObjectSummaries(String prefix) {
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
            listObjectsRequest.withBucketName(this._bucketName);
            listObjectsRequest.withPrefix(prefix);
            ObjectListing objectListing = this._amazonS3.listObjects(listObjectsRequest);
            ArrayList<S3ObjectSummary> s3ObjectSummaries = new ArrayList<S3ObjectSummary>(objectListing.getMaxKeys());
            while (true) {
                s3ObjectSummaries.addAll(objectListing.getObjectSummaries());
                if (!objectListing.isTruncated()) break;
                objectListing = this._amazonS3.listNextBatchOfObjects(objectListing);
            }
            return s3ObjectSummaries;
        }
        catch (AmazonClientException ace) {
            throw this.transform(ace);
        }
    }

    protected TransferManager getTransferManager(AmazonS3 amazonS3) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(_s3StoreConfiguration.corePoolSize(), _s3StoreConfiguration.maxPoolSize());
        TransferManager transferManager = new TransferManager(amazonS3, (ExecutorService)executorService, false);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMinimumUploadPartSize((long)_s3StoreConfiguration.minimumUploadPartSize());
        transferManagerConfiguration.setMultipartUploadThreshold(_s3StoreConfiguration.multipartUploadThreshold());
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }

    protected boolean isFileNotFound(AmazonClientException amazonClientException) {
        AmazonServiceException amazonServiceException;
        String errorCode;
        return amazonClientException instanceof AmazonServiceException && (errorCode = (amazonServiceException = (AmazonServiceException)amazonClientException).getErrorCode()).equals(_ERROR_CODE_FILE_NOT_FOUND) && amazonServiceException.getStatusCode() == 404;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.deactivate();
        this.activate(properties);
    }

    protected void moveObjects(String oldPrefix, String newPrefix) throws DuplicateFileException {
        String oldKey;
        ObjectListing objectListing = this._amazonS3.listObjects(this._bucketName, newPrefix);
        List newS3ObjectSummaries = objectListing.getObjectSummaries();
        if (!newS3ObjectSummaries.isEmpty()) {
            throw new DuplicateFileException(StringBundler.concat((String[])new String[]{"Duplicate S3 object found when moving files from ", oldPrefix, " to ", newPrefix}));
        }
        List<S3ObjectSummary> oldS3ObjectSummaries = this.getS3ObjectSummaries(oldPrefix);
        for (S3ObjectSummary s3ObjectSummary : oldS3ObjectSummaries) {
            oldKey = s3ObjectSummary.getKey();
            String newKey = this._s3KeyTransformer.moveKey(oldKey, oldPrefix, newPrefix);
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this._bucketName, oldKey, this._bucketName, newKey);
            this._amazonS3.copyObject(copyObjectRequest);
        }
        for (S3ObjectSummary objectSummary : oldS3ObjectSummaries) {
            oldKey = objectSummary.getKey();
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this._bucketName, oldKey);
            this._amazonS3.deleteObject(deleteObjectRequest);
        }
    }

    protected void putObject(long companyId, long repositoryId, String fileName, String versionLabel, File file) throws PortalException {
        Upload upload = null;
        try {
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this._bucketName, key, file);
            putObjectRequest.withStorageClass(this._storageClass);
            upload = this._transferManager.upload(putObjectRequest);
            upload.waitForCompletion();
        }
        catch (AmazonClientException ace) {
            throw this.transform(ace);
        }
        catch (InterruptedException ie) {
            upload.abort();
            Thread thread = Thread.currentThread();
            thread.interrupt();
        }
    }

    @Reference(unbind="-")
    protected void setS3FileCache(S3FileCache s3FileCache) {
        this._s3FileCache = s3FileCache;
    }

    @Reference(unbind="-")
    protected void setS3KeyTransformer(S3KeyTransformer s3KeyTransformer) {
        this._s3KeyTransformer = s3KeyTransformer;
    }

    protected SystemException transform(AmazonClientException amazonClientException) {
        if (amazonClientException instanceof AmazonServiceException) {
            AmazonServiceException amazonServiceException = (AmazonServiceException)amazonClientException;
            StringBundler sb = new StringBundler(11);
            sb.append("{errorCode=");
            String errorCode = amazonServiceException.getErrorCode();
            sb.append(errorCode);
            sb.append(", errorType=");
            sb.append((Object)amazonServiceException.getErrorType());
            sb.append(", message=");
            sb.append(amazonServiceException.getMessage());
            sb.append(", requestId=");
            sb.append(amazonServiceException.getRequestId());
            sb.append(", statusCode=");
            sb.append(amazonServiceException.getStatusCode());
            sb.append("}");
            if (errorCode.equals("AccessDenied")) {
                return new AccessDeniedException(sb.toString());
            }
            return new SystemException(sb.toString());
        }
        return new SystemException(amazonClientException.getMessage(), (Throwable)amazonClientException);
    }
}

