/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.store.s3.S3FileCache;
import com.liferay.portal.store.s3.S3KeyTransformer;
import com.liferay.portal.store.s3.configuration.S3StoreConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.store.s3.configuration.S3StoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={S3FileCache.class})
public class S3FileCacheImpl
implements S3FileCache {
    private static final String _CACHE_DIR_NAME = "/liferay/s3";
    private static final String _CACHE_DIR_PATTERN = "/yyyy/MM/dd/HH/";
    private static final Log _log = LogFactoryUtil.getLog(S3FileCacheImpl.class);
    private AtomicInteger _cacheDirCleanUpExpunge;
    private AtomicInteger _cacheDirCleanUpFrequency;
    private int _calledCleanUpCacheFilesCount;
    private S3KeyTransformer _s3KeyTransformer;
    private volatile S3StoreConfiguration _s3StoreConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpCacheFiles() {
        ++this._calledCleanUpCacheFilesCount;
        if (this._calledCleanUpCacheFilesCount < this._cacheDirCleanUpFrequency.intValue()) {
            return;
        }
        S3FileCacheImpl s3FileCacheImpl = this;
        synchronized (s3FileCacheImpl) {
            if (this._calledCleanUpCacheFilesCount == 0) {
                return;
            }
            this._calledCleanUpCacheFilesCount = 0;
            String cacheDirName = this.getCacheDirName();
            File cacheDir = new File(cacheDirName);
            long lastModified = System.currentTimeMillis();
            this.cleanUpCacheFiles(cacheDir, lastModified -= (long)this._cacheDirCleanUpExpunge.intValue() * 86400000L);
        }
    }

    @Override
    public File getCacheFile(S3Object s3Object, String fileName) throws IOException {
        StringBundler sb = new StringBundler(4);
        sb.append(this.getCacheDirName());
        sb.append(DateUtil.getCurrentDate((String)_CACHE_DIR_PATTERN, (Locale)LocaleUtil.getDefault()));
        sb.append(this._s3KeyTransformer.getNormalizedFileName(fileName));
        ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
        Date lastModifiedDate = objectMetadata.getLastModified();
        sb.append(lastModifiedDate.getTime());
        String cacheFileName = sb.toString();
        File cacheFile = new File(cacheFileName);
        try (S3ObjectInputStream inputStream = s3Object.getObjectContent();){
            if (cacheFile.exists() && cacheFile.lastModified() >= lastModifiedDate.getTime()) {
                File file = cacheFile;
                return file;
            }
            if (inputStream == null) {
                throw new IOException("S3 object input stream is null");
            }
            File parentFile = cacheFile.getParentFile();
            FileUtil.mkdirs((File)parentFile);
            try (FileOutputStream outputStream = new FileOutputStream(cacheFile);){
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        return cacheFile;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._s3StoreConfiguration = (S3StoreConfiguration)ConfigurableUtil.createConfigurable(S3StoreConfiguration.class, properties);
        this._cacheDirCleanUpExpunge = new AtomicInteger(this._s3StoreConfiguration.cacheDirCleanUpExpunge());
        this._cacheDirCleanUpFrequency = new AtomicInteger(this._s3StoreConfiguration.cacheDirCleanUpFrequency());
    }

    protected void cleanUpCacheFiles(File file, long lastModified) {
        if (!file.isDirectory()) {
            return;
        }
        String[] fileNames = FileUtil.listDirs((File)file);
        if (fileNames.length == 0) {
            if (file.lastModified() < lastModified) {
                FileUtil.deltree((File)file);
                return;
            }
        } else {
            for (String fileName : fileNames) {
                this.cleanUpCacheFiles(new File(file, fileName), lastModified);
            }
            String[] subfileNames = file.list();
            if (subfileNames.length == 0) {
                FileUtil.deltree((File)file);
                return;
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        File cacheDir = new File(this.getCacheDirName());
        boolean deleted = cacheDir.delete();
        if (!deleted && _log.isWarnEnabled()) {
            _log.warn((Object)("Unable to delete " + this.getCacheDirName()));
        }
    }

    protected String getCacheDirName() {
        return SystemProperties.get((String)"java.io.tmpdir") + _CACHE_DIR_NAME;
    }

    @Reference(unbind="-")
    protected void setS3KeyTransformer(S3KeyTransformer s3KeyTransformer) {
        this._s3KeyTransformer = s3KeyTransformer;
    }
}

