/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.store.s3.S3KeyTransformer;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={S3KeyTransformer.class})
public class S3KeyTransformerImpl
implements S3KeyTransformer {
    @Override
    public String getDirectoryKey(long companyId, long repositoryId, String folderName) {
        return this.getFileKey(companyId, repositoryId, folderName);
    }

    @Override
    public String getFileKey(long companyId, long repositoryId, String fileName) {
        StringBundler sb = new StringBundler(4);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append(this.getNormalizedFileName(fileName));
        return sb.toString();
    }

    @Override
    public String getFileName(String key) {
        int x = key.indexOf(47);
        x = key.indexOf(47, x + 1);
        int y = key.lastIndexOf(47);
        return key.substring(x + 1, y);
    }

    @Override
    public String getFileVersionKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        StringBundler sb = new StringBundler(6);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        sb.append(this.getNormalizedFileName(fileName));
        sb.append("/");
        sb.append(versionLabel);
        return sb.toString();
    }

    @Override
    public String getNormalizedFileName(String fileName) {
        String normalizedFileName = fileName;
        if (!fileName.startsWith("/")) {
            normalizedFileName = "/" + normalizedFileName;
        }
        if (fileName.endsWith("/")) {
            normalizedFileName = normalizedFileName.substring(0, normalizedFileName.length() - 1);
        }
        return normalizedFileName;
    }

    @Override
    public String getRepositoryKey(long companyId, long repositoryId) {
        return companyId + "/" + repositoryId;
    }

    @Override
    public String moveKey(String key, String oldPrefix, String newPrefix) {
        String name = key.substring(oldPrefix.length());
        return newPrefix.concat(name);
    }
}

