/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.module.util.BundleUtil;
import com.liferay.portal.spring.extender.internal.configuration.ConfigurationUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import javax.sql.DataSource;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class InitialUpgradeExtender
implements BundleTrackerCustomizer<InitialUpgradeExtension> {
    private static final Log _log = LogFactoryUtil.getLog(InitialUpgradeExtender.class);
    private BundleTracker<?> _bundleTracker;

    public InitialUpgradeExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (!BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
            return null;
        }
        InitialUpgradeExtension initialUpgradeExtension = new InitialUpgradeExtension(bundle);
        initialUpgradeExtension.start();
        return initialUpgradeExtension;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, InitialUpgradeExtension initialUpgradeExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, InitialUpgradeExtension initialUpgradeExtension) {
        initialUpgradeExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private static class InitialUpgradeStep
    implements UpgradeStep {
        private final Bundle _bundle;
        private DataSource _dataSource;
        private DB _db;

        public void setDataSource(DataSource dataSource) {
            this._dataSource = dataSource;
        }

        public String toString() {
            return "Initial Database Creation";
        }

        public void upgrade(DBProcessContext dbProcessContext) throws UpgradeException {
            DBContext dbContext = dbProcessContext.getDBContext();
            DBManager dbManager = dbContext.getDBManager();
            this._db = dbManager.getDB(dbManager.getDBType((Object)DialectDetector.getDialect((DataSource)this._dataSource)), this._dataSource);
            try {
                this._db.process(companyId -> {
                    if (_log.isInfoEnabled() && Validator.isNotNull((Long)companyId)) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{this.toString(), " ", this._bundle.getSymbolicName(), "#", companyId}));
                    }
                    this._upgrade();
                });
            }
            catch (Exception exception) {
                throw new UpgradeException((Throwable)exception);
            }
        }

        private InitialUpgradeStep(Bundle bundle) {
            this._bundle = bundle;
        }

        private void _upgrade() throws UpgradeException {
            block22: {
                String indexesSQL = DBResourceUtil.getModuleIndexesSQL((Bundle)this._bundle);
                String sequencesSQL = DBResourceUtil.getModuleSequencesSQL((Bundle)this._bundle);
                String tablesSQL = DBResourceUtil.getModuleTablesSQL((Bundle)this._bundle);
                try (Connection connection = this._dataSource.getConnection();){
                    if (tablesSQL != null) {
                        try {
                            this._db.runSQLTemplateString(connection, tablesSQL, true);
                        }
                        catch (Exception exception) {
                            throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in tables.sql:\n", tablesSQL}), (Throwable)exception);
                        }
                    }
                    if (sequencesSQL != null) {
                        try {
                            this._db.runSQLTemplateString(connection, sequencesSQL, true);
                        }
                        catch (Exception exception) {
                            throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in sequences.sql:\n", sequencesSQL}), (Throwable)exception);
                        }
                    }
                    if (indexesSQL == null) break block22;
                    try {
                        this._db.runSQLTemplateString(connection, indexesSQL, true);
                    }
                    catch (Exception exception) {
                        throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in indexes.sql:\n", indexesSQL}), (Throwable)exception);
                    }
                }
                catch (SQLException sqlException) {
                    throw new UpgradeException((Throwable)sqlException);
                }
            }
        }
    }

    public class InitialUpgradeExtension {
        private final Bundle _bundle;
        private org.apache.felix.dm.Component _component;
        private final DependencyManager _dependencyManager;

        public InitialUpgradeExtension(Bundle bundle) {
            this._bundle = bundle;
            this._dependencyManager = new DependencyManager(bundle.getBundleContext());
        }

        public void destroy() {
            if (this._component != null) {
                this._dependencyManager.remove(this._component);
            }
        }

        public void start() {
            this._component = this._dependencyManager.createComponent();
            this._component.setInterface(UpgradeStep.class, this._buildServiceProperties());
            this._component.setImplementation((Object)new InitialUpgradeStep(this._bundle));
            ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
            serviceDependency.setCallbacks("setDataSource", null);
            serviceDependency.setRequired(true);
            serviceDependency.setService(DataSource.class, StringBundler.concat((String[])new String[]{"(origin.bundle.symbolic.name=", this._bundle.getSymbolicName(), ")"}));
            this._component.add(new Dependency[]{serviceDependency});
            this._dependencyManager.add(this._component);
        }

        private Dictionary<String, Object> _buildServiceProperties() {
            String buildNumber;
            HashMapDictionary properties = new HashMapDictionary();
            BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
            Configuration configuration = ConfigurationUtil.getConfiguration(bundleWiring.getClassLoader(), "service");
            if (configuration != null && (buildNumber = configuration.get("build.number")) != null) {
                properties.put("build.number", buildNumber);
            }
            properties.put("upgrade.initial.database.creation", "true");
            properties.put("upgrade.bundle.symbolic.name", this._bundle.getSymbolicName());
            properties.put("upgrade.from.schema.version", "0.0.0");
            Dictionary headers = this._bundle.getHeaders("");
            String upgradeToSchemaVersion = GetterUtil.getString((String)((String)headers.get("Liferay-Require-SchemaVersion")), (String)((String)headers.get("Bundle-Version")));
            properties.put("upgrade.to.schema.version", upgradeToSchemaVersion);
            return properties;
        }
    }
}

