/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.extender.internal.bean.ApplicationContextServicePublisherUtil;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContext;
import com.liferay.portal.spring.extender.internal.context.ModuleBeanFactoryPostProcessor;
import com.liferay.portal.spring.extender.internal.loader.ModuleAggregareClassLoader;
import java.beans.Introspector;
import java.util.Dictionary;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ModuleApplicationContextRegistrator {
    private final ClassLoader _classLoader;
    private final ConfigurableApplicationContextConfigurator _configurableApplicationContextConfigurator;
    private volatile ServiceRegistration<DataSource> _dataSourceServiceRegistration;
    private final Bundle _extendeeBundle;
    private final ClassLoader _extendeeClassLoader;
    private final Bundle _extenderBundle;
    private final ModuleApplicationContext _moduleApplicationContext;
    private List<ServiceRegistration<?>> _serviceRegistrations;

    public ModuleApplicationContextRegistrator(ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator, Bundle extendeeBundle, Bundle extenderBundle) {
        this._configurableApplicationContextConfigurator = configurableApplicationContextConfigurator;
        this._extendeeBundle = extendeeBundle;
        this._extenderBundle = extenderBundle;
        BundleWiring extendeeBundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
        this._extendeeClassLoader = extendeeBundleWiring.getClassLoader();
        this._classLoader = new ModuleAggregareClassLoader(this._extendeeClassLoader, this._extendeeBundle.getSymbolicName());
        Dictionary headers = this._extendeeBundle.getHeaders("");
        this._moduleApplicationContext = new ModuleApplicationContext(this._extendeeBundle, this._extendeeClassLoader, this._classLoader, StringUtil.split((String)((String)headers.get("Liferay-Spring-Context")), (char)','));
        this._moduleApplicationContext.addBeanFactoryPostProcessor(beanFactory -> ModuleApplicationContext.registerDataSourceBean(beanFactory, this._extendeeClassLoader));
        this._moduleApplicationContext.addBeanFactoryPostProcessor(new ModuleBeanFactoryPostProcessor(this._extendeeBundle.getBundleContext()));
        this._configurableApplicationContextConfigurator.configure((ConfigurableApplicationContext)this._moduleApplicationContext);
        this._registerDataSource();
    }

    public void stop() {
        ApplicationContextServicePublisherUtil.unregisterContext(this._serviceRegistrations);
        if (this._dataSourceServiceRegistration != null) {
            this._dataSourceServiceRegistration.unregister();
            this._dataSourceServiceRegistration = null;
        }
        this._moduleApplicationContext.close();
    }

    protected void start() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(AggregateClassLoader.getAggregateClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (ClassLoader[])new ClassLoader[]{contextClassLoader}));
        try {
            this._moduleApplicationContext.refresh();
            this._registerDataSource();
            BundleWiring bundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
            PortletBeanLocatorUtil.setBeanLocator((String)this._extendeeBundle.getSymbolicName(), (BeanLocator)new BeanLocatorImpl(bundleWiring.getClassLoader(), (ApplicationContext)this._moduleApplicationContext));
            this._serviceRegistrations = ApplicationContextServicePublisherUtil.registerContext((ConfigurableApplicationContext)this._moduleApplicationContext, this._extendeeBundle.getBundleContext());
        }
        catch (Exception exception) {
            throw new Exception("Unable to start " + this._extendeeBundle.getSymbolicName(), exception);
        }
        finally {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)this._classLoader);
            CachedIntrospectionResults.clearClassLoader((ClassLoader)this._extendeeClassLoader);
            BundleWiring extenderBundleWiring = (BundleWiring)this._extenderBundle.adapt(BundleWiring.class);
            CachedIntrospectionResults.clearClassLoader((ClassLoader)extenderBundleWiring.getClassLoader());
            Introspector.flushCaches();
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private void _registerDataSource() {
        if (this._dataSourceServiceRegistration == null) {
            BundleContext bundleContext = this._extendeeBundle.getBundleContext();
            this._dataSourceServiceRegistration = bundleContext.registerService(DataSource.class, (Object)this._moduleApplicationContext.getDataSource(), MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName()));
        }
    }
}

