/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.internal.loader.ModuleResourceLoader;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceConfigurationInitializer {
    private static final Log _log = LogFactoryUtil.getLog(ServiceConfigurationInitializer.class);
    private final Bundle _bundle;
    private final ClassLoader _classLoader;
    private ServiceRegistration<Configuration> _configurationServiceRegistration;
    private final ServiceComponentConfiguration _serviceComponentConfiguration;
    private final ServiceComponentLocalService _serviceComponentLocalService;
    private final Configuration _serviceConfiguration;

    public ServiceConfigurationInitializer(Bundle bundle, ClassLoader classLoader, Configuration serviceConfiguration, ServiceComponentLocalService serviceComponentLocalService) {
        this._bundle = bundle;
        this._classLoader = classLoader;
        this._serviceConfiguration = serviceConfiguration;
        this._serviceComponentLocalService = serviceComponentLocalService;
        this._serviceComponentConfiguration = new ModuleResourceLoader(bundle);
    }

    public void stop() {
        if (this._configurationServiceRegistration != null) {
            this._configurationServiceRegistration.unregister();
            this._configurationServiceRegistration = null;
        }
    }

    protected void start() {
        this._initServiceComponent();
        BundleContext bundleContext = this._bundle.getBundleContext();
        this._configurationServiceRegistration = bundleContext.registerService(Configuration.class, (Object)this._serviceConfiguration, (Dictionary)HashMapDictionaryBuilder.put((Object)"name", (Object)"service").put((Object)"origin.bundle.symbolic.name", (Object)this._bundle.getSymbolicName()).build());
    }

    private void _initServiceComponent() {
        Properties properties = this._serviceConfiguration.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        String buildNamespace = GetterUtil.getString((String)properties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)properties.getProperty("build.date"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        try {
            this._serviceComponentLocalService.initServiceComponent(this._serviceComponentConfiguration, this._classLoader, buildNamespace, buildNumber, buildDate);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to initialize service component", (Throwable)portalException);
        }
    }
}

