/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.module.util.BundleUtil;
import com.liferay.portal.spring.extender.internal.configuration.ConfigurationUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class PortletConfigurationExtender
implements BundleTrackerCustomizer<PortletConfigurationExtension> {
    private static final Log _log = LogFactoryUtil.getLog(PortletConfigurationExtender.class);
    private BundleTracker<?> _bundleTracker;
    @Reference
    private ResourceActions _resourceActions;

    public PortletConfigurationExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (!BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
            return null;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Configuration portletConfiguration = ConfigurationUtil.getConfiguration(classLoader, "portlet");
        if (portletConfiguration == null) {
            return null;
        }
        PortletConfigurationExtension portletConfigurationExtension = new PortletConfigurationExtension(bundle, classLoader, portletConfiguration);
        portletConfigurationExtension.start();
        return portletConfigurationExtension;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, PortletConfigurationExtension portletConfigurationExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, PortletConfigurationExtension portletConfigurationExtension) {
        portletConfigurationExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    public class PortletConfigurationExtension {
        private final Bundle _bundle;
        private final ClassLoader _classLoader;
        private ServiceRegistration<Configuration> _configurationServiceRegistration;
        private final Configuration _portletConfiguration;

        public void destroy() {
            if (this._configurationServiceRegistration != null) {
                this._configurationServiceRegistration.unregister();
                this._configurationServiceRegistration = null;
            }
        }

        public void start() {
            try {
                PortletConfigurationExtender.this._resourceActions.populateModelResources(this._classLoader, StringUtil.split((String)this._portletConfiguration.get("resource.actions.configs")));
                if (!PropsValues.RESOURCE_ACTIONS_STRICT_MODE_ENABLED) {
                    PortletConfigurationExtender.this._resourceActions.populatePortletResources(this._classLoader, StringUtil.split((String)this._portletConfiguration.get("resource.actions.configs")));
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to read resource actions config in resource.actions.configs", (Throwable)exception);
            }
            BundleContext bundleContext = this._bundle.getBundleContext();
            this._configurationServiceRegistration = bundleContext.registerService(Configuration.class, (Object)this._portletConfiguration, (Dictionary)HashMapDictionaryBuilder.put((Object)"name", (Object)"portlet").put((Object)"origin.bundle.symbolic.name", (Object)this._bundle.getSymbolicName()).build());
        }

        private PortletConfigurationExtension(Bundle bundle, ClassLoader classLoader, Configuration portletConfiguration) {
            this._bundle = bundle;
            this._classLoader = classLoader;
            this._portletConfiguration = portletConfiguration;
        }
    }
}

