/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.bean;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ModuleFrameworkPropsValues;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextServicePublisherUtil {
    private static final Log _log = LogFactoryUtil.getLog(ApplicationContextServicePublisherUtil.class);

    public static List<ServiceRegistration<?>> registerContext(ConfigurableApplicationContext configurableApplicationContext, BundleContext bundleContext) {
        ArrayList serviceRegistrations = new ArrayList();
        ConfigurableListableBeanFactory configurableListableBeanFactory = configurableApplicationContext.getBeanFactory();
        Iterator iterator = configurableListableBeanFactory.getBeanNamesIterator();
        iterator.forEachRemaining(beanName -> {
            try {
                ServiceRegistration<?> serviceRegistration = ApplicationContextServicePublisherUtil._registerService(bundleContext, beanName, configurableApplicationContext.getBean(beanName));
                if (serviceRegistration != null) {
                    serviceRegistrations.add(serviceRegistration);
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to register service " + beanName), (Throwable)exception);
            }
        });
        Bundle bundle = bundleContext.getBundle();
        ServiceRegistration serviceRegistration = bundleContext.registerService(ApplicationContext.class, (Object)configurableApplicationContext, (Dictionary)HashMapDictionaryBuilder.put((Object)"org.springframework.context.service.name", (Object)bundle.getSymbolicName()).build());
        serviceRegistrations.add(serviceRegistration);
        return serviceRegistrations;
    }

    public static void unregisterContext(List<ServiceRegistration<?>> serviceRegistrations) {
        if (serviceRegistrations != null) {
            for (ServiceRegistration<?> serviceReference : serviceRegistrations) {
                serviceReference.unregister();
            }
            serviceRegistrations.clear();
        }
    }

    private static ServiceRegistration<?> _registerService(BundleContext bundleContext, String beanName, Object bean) {
        OSGiBeanProperties osgiBeanProperties;
        Set names;
        Class<?> clazz;
        block6: {
            clazz = bean.getClass();
            if (ProxyUtil.isProxyClass(clazz)) {
                InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)bean);
                Class<?> invocationHandlerClass = invocationHandler.getClass();
                try {
                    Method method = invocationHandlerClass.getMethod("getTarget", new Class[0]);
                    Object target = method.invoke((Object)invocationHandler, new Object[0]);
                    clazz = target.getClass();
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)reflectiveOperationException);
                }
            }
        }
        if ((names = OSGiBeanProperties.Service.interfaceNames((Object)bean, (OSGiBeanProperties)(osgiBeanProperties = (OSGiBeanProperties)AnnotationLocator.locate(clazz, OSGiBeanProperties.class)), (String[])ModuleFrameworkPropsValues.MODULE_FRAMEWORK_SERVICES_IGNORED_INTERFACES)).isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping registration because of an empty list of interfaces");
            }
            return null;
        }
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"bean.id", (Object)beanName).put((Object)"origin.bundle.symbolic.name", () -> {
            Bundle bundle = bundleContext.getBundle();
            return bundle.getSymbolicName();
        }).build();
        if (osgiBeanProperties != null) {
            properties.putAll(OSGiBeanProperties.Convert.toMap((OSGiBeanProperties)osgiBeanProperties));
        }
        return bundleContext.registerService(names.toArray(new String[0]), bean, (Dictionary)properties);
    }
}

