/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal;

import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.dao.orm.hibernate.VerifySessionFactoryWrapper;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.spring.extender.internal.jdbc.DataSourceUtil;
import com.liferay.portal.spring.extender.internal.loader.ModuleAggregareClassLoader;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.spring.hibernate.PortletTransactionManager;
import com.liferay.portal.spring.transaction.DefaultTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionManagerFactory;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.FutureTask;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Component(immediate=true, service={})
public class LiferayServiceExtender
implements BundleTrackerCustomizer<LiferayServiceExtension> {
    private static final Log _log = LogFactoryUtil.getLog(LiferayServiceExtender.class);
    private BundleTracker<?> _bundleTracker;

    public LiferayServiceExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Liferay-Service") == null || headers.get("Liferay-Spring-Context") != null) {
            return null;
        }
        try {
            LiferayServiceExtension liferayServiceExtension = new LiferayServiceExtension(bundle);
            liferayServiceExtension.start();
            return liferayServiceExtension;
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return null;
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, LiferayServiceExtension liferayServiceExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, LiferayServiceExtension liferayServiceExtension) {
        liferayServiceExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        FutureTask<Void> futureTask = new FutureTask<Void>(() -> {
            this._bundleTracker.open();
            return null;
        });
        Thread bundleTrackerOpenerThread = new Thread(futureTask, LiferayServiceExtender.class.getName() + "-BundleTrackerOpener");
        bundleTrackerOpenerThread.setDaemon(true);
        bundleTrackerOpenerThread.start();
        DependencyManagerSyncUtil.registerSyncFuture(futureTask);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    public class LiferayServiceExtension {
        private DataSource _dataSource;
        private final Bundle _extendeeBundle;
        private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
        private SessionFactoryImplementor _sessionFactoryImplementor;

        public void destroy() {
            for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
                serviceRegistration.unregister();
            }
            this._sessionFactoryImplementor.close();
            if (InfrastructureUtil.getDataSource() != this._dataSource) {
                try {
                    DataSourceFactoryUtil.destroyDataSource((DataSource)this._dataSource);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to destroy external data source " + this._dataSource), (Throwable)exception);
                }
            }
        }

        public void start() throws Exception {
            BundleWiring extendeeBundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
            ClassLoader extendeeClassLoader = extendeeBundleWiring.getClassLoader();
            this._dataSource = DataSourceUtil.getDataSource(extendeeClassLoader);
            BundleContext extendeeBundleContext = this._extendeeBundle.getBundleContext();
            this._serviceRegistrations.add(extendeeBundleContext.registerService(DataSource.class, (Object)this._dataSource, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
            ModuleAggregareClassLoader classLoader = new ModuleAggregareClassLoader(extendeeClassLoader, this._extendeeBundle.getSymbolicName());
            PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration((ClassLoader)classLoader, this._dataSource);
            portletHibernateConfiguration.afterPropertiesSet();
            this._sessionFactoryImplementor = (SessionFactoryImplementor)portletHibernateConfiguration.getObject();
            SessionFactoryImpl sessionFactoryImpl = new SessionFactoryImpl();
            sessionFactoryImpl.setSessionFactoryClassLoader((ClassLoader)classLoader);
            sessionFactoryImpl.setSessionFactoryImplementor(this._sessionFactoryImplementor);
            com.liferay.portal.kernel.dao.orm.SessionFactory sessionFactory = VerifySessionFactoryWrapper.createVerifySessionFactoryWrapper((SessionFactoryImpl)sessionFactoryImpl);
            this._serviceRegistrations.add(extendeeBundleContext.registerService(com.liferay.portal.kernel.dao.orm.SessionFactory.class, (Object)sessionFactory, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
            DefaultTransactionExecutor defaultTransactionExecutor = this._getTransactionExecutor(this._dataSource, this._sessionFactoryImplementor);
            this._serviceRegistrations.add(extendeeBundleContext.registerService(new String[]{TransactionExecutor.class.getName(), TransactionHandler.class.getName()}, (Object)defaultTransactionExecutor, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
        }

        private LiferayServiceExtension(Bundle extendeeBundle) {
            this._extendeeBundle = extendeeBundle;
        }

        private DefaultTransactionExecutor _getTransactionExecutor(DataSource liferayDataSource, SessionFactoryImplementor sessionFactoryImplementor) {
            Object platformTransactionManager = null;
            platformTransactionManager = InfrastructureUtil.getDataSource() == liferayDataSource ? new PortletTransactionManager((HibernateTransactionManager)InfrastructureUtil.getTransactionManager(), (SessionFactory)sessionFactoryImplementor) : TransactionManagerFactory.createTransactionManager((DataSource)liferayDataSource, (SessionFactory)sessionFactoryImplementor);
            return new DefaultTransactionExecutor((PlatformTransactionManager)platformTransactionManager);
        }
    }
}

