/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.internal.loader.ModuleResourceLoader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceConfigurationInitializer {
    private static final Log _log = LogFactoryUtil.getLog(ServiceConfigurationInitializer.class);
    private final Bundle _bundle;
    private final ClassLoader _classLoader;
    private final Configuration _portletConfiguration;
    private final ResourceActions _resourceActions;
    private final ServiceComponentConfiguration _serviceComponentConfiguration;
    private final ServiceComponentLocalService _serviceComponentLocalService;
    private final Configuration _serviceConfiguration;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public ServiceConfigurationInitializer(Bundle bundle, ClassLoader classLoader, Configuration portletConfiguration, Configuration serviceConfiguration, ResourceActions resourceActions, ServiceComponentLocalService serviceComponentLocalService) {
        this._bundle = bundle;
        this._classLoader = classLoader;
        this._portletConfiguration = portletConfiguration;
        this._serviceConfiguration = serviceConfiguration;
        this._serviceComponentConfiguration = new ModuleResourceLoader(bundle);
        this._resourceActions = resourceActions;
        this._serviceComponentLocalService = serviceComponentLocalService;
    }

    public void stop() {
        this._serviceComponentLocalService.destroyServiceComponent(this._serviceComponentConfiguration, this._classLoader);
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
    }

    protected void start() {
        BundleContext bundleContext = this._bundle.getBundleContext();
        if (this._portletConfiguration != null) {
            this._readResourceActions();
            this._registerConfiguration(bundleContext, this._portletConfiguration, "portlet");
        }
        if (this._serviceConfiguration != null) {
            this._initServiceComponent();
            this._registerConfiguration(bundleContext, this._serviceConfiguration, "service");
        }
    }

    private void _initServiceComponent() {
        Properties properties = this._serviceConfiguration.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        String buildNamespace = GetterUtil.getString((String)properties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)properties.getProperty("build.date"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        try {
            this._serviceComponentLocalService.initServiceComponent(this._serviceComponentConfiguration, this._classLoader, buildNamespace, buildNumber, buildDate);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to initialize service component", (Throwable)pe);
        }
    }

    private void _readResourceActions() {
        try {
            String portlets = this._portletConfiguration.get("service.configurator.portlet.ids");
            if (Validator.isNull((String)portlets)) {
                this._resourceActions.readAndCheck(null, this._classLoader, StringUtil.split((String)this._portletConfiguration.get("resource.actions.configs")));
            } else {
                this._resourceActions.read(null, this._classLoader, StringUtil.split((String)this._portletConfiguration.get("resource.actions.configs")));
                for (String portletId : StringUtil.split((String)portlets)) {
                    this._resourceActions.check(portletId);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to read resource actions config in resource.actions.configs", (Throwable)e);
        }
    }

    private void _registerConfiguration(BundleContext bundleContext, Configuration configuration, String name) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("name", name);
        properties.put("origin.bundle.symbolic.name", this._bundle.getSymbolicName());
        this._serviceRegistrations.add(bundleContext.registerService(Configuration.class, (Object)configuration, (Dictionary)properties));
    }
}

