/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.spring.extender.internal.configuration.ConfigurationUtil;
import com.liferay.portal.spring.extender.internal.configuration.ServiceConfigurationInitializer;
import java.util.Dictionary;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class ServiceConfigurationExtender
implements BundleTrackerCustomizer<ServiceConfigurationExtension> {
    private static final Log _log = LogFactoryUtil.getLog(ServiceConfigurationExtender.class);
    private BundleTracker<?> _bundleTracker;
    @Reference(target="(module.service.lifecycle=database.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;

    public ServiceConfigurationExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Liferay-Service") == null) {
            return null;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Configuration portletConfiguration = ConfigurationUtil.getConfiguration(classLoader, "portlet");
        Configuration serviceConfiguration = ConfigurationUtil.getConfiguration(classLoader, "service");
        if (portletConfiguration == null && serviceConfiguration == null) {
            return null;
        }
        String requireSchemaVersion = (String)headers.get("Liferay-Require-SchemaVersion");
        ServiceConfigurationInitializer serviceConfigurationInitializer = new ServiceConfigurationInitializer(bundle, classLoader, portletConfiguration, serviceConfiguration, this._resourceActions, this._serviceComponentLocalService);
        ServiceConfigurationExtension serviceConfigurationExtension = new ServiceConfigurationExtension(bundle, requireSchemaVersion, serviceConfigurationInitializer);
        serviceConfigurationExtension.start();
        return serviceConfigurationExtension;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceConfigurationExtension serviceConfigurationExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceConfigurationExtension serviceConfigurationExtension) {
        serviceConfigurationExtension.destroy();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    public static class ServiceConfigurationExtension {
        private final org.apache.felix.dm.Component _component;
        private final DependencyManager _dependencyManager;

        public void destroy() {
            this._dependencyManager.remove(this._component);
        }

        public void start() {
            this._dependencyManager.add(this._component);
        }

        private ServiceConfigurationExtension(Bundle bundle, String requireSchemaVersion, ServiceConfigurationInitializer serviceConfigurationInitializer) {
            String versionRangeFilter;
            block6: {
                this._dependencyManager = new DependencyManager(bundle.getBundleContext());
                this._component = this._dependencyManager.createComponent();
                this._component.setImplementation((Object)serviceConfigurationInitializer);
                if (requireSchemaVersion == null) {
                    return;
                }
                versionRangeFilter = null;
                try {
                    Version version = new Version(requireSchemaVersion);
                    versionRangeFilter = this._getVersionRangerFilter(version);
                }
                catch (IllegalArgumentException iae) {
                    try {
                        VersionRange versionRange = new VersionRange(requireSchemaVersion);
                        versionRangeFilter = versionRange.toFilterString("release.schema.version");
                    }
                    catch (IllegalArgumentException iae2) {
                        iae.addSuppressed(iae2);
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn((Object)("Invalid \"Liferay-Require-SchemaVersion\" header for bundle: " + bundle.getBundleId()), (Throwable)iae);
                    }
                }
            }
            if (versionRangeFilter == null) {
                return;
            }
            ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
            serviceDependency.setRequired(true);
            serviceDependency.setService(Release.class, StringBundler.concat((String[])new String[]{"(&(release.bundle.symbolic.name=", bundle.getSymbolicName(), ")", versionRangeFilter, "(|(!(release.state=*))(release.state=0)))"}));
            this._component.add((Dependency)serviceDependency);
        }

        private String _getVersionRangerFilter(Version version) {
            StringBundler sb = new StringBundler(9);
            sb.append("(&(release.schema.version>=");
            sb.append(version.getMajor());
            sb.append(".");
            sb.append(version.getMinor());
            sb.append(".0)(!(release.schema.version>=");
            sb.append(version.getMajor());
            sb.append(".");
            sb.append(version.getMinor() + 1);
            sb.append(".0)))");
            return sb.toString();
        }
    }
}

