/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.social.activity.extender.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.social.kernel.util.SocialConfiguration;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;

public class SocialActivityExtenderBundleActivator
implements BundleActivator {
    private static final Log _log = LogFactoryUtil.getLog(SocialActivityExtenderBundleActivator.class);
    private ServiceTracker<SocialConfiguration, BundleTracker<Void>> _serviceTracker;

    public void start(final BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker<SocialConfiguration, BundleTracker<Void>>(bundleContext, SocialConfiguration.class, null){

            public BundleTracker<Void> addingService(ServiceReference<SocialConfiguration> serviceReference) {
                SocialConfiguration socialConfiguration = (SocialConfiguration)bundleContext.getService(serviceReference);
                SocialActivityBundleTracker bundleTracker = new SocialActivityBundleTracker(bundleContext, 32, socialConfiguration);
                bundleTracker.open();
                return bundleTracker;
            }

            public void removedService(ServiceReference<SocialConfiguration> serviceReference, BundleTracker<Void> bundleTracker) {
                bundleTracker.close();
            }
        };
        this._serviceTracker.open();
    }

    public void stop(BundleContext context) {
        this._serviceTracker.close();
    }

    private static class SocialActivityBundleTracker
    extends BundleTracker<Void> {
        private final SocialConfiguration _socialConfiguration;

        public Void addingBundle(Bundle bundle, BundleEvent event) {
            try {
                this._readSocialActivity(bundle, "META-INF/social/liferay-social.xml");
                this._readSocialActivity(bundle, "META-INF/social/liferay-social-ext.xml");
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to read social activity for bundle " + bundle.getSymbolicName()), (Throwable)exception);
            }
            return null;
        }

        private SocialActivityBundleTracker(BundleContext context, int stateMask, SocialConfiguration socialConfiguration) {
            super(context, stateMask, null);
            this._socialConfiguration = socialConfiguration;
        }

        private void _readSocialActivity(Bundle bundle, String resourcePath) throws Exception {
            Enumeration enumeration = bundle.getResources(resourcePath);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            ArrayList<String> configs = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                configs.add(StringUtil.read((InputStream)url.openStream()));
            }
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            this._socialConfiguration.read(bundleWiring.getClassLoader(), configs.toArray(new String[0]));
        }
    }
}

