/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings.authentication.ldap.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseFormMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Dictionary;
import java.util.List;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_configuration_admin_web_portlet_InstanceSettingsPortlet", "mvc.command.name=/portal_settings/ldap"}, service={MVCActionCommand.class})
public class PortalSettingsLDAPFormMVCActionCommand
extends BaseFormMVCActionCommand {
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(themeDisplay.getCompanyId())) {
            SessionErrors.add((PortletRequest)actionRequest, PrincipalException.class);
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("CMD_UPDATE_AUTH")) {
            this.updateLDAPAuthConfigurationProvider(actionRequest, this._ldapAuthConfigurationProvider, themeDisplay.getCompanyId());
        } else if (cmd.equals("CMD_UPDATE_EXPORT")) {
            this.updateLDAPExportConfigurationProvider(actionRequest, this._ldapExportConfigurationProvider, themeDisplay.getCompanyId());
        } else if (cmd.equals("CMD_UPDATE_IMPORT")) {
            this.updateLDAPImportConfigurationProvider(actionRequest, this._ldapImportConfigurationProvider, themeDisplay.getCompanyId());
        } else if (cmd.equals("CMD_UPDATE_SERVER")) {
            this.sortLdapServerConfigurations(themeDisplay.getCompanyId(), ParamUtil.getString((PortletRequest)actionRequest, (String)"ldap--authServerPriority--"));
        }
    }

    protected void doValidateForm(ActionRequest actionRequest, ActionResponse actionResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(themeDisplay.getCompanyId());
        if (!ldapImportConfiguration.importUserPasswordAutogenerated()) {
            return;
        }
        boolean ldapExportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ldap--exportEnabled--");
        boolean ldapImportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ldap--importEnabled--");
        if (ldapExportEnabled && ldapImportEnabled) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"ldapExportAndImportOnPasswordAutogeneration");
        }
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setLDAPAuthConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration)", unbind="-")
    protected void setLDAPExportConfigurationProvider(ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider) {
        this._ldapExportConfigurationProvider = ldapExportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    protected void sortLdapServerConfigurations(long companyId, String orderedLdapServerIdsString) {
        if (Validator.isBlank((String)orderedLdapServerIdsString)) {
            return;
        }
        String[] orderedLdapServerIds = orderedLdapServerIdsString.split(",");
        List dictionaries = this._ldapServerConfigurationProvider.getConfigurationsProperties(companyId);
        for (int i = 0; i < orderedLdapServerIds.length; ++i) {
            int authServerPriority = i;
            long ldapServerId = GetterUtil.getLong((String)orderedLdapServerIds[i]);
            Stream stream = dictionaries.stream();
            stream.filter(dictionary -> GetterUtil.getLong(dictionary.get("ldapServerId")) == ldapServerId).findFirst().ifPresent(dictionary -> {
                dictionary.put("authServerPriority", authServerPriority);
                this._ldapServerConfigurationProvider.updateProperties(companyId, GetterUtil.getLong(dictionary.get("ldapServerId")), dictionary);
            });
        }
    }

    protected void updateLDAPAuthConfigurationProvider(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        this._setBooleanProperties(actionRequest, properties, "enabled", "required", "passwordPolicyEnabled");
        this._setStringProperties(actionRequest, properties, "method", "passwordEncryptionAlgorithm");
        configurationProvider.updateProperties(companyId, properties);
    }

    protected void updateLDAPExportConfigurationProvider(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        this._setBooleanProperties(actionRequest, properties, "exportEnabled", "exportGroupEnabled");
        configurationProvider.updateProperties(companyId, properties);
    }

    protected void updateLDAPImportConfigurationProvider(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        this._setBooleanProperties(actionRequest, properties, "importCreateRolePerGroup", "importEnabled", "importGroupCacheEnabled", "importOnStartup", "importUserPasswordAutogenerated", "importUserPasswordDefault", "importUserPasswordEnabled");
        this._setIntegerProperties(actionRequest, properties, "importInterval");
        this._setLongProperties(actionRequest, properties, "importLockExpirationTime");
        this._setStringProperties(actionRequest, properties, "importMethod", "importUserPasswordDefault", "importUserSyncStrategy");
        configurationProvider.updateProperties(companyId, properties);
    }

    private void _setBooleanProperties(ActionRequest actionRequest, Dictionary<String, Object> properties, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            boolean value = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
    }

    private void _setIntegerProperties(ActionRequest actionRequest, Dictionary<String, Object> properties, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            int value = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
    }

    private void _setLongProperties(ActionRequest actionRequest, Dictionary<String, Object> properties, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            long value = ParamUtil.getLong((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
    }

    private void _setStringProperties(ActionRequest actionRequest, Dictionary<String, Object> properties, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
    }
}

