/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings.authentication.ldap.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseFormMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import java.util.Dictionary;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_settings_web_portlet_PortalSettingsPortlet", "mvc.command.name=/portal_settings/ldap"}, service={MVCActionCommand.class})
public class PortalSettingsLDAPFormMVCActionCommand
extends BaseFormMVCActionCommand {
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(themeDisplay.getCompanyId())) {
            SessionErrors.add((PortletRequest)actionRequest, PrincipalException.class);
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        this.updateBooleanProperties(actionRequest, this._ldapAuthConfigurationProvider, themeDisplay.getCompanyId(), "enabled", "required", "passwordPolicyEnabled");
        this.updateStringProperties(actionRequest, this._ldapAuthConfigurationProvider, themeDisplay.getCompanyId(), "method", "passwordEncryptionAlgorithm");
        this.updateBooleanProperties(actionRequest, this._ldapExportConfigurationProvider, themeDisplay.getCompanyId(), "exportEnabled", "exportGroupEnabled");
        this.updateBooleanProperties(actionRequest, this._ldapImportConfigurationProvider, themeDisplay.getCompanyId(), "importCreateRolePerGroup", "importEnabled", "importGroupCacheEnabled", "importOnStartup", "importUserPasswordAutogenerated", "importUserPasswordDefault", "importUserPasswordEnabled");
        this.updateIntegerProperties(actionRequest, this._ldapImportConfigurationProvider, themeDisplay.getCompanyId(), "importInterval");
        this.updateLongProperties(actionRequest, this._ldapImportConfigurationProvider, themeDisplay.getCompanyId(), "importLockExpirationTime");
        this.updateStringProperties(actionRequest, this._ldapImportConfigurationProvider, themeDisplay.getCompanyId(), "importMethod", "importUserPasswordDefault", "importUserSyncStrategy");
    }

    protected void doValidateForm(ActionRequest actionRequest, ActionResponse actionResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(themeDisplay.getCompanyId());
        if (!ldapImportConfiguration.importUserPasswordAutogenerated()) {
            return;
        }
        boolean ldapExportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ldap--exportEnabled--");
        boolean ldapImportEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ldap--importEnabled--");
        if (ldapExportEnabled && ldapImportEnabled) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"ldapExportAndImportOnPasswordAutogeneration");
        }
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setLDAPAuthConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration)", unbind="-")
    protected void setLDAPExportConfigurationProvider(ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider) {
        this._ldapExportConfigurationProvider = ldapExportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    protected void updateBooleanProperties(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId, String ... propertyNames) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        for (String propertyName : propertyNames) {
            boolean value = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
        configurationProvider.updateProperties(companyId, properties);
    }

    protected void updateIntegerProperties(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId, String ... propertyNames) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        for (String propertyName : propertyNames) {
            int value = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
        configurationProvider.updateProperties(companyId, properties);
    }

    protected void updateLongProperties(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId, String ... propertyNames) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        for (String propertyName : propertyNames) {
            long value = ParamUtil.getLong((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
        configurationProvider.updateProperties(companyId, properties);
    }

    protected void updateStringProperties(ActionRequest actionRequest, ConfigurationProvider<?> configurationProvider, long companyId, String ... propertyNames) {
        Dictionary properties = configurationProvider.getConfigurationProperties(companyId);
        for (String propertyName : propertyNames) {
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("ldap--" + propertyName + "--"));
            properties.put(propertyName, value);
        }
        configurationProvider.updateProperties(companyId, properties);
    }
}

