/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings.authentication.ldap.web.internal.portlet.action;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletContextFactory;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.DuplicateLDAPServerNameException;
import com.liferay.portal.security.ldap.LDAPServerNameException;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import com.liferay.portal.security.ldap.validator.LDAPFilterException;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_portal_settings_web_portlet_PortalSettingsPortlet", "mvc.command.name=/portal_settings/edit_ldap_server"}, service={MVCActionCommand.class})
public class PortalSettingsEditLDAPServerMVCActionCommand
extends BaseMVCActionCommand {
    private static ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private CounterLocalService _counterLocalService;
    private Portal _portal;
    private Portlet _portlet;
    private PortletContext _portletContext;
    private PortletContextFactory _portletContextFactory;
    private ServletContext _servletContext;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLDAPServer(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLDAPServer(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            String mvcPath = "/com.liferay.portal.settings.web/edit_ldap_server.jsp";
            if (e instanceof DuplicateLDAPServerNameException || e instanceof LDAPFilterException || e instanceof LDAPServerNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
                httpServletRequest.setAttribute("portlet.context.override." + mvcPath, (Object)this._portletContext);
            } else if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/error.jsp";
            } else {
                throw e;
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    @Activate
    protected void activate() {
        this._portletContext = this._portletContextFactory.createUntrackedInstance(this._portlet, this._servletContext);
    }

    protected void deleteLDAPServer(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ldapServerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ldapServerId");
        _ldapServerConfigurationProvider.delete(themeDisplay.getCompanyId(), ldapServerId);
    }

    @Reference(unbind="-")
    protected void setCounterLocalService(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        _ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(target="(javax.portlet.name=com_liferay_portal_settings_web_portlet_PortalSettingsPortlet)", unbind="-")
    protected void setPortlet(Portlet portlet) {
        this._portlet = portlet;
    }

    @Reference(unbind="-")
    protected void setPortletContextFactory(PortletContextFactory portletContextFactory) {
        this._portletContextFactory = portletContextFactory;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.settings.authentication.ldap.web)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected void updateLDAPServer(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ldapServerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ldapServerId");
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"ldap--");
        this.validateLDAPServerName(ldapServerId, themeDisplay.getCompanyId(), properties);
        this.validateSearchFilters(actionRequest);
        Dictionary dictionary = null;
        if (ldapServerId <= 0L) {
            ldapServerId = this._counterLocalService.increment();
            dictionary = new HashMapDictionary();
        } else {
            dictionary = _ldapServerConfigurationProvider.getConfigurationProperties(themeDisplay.getCompanyId(), ldapServerId);
        }
        for (Map.Entry entry : properties.entrySet()) {
            dictionary.put(entry.getKey(), entry.getValue());
        }
        this._splitStringArrays(dictionary, "contactCustomMappings");
        this._splitStringArrays(dictionary, "contactMappings");
        this._splitStringArrays(dictionary, "groupDefaultObjectClasses");
        this._splitStringArrays(dictionary, "groupMappings");
        this._splitStringArrays(dictionary, "userCustomMappings");
        this._splitStringArrays(dictionary, "userDefaultObjectClasses");
        this._splitStringArrays(dictionary, "userMappings");
        _ldapServerConfigurationProvider.updateProperties(themeDisplay.getCompanyId(), ldapServerId, dictionary);
    }

    protected void validateLDAPServerName(long ldapServerId, long companyId, UnicodeProperties properties) throws Exception {
        String serverName = properties.getProperty("serverName");
        if (Validator.isNull((String)serverName)) {
            throw new LDAPServerNameException();
        }
        List ldapServerConfigurations = _ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            String existingServerName = ldapServerConfiguration.serverName();
            if (!serverName.equals(existingServerName) || ldapServerId == ldapServerConfiguration.ldapServerId()) continue;
            throw new DuplicateLDAPServerNameException();
        }
    }

    protected void validateSearchFilters(ActionRequest actionRequest) throws Exception {
        String userFilter = ParamUtil.getString((PortletRequest)actionRequest, (String)"importUserSearchFilter");
        LDAPUtil.validateFilter((String)userFilter, (String)"importUserSearchFilter");
        String groupFilter = ParamUtil.getString((PortletRequest)actionRequest, (String)"importGroupSearchFilter");
        LDAPUtil.validateFilter((String)groupFilter, (String)"importGroupSearchFilter");
    }

    private void _splitStringArrays(Dictionary<String, Object> dictionary, String property) {
        Object propertyValue = dictionary.get(property);
        if (propertyValue == null) {
            return;
        }
        if (propertyValue instanceof String) {
            String[] propertyValues = StringUtil.split((String)((String)propertyValue));
            dictionary.put(property, propertyValues);
        }
    }
}

