/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings.authentication.facebook.connect.web.internal.portlet.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.settings.portlet.action.PortalSettingsFormContributor;
import com.liferay.portal.settings.portlet.action.PortalSettingsParameterUtil;
import java.util.Optional;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PortalSettingsFormContributor.class})
public class FacebookConnectPortalSettingsFormContributor
implements PortalSettingsFormContributor {
    public Optional<String> getDeleteMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/facebook_connect_delete");
    }

    public String getParameterNamespace() {
        return "facebook_";
    }

    public Optional<String> getSaveMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/facebook_connect");
    }

    public String getSettingsId() {
        return "com.liferay.portal.security.sso.facebook.connect";
    }

    public void validateForm(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        boolean facebookEnabled = PortalSettingsParameterUtil.getBoolean((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"enabled");
        if (!facebookEnabled) {
            return;
        }
        String facebookGraphURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"graphURL");
        String facebookOauthAuthURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"oauthAuthURL");
        String facebookOauthRedirectURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"oauthRedirectURL");
        String facebookOauthTokenURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"oauthTokenURL");
        if (Validator.isNotNull((String)facebookGraphURL) && !Validator.isUrl((String)facebookGraphURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"facebookConnectGraphURLInvalid");
        }
        if (Validator.isNotNull((String)facebookOauthAuthURL) && !Validator.isUrl((String)facebookOauthAuthURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"facebookConnectOauthAuthURLInvalid");
        }
        if (Validator.isNotNull((String)facebookOauthRedirectURL) && !Validator.isUrl((String)facebookOauthRedirectURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"facebookConnectOauthRedirectURLInvalid");
        }
        if (Validator.isNotNull((String)facebookOauthTokenURL) && !Validator.isUrl((String)facebookOauthTokenURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"facebookConnectOauthTokenURLInvalid");
        }
    }
}

