/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.settings.authentication.cas.web.internal.portlet.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.settings.portlet.action.PortalSettingsFormContributor;
import com.liferay.portal.settings.portlet.action.PortalSettingsParameterUtil;
import java.util.Optional;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PortalSettingsFormContributor.class})
public class CASPortalSettingsFormContributor
implements PortalSettingsFormContributor {
    public Optional<String> getDeleteMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/cas_delete");
    }

    public String getParameterNamespace() {
        return "cas_";
    }

    public Optional<String> getSaveMVCActionCommandNameOptional() {
        return Optional.of("/portal_settings/cas");
    }

    public String getSettingsId() {
        return "com.liferay.portal.security.sso.cas";
    }

    public void validateForm(ActionRequest actionRequest, ActionResponse actionResponse) {
        boolean casEnabled = PortalSettingsParameterUtil.getBoolean((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"enabled");
        if (!casEnabled) {
            return;
        }
        String casLoginURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"loginURL");
        String casLogoutURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"logoutURL");
        String casServerName = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"serverName");
        String casServerURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"serverURL");
        String casServiceURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"serviceURL");
        String casNoSuchUserRedirectURL = PortalSettingsParameterUtil.getString((ActionRequest)actionRequest, (PortalSettingsFormContributor)this, (String)"noSuchUserRedirectURL");
        if (!Validator.isUrl((String)casLoginURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLoginURLInvalid");
        }
        if (!Validator.isUrl((String)casLogoutURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casLogoutURLInvalid");
        }
        if (Validator.isNull((String)casServerName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerNameInvalid");
        }
        if (!Validator.isUrl((String)casServerURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServerURLInvalid");
        }
        if (Validator.isNotNull((String)casServiceURL) && !Validator.isUrl((String)casServiceURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casServiceURLInvalid");
        }
        if (Validator.isNotNull((String)casNoSuchUserRedirectURL) && !Validator.isUrl((String)casNoSuchUserRedirectURL)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"casNoSuchUserURLInvalid");
        }
    }
}

