/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.jsp.compiler.internal.BundleJavaFileObject;
import com.liferay.portal.servlet.jsp.compiler.internal.JarJavaFileObject;
import com.liferay.portal.servlet.jsp.compiler.internal.JavaFileObjectResolver;
import com.liferay.portal.servlet.jsp.compiler.internal.VfsJavaFileObject;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;

public class JspJavaFileObjectResolver
implements JavaFileObjectResolver {
    private final BundleWiring _bundleWiring;
    private final Map<BundleWiring, Set<String>> _bundleWiringPackageNames;
    private final Map<String, Collection<JavaFileObject>> _javaFileObjects = new ConcurrentReferenceValueHashMap(FinalizeManager.SOFT_REFERENCE_FACTORY);
    private final BundleWiring _jspBundleWiring;
    private final Logger _logger;
    private final ServiceTracker<Map<String, List<URL>>, Map<String, List<URL>>> _serviceTracker;

    public JspJavaFileObjectResolver(BundleWiring bundleWiring, BundleWiring jspBundleWiring, Map<BundleWiring, Set<String>> bundleWiringPackageNames, Logger logger, ServiceTracker<Map<String, List<URL>>, Map<String, List<URL>>> serviceTracker) {
        this._bundleWiring = bundleWiring;
        this._jspBundleWiring = jspBundleWiring;
        this._bundleWiringPackageNames = bundleWiringPackageNames;
        this._logger = logger;
        this._serviceTracker = serviceTracker;
    }

    @Override
    public Collection<JavaFileObject> resolveClasses(boolean recurse, String packagePath) {
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();
        int options = 0;
        if (recurse) {
            options = 1;
        }
        javaFileObjects.addAll(this.toJavaFileObjects(this._jspBundleWiring.getBundle(), this._jspBundleWiring.listResources(packagePath, "*.class", options)));
        String packageName = packagePath.replace('/', '.');
        for (Map.Entry<BundleWiring, Set<String>> entry : this._bundleWiringPackageNames.entrySet()) {
            Set<String> packageNames = entry.getValue();
            if (!packageNames.contains(packageName)) continue;
            javaFileObjects.addAll(this.doResolveClasses(entry.getKey(), packagePath, options));
        }
        if (javaFileObjects.isEmpty()) {
            return this.toJavaFileObjects(this._bundleWiring.getBundle(), this._bundleWiring.listResources(packagePath, "*.class", options));
        }
        return javaFileObjects;
    }

    protected Collection<JavaFileObject> doResolveClasses(BundleWiring bundleWiring, String path, int options) {
        Bundle bundle = bundleWiring.getBundle();
        if (bundle.getBundleId() == 0L) {
            return this.handleSystemBundle(bundleWiring, path);
        }
        return this.toJavaFileObjects(bundle, bundleWiring.listResources(path, "*.class", options));
    }

    protected String getClassName(String classResourceName) {
        classResourceName = classResourceName.substring(0, classResourceName.length() - 6);
        return classResourceName.replace('/', '.');
    }

    protected File getFile(URL url) throws IOException {
        int index;
        URLConnection urlConnection = url.openConnection();
        String fileName = url.getFile();
        if (urlConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
            URL jarFileURL = jarURLConnection.getJarFileURL();
            fileName = jarFileURL.getFile();
        } else if (Validator.equals((Object)url.getProtocol(), (Object)"vfs")) {
            fileName = url.getFile();
            int index2 = fileName.indexOf(".jar");
            if (index2 > 0) {
                fileName = fileName.substring(0, index2 + 4);
            }
        } else if (Validator.equals((Object)url.getProtocol(), (Object)"wsjar")) {
            String protocol;
            fileName = url.getFile();
            int index3 = fileName.indexOf(protocol = "file:/");
            if (index3 > -1) {
                fileName = fileName.substring(protocol.length());
            }
            if ((index3 = fileName.indexOf(33)) > -1) {
                fileName = fileName.substring(0, index3);
            }
        } else if (Validator.equals((Object)url.getProtocol(), (Object)"zip") && (index = (fileName = url.getFile()).indexOf(33)) > 0) {
            fileName = fileName.substring(0, index);
        }
        return new File(URLCodec.decodeURL((String)fileName, (String)"UTF-8"));
    }

    protected JavaFileObject getJavaFileObject(URL resourceURL, String resourceName) {
        String protocol = resourceURL.getProtocol();
        String className = this.getClassName(resourceName);
        if (protocol.equals("bundle") || protocol.equals("bundleresource")) {
            return new BundleJavaFileObject(className, resourceURL);
        }
        if (protocol.equals("jar")) {
            try {
                return new JarJavaFileObject(className, this.getFile(resourceURL), resourceName);
            }
            catch (IOException ioe) {
                this._logger.log(1, ioe.getMessage(), ioe);
            }
        } else if (protocol.equals("vfs")) {
            try {
                return new VfsJavaFileObject(className, resourceURL, resourceName);
            }
            catch (MalformedURLException murie) {
                this._logger.log(1, murie.getMessage(), murie);
            }
        }
        return null;
    }

    protected Collection<JavaFileObject> handleSystemBundle(BundleWiring bundleWiring, String path) {
        Collection<JavaFileObject> javaFileObjects = this._javaFileObjects.get(path);
        if (javaFileObjects != null) {
            return javaFileObjects;
        }
        ArrayList<URL> urls = null;
        Map extraPackageMap = (Map)this._serviceTracker.getService();
        if (extraPackageMap != null) {
            urls = (List)extraPackageMap.get(path.replace('/', '.'));
        }
        if (urls == null || urls.isEmpty()) {
            ClassLoader classLoader = bundleWiring.getClassLoader();
            try {
                Enumeration<URL> enumeration = classLoader.getResources(path);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    urls = Collections.list(enumeration);
                }
            }
            catch (IOException ioe) {
                this._logger.log(1, ioe.getMessage(), ioe);
            }
        }
        if (urls == null || urls.isEmpty()) {
            this._javaFileObjects.put(path, Collections.emptyList());
            return Collections.emptyList();
        }
        for (URL url : urls) {
            try {
                File file = this.getFile(url);
                FileSystem fileSystem = FileSystems.newFileSystem(file.toPath(), null);
                Throwable throwable = null;
                try {
                    FileSystemProvider fileSystemProvider = fileSystem.provider();
                    DirectoryStream<Path> directoryStream = fileSystemProvider.newDirectoryStream(fileSystem.getPath(path, new String[0]), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entryPath) {
                            String entryPathString = entryPath.toString();
                            return entryPathString.endsWith(".class");
                        }
                    });
                    Throwable throwable2 = null;
                    try {
                        for (Path entryPath : directoryStream) {
                            if (javaFileObjects == null) {
                                javaFileObjects = new ArrayList<JavaFileObject>();
                            }
                            String entryPathString = entryPath.toString();
                            entryPathString = entryPathString.substring(1);
                            javaFileObjects.add(new JarJavaFileObject(this.getClassName(entryPathString), file, entryPathString));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (directoryStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        directoryStream.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileSystem == null) continue;
                    if (throwable != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fileSystem.close();
                }
            }
            catch (IOException ioe) {
                this._logger.log(1, ioe.getMessage(), ioe);
            }
        }
        if (javaFileObjects == null) {
            javaFileObjects = Collections.emptyList();
        }
        this._javaFileObjects.put(path, javaFileObjects);
        return javaFileObjects;
    }

    protected boolean isExportsPackage(BundleWiring bundleWiring, String packageName) {
        List bundleCapabilities = bundleWiring.getCapabilities("osgi.wiring.package");
        for (BundleCapability bundleCapability : bundleCapabilities) {
            Map attributes = bundleCapability.getAttributes();
            if (!packageName.equals(attributes.get("osgi.wiring.package"))) continue;
            return true;
        }
        return false;
    }

    protected Collection<JavaFileObject> toJavaFileObjects(Bundle bundle, Collection<String> resources) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>(resources.size());
        for (String resource : resources) {
            JavaFileObject javaFileObject = this.getJavaFileObject(bundle.getResource(resource), resource);
            if (javaFileObject == null) continue;
            javaFileObjects.add(javaFileObject);
        }
        return javaFileObjects;
    }
}

