/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.jsp.compiler.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.servlet.jsp.compiler.internal.BundleJavaFileManager;
import com.liferay.portal.servlet.jsp.compiler.internal.JavaFileObjectResolver;
import com.liferay.portal.servlet.jsp.compiler.internal.JspBundleClassloader;
import com.liferay.portal.servlet.jsp.compiler.internal.JspJavaFileObjectResolver;
import com.liferay.portal.servlet.jsp.compiler.internal.StringJavaFileObject;
import com.liferay.portal.servlet.jsp.compiler.internal.TldURIUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.felix.utils.log.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Jsr199JavaCompiler;
import org.apache.jasper.compiler.Node;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;

public class JspCompiler
extends Jsr199JavaCompiler {
    private static final String[] _JSP_COMPILER_DEPENDENCIES = new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.util.PortalImpl", "javax.portlet.PortletException", "javax.servlet.ServletException"};
    private static final Map<BundleWiring, Set<String>> _bundleWiringPackageNamesCache = new ConcurrentReferenceKeyHashMap((Map)new ConcurrentReferenceValueHashMap(FinalizeManager.SOFT_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final BundleWiring _jspBundleWiring;
    private static final Map<BundleWiring, Set<String>> _jspBundleWiringPackageNames;
    private static final ServiceTracker<Map<String, List<URL>>, Map<String, List<URL>>> _serviceTracker;
    private static final Set<String> _systemPackageNames;
    private Bundle[] _allParticipatingBundles;
    private final Map<BundleWiring, Set<String>> _bundleWiringPackageNames = new HashMap<BundleWiring, Set<String>>(_jspBundleWiringPackageNames);
    private ClassLoader _classLoader;
    private final List<File> _classPath = new ArrayList<File>();
    private JavaFileObjectResolver _javaFileObjectResolver;
    private Logger _logger;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JavacErrorDetail[] compile(String className, Node.Nodes pageNodes) throws JasperException {
        this.classFiles = new ArrayList();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            this.errDispatcher.jspError("jsp.error.nojdk");
            throw new JasperException("Unable to find Java compiler");
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, null, null);
        try {
            standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, this.cpath);
        }
        catch (IOException ioe) {
            throw new JasperException(ioe);
        }
        try (JavaFileManager javaFileManager = this.getJavaFileManager(standardJavaFileManager);){
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, javaFileManager, diagnosticCollector, this.options, null, Arrays.asList(new StringJavaFileObject(className.substring(className.lastIndexOf(46) + 1), this.charArrayWriter.toString())));
            if (compilationTask.call().booleanValue()) {
                Iterator i$ = this.classFiles.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        i$ = null;
                        return i$;
                    }
                    Jsr199JavaCompiler.BytecodeFile bytecodeFile = (Jsr199JavaCompiler.BytecodeFile)i$.next();
                    this.rtctxt.setBytecode(bytecodeFile.getClassName(), bytecodeFile.getBytecode());
                }
            }
        }
        catch (IOException ioe) {
            throw new JasperException(ioe);
        }
        List diagnostics = diagnosticCollector.getDiagnostics();
        JavacErrorDetail[] javacErrorDetails = new JavacErrorDetail[diagnostics.size()];
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            javacErrorDetails[i] = ErrorDispatcher.createJavacError(this.javaFileName, pageNodes, new StringBuilder(diagnostic.getMessage(null)), (int)diagnostic.getLineNumber());
            ++i;
        }
        return javacErrorDetails;
    }

    @Override
    public void init(JspCompilationContext jspCompilationContext, ErrorDispatcher errorDispatcher, boolean suppressLogging) {
        Bundle jspBundle = _jspBundleWiring.getBundle();
        this._logger = new Logger(jspBundle.getBundleContext());
        ServletContext servletContext = jspCompilationContext.getServletContext();
        ClassLoader classLoader = servletContext.getClassLoader();
        if (!(classLoader instanceof JspBundleClassloader)) {
            throw new IllegalStateException("Class loader is not an instance of JspBundleClassloader");
        }
        JspBundleClassloader jspBundleClassloader = (JspBundleClassloader)classLoader;
        this._allParticipatingBundles = jspBundleClassloader.getBundles();
        Bundle bundle = this._allParticipatingBundles[0];
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        this._classLoader = bundleWiring.getClassLoader();
        for (BundleWire bundleWire : bundleWiring.getRequiredWires(null)) {
            BundleWiring providedBundleWiring = bundleWire.getProviderWiring();
            this._bundleWiringPackageNames.put(providedBundleWiring, JspCompiler._collectPackageNames(providedBundleWiring));
        }
        if (this.options.contains("-verbose")) {
            StringBundler sb = new StringBundler(this._bundleWiringPackageNames.size() * 4 + 6);
            sb.append("JSP compiler for bundle ");
            sb.append(bundle.getSymbolicName());
            sb.append("-");
            sb.append((Object)bundle.getVersion());
            sb.append(" has dependent bundle wirings: ");
            for (BundleWiring curBundleWiring : this._bundleWiringPackageNames.keySet()) {
                Bundle currentBundle = curBundleWiring.getBundle();
                sb.append(currentBundle.getSymbolicName());
                sb.append("-");
                sb.append((Object)currentBundle.getVersion());
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            this._logger.log(3, sb.toString());
        }
        this._javaFileObjectResolver = new JspJavaFileObjectResolver(bundleWiring, _jspBundleWiring, this._bundleWiringPackageNames, this._logger, _serviceTracker);
        jspCompilationContext.setClassLoader(jspBundleClassloader);
        this.initClassPath(servletContext);
        this.initTLDMappings(servletContext, jspCompilationContext.getTagFileJarUrls());
        super.init(jspCompilationContext, errorDispatcher, suppressLogging);
    }

    protected void addDependenciesToClassPath() {
        ClassLoader frameworkClassLoader = Bundle.class.getClassLoader();
        for (String className : _JSP_COMPILER_DEPENDENCIES) {
            try {
                Class<?> clazz = Class.forName(className, true, frameworkClassLoader);
                this.addDependencyToClassPath(clazz);
            }
            catch (ClassNotFoundException e) {
                this._logger.log(1, "Unable to add depedency " + className + " to the classpath");
            }
        }
    }

    protected void addDependencyToClassPath(Class<?> clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain == null) {
            return;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        try {
            File file = new File(this.toURI(url));
            if (file.exists() && file.canRead()) {
                this._classPath.remove(file);
                this._classPath.add(0, file);
            }
        }
        catch (Exception e) {
            this._logger.log(1, e.getMessage(), e);
        }
    }

    protected void collectTLDMappings(Map<String, String[]> tldMappings, Map<String, URL> tagFileJarUrls, Bundle bundle) throws IOException {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ArrayList resourcePaths = new ArrayList(bundleWiring.listResources("/META-INF/", "*.tld", 1));
        resourcePaths.addAll(bundleWiring.listResources("/WEB-INF/", "*.tld", 1));
        for (String resourcePath : resourcePaths) {
            URL url = bundle.getResource(resourcePath);
            String uri = TldURIUtil.getTldURI(url);
            if (uri == null) continue;
            String absoluteResourcePath = "/".concat(resourcePath);
            tldMappings.put(uri, new String[]{absoluteResourcePath, null});
            String urlString = url.toExternalForm();
            tagFileJarUrls.put(absoluteResourcePath, new URL(urlString.substring(0, urlString.length() - resourcePath.length())));
        }
    }

    @Override
    protected JavaFileManager getJavaFileManager(JavaFileManager javaFileManager) {
        if (javaFileManager instanceof StandardJavaFileManager) {
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)javaFileManager;
            try {
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, this._classPath);
            }
            catch (IOException ioe) {
                this._logger.log(1, ioe.getMessage(), ioe);
            }
            javaFileManager = new BundleJavaFileManager(this._classLoader, _systemPackageNames, standardJavaFileManager, this._logger, this.options.contains("-verbose"), this._javaFileObjectResolver);
        }
        return super.getJavaFileManager(javaFileManager);
    }

    protected void initClassPath(ServletContext servletContext) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    JspCompiler.this.addDependenciesToClassPath();
                    return null;
                }
            });
        } else {
            this.addDependenciesToClassPath();
        }
    }

    protected void initTLDMappings(ServletContext servletContext, Map<String, URL> tagFileJarUrls) {
        HashMap<String, String[]> tldMappings = (HashMap<String, String[]>)servletContext.getAttribute("com.sun.jsp.tldUriToLocationMap");
        if (tldMappings != null) {
            return;
        }
        tldMappings = new HashMap<String, String[]>();
        try {
            for (Bundle bundle : this._allParticipatingBundles) {
                this.collectTLDMappings(tldMappings, tagFileJarUrls, bundle);
            }
        }
        catch (Exception e) {
            this._logger.log(1, e.getMessage(), e);
        }
        Map map = (Map)servletContext.getAttribute("jsp.taglib.mappings");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                tldMappings.put((String)entry.getKey(), new String[]{(String)entry.getValue(), null});
            }
        }
        servletContext.setAttribute("com.sun.jsp.tldUriToLocationMap", tldMappings);
    }

    protected URI toURI(URL url) throws MalformedURLException, URISyntaxException {
        String file;
        String protocol = url.getProtocol();
        if (protocol.equals("reference")) {
            file = url.getFile();
            url = new URL(file);
            protocol = url.getProtocol();
        }
        if (protocol.equals("file")) {
            return url.toURI();
        }
        if (protocol.equals("jar")) {
            file = url.getFile();
            int pos = file.indexOf("!/");
            if (pos != -1) {
                file = file.substring(0, pos);
            }
            return new URI(file);
        }
        throw new URISyntaxException(url.toString(), "Unknown protocol " + protocol);
    }

    private static Set<String> _collectPackageNames(BundleWiring bundleWiring) {
        Set<String> packageNames = _bundleWiringPackageNamesCache.get(bundleWiring);
        if (packageNames != null) {
            return packageNames;
        }
        packageNames = new HashSet<String>();
        for (BundleCapability bundleCapability : bundleWiring.getCapabilities("osgi.wiring.package")) {
            Map attributes = bundleCapability.getAttributes();
            Object packageName = attributes.get("osgi.wiring.package");
            if (packageName == null) continue;
            packageNames.add((String)packageName);
        }
        _bundleWiringPackageNamesCache.put(bundleWiring, packageNames);
        return packageNames;
    }

    static {
        _jspBundleWiringPackageNames = new HashMap<BundleWiring, Set<String>>();
        Bundle jspBundle = FrameworkUtil.getBundle(JspCompiler.class);
        _jspBundleWiring = (BundleWiring)jspBundle.adapt(BundleWiring.class);
        Set<String> systemPackageNames = null;
        for (BundleWire bundleWire : _jspBundleWiring.getRequiredWires(null)) {
            BundleWiring providedBundleWiring = bundleWire.getProviderWiring();
            Set<String> packageNames = JspCompiler._collectPackageNames(providedBundleWiring);
            Bundle bundle = providedBundleWiring.getBundle();
            if (bundle.getBundleId() == 0L) {
                systemPackageNames = packageNames;
            }
            _jspBundleWiringPackageNames.put(providedBundleWiring, packageNames);
        }
        BundleContext bundleContext = jspBundle.getBundleContext();
        if (systemPackageNames == null) {
            Bundle systemBundle = bundleContext.getBundle(0L);
            if (systemBundle == null) {
                throw new ExceptionInInitializerError("Unable to access to system bundle");
            }
            systemPackageNames = JspCompiler._collectPackageNames((BundleWiring)systemBundle.adapt(BundleWiring.class));
        }
        _systemPackageNames = systemPackageNames;
        try {
            _serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)("(&(jsp.compiler.resource.map=*)(objectClass=" + Map.class.getName() + "))"));
        }
        catch (InvalidSyntaxException ise) {
            throw new ExceptionInInitializerError(ise);
        }
    }
}

