/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.wedeploy.auth.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthApp;
import com.liferay.portal.security.wedeploy.auth.model.WeDeployAuthToken;
import com.liferay.portal.security.wedeploy.auth.service.WeDeployAuthTokenLocalService;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_portal_security_wedeploy_auth_web_internal_portlet_WeDeployAuthPortlet", "mvc.command.name=/wedeploy_auth/authorize_user"}, service={MVCActionCommand.class})
public class WeDeployAuthorizeUserMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(WeDeployAuthorizeUserMVCActionCommand.class);
    @Reference
    private Http _http;
    @Reference
    private WeDeployAuthTokenLocalService _weDeployAuthTokenLocalService;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirectURI = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirectURI");
        try {
            if (cmd.equals("allow")) {
                redirectURI = this._http.addParameter(redirectURI, "code", this.getWeDeployAuthToken(actionRequest, themeDisplay));
            } else if (cmd.equals("deny")) {
                JSONObject jsonObject = JSONUtil.put((String)"error", (Object)"access_denied");
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            JSONObject jsonObject = JSONUtil.put((String)"error_message", (Object)LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-error-occurred-while-processing-the-requested-resource"));
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        this.sendRedirect(actionRequest, actionResponse, redirectURI);
    }

    protected String getWeDeployAuthToken(ActionRequest actionRequest, ThemeDisplay themeDisplay) throws PortalException {
        String redirectURI = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirectURI");
        String clientId = ParamUtil.getString((PortletRequest)actionRequest, (String)"clientId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WeDeployAuthApp.class.getName(), (PortletRequest)actionRequest);
        WeDeployAuthToken weDeployAuthRequestToken = this._weDeployAuthTokenLocalService.addAuthorizationWeDeployAuthToken(themeDisplay.getUserId(), redirectURI, clientId, serviceContext);
        return weDeployAuthRequestToken.getToken();
    }
}

