/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.security.sso.token.constants.LegacyTokenPropsKeys;
import com.liferay.portal.verify.BaseCompanySettingsVerifyProcess;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Dictionary;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.portal.security.sso.token.siteminder"}, service={VerifyProcess.class})
public class SiteMinderCompanySettingsVerifyProcess
extends BaseCompanySettingsVerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(SiteMinderCompanySettingsVerifyProcess.class);
    private CompanyLocalService _companyLocalService;
    private PrefsProps _prefsProps;
    private SettingsFactory _settingsFactory;

    protected CompanyLocalService getCompanyLocalService() {
        return this._companyLocalService;
    }

    protected Set<String> getLegacyPropertyKeys() {
        return SetUtil.fromArray((Object[])LegacyTokenPropsKeys.SITEMINDER_KEYS);
    }

    protected Dictionary<String, String> getPropertyValues(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        boolean siteMinderEnabled = this._prefsProps.getBoolean(companyId, "siteminder.auth.enabled");
        if (!siteMinderEnabled) {
            return dictionary;
        }
        dictionary.put("enabled", this._prefsProps.getString(companyId, "siteminder.auth.enabled", "false"));
        dictionary.put("importFromLDAP", this._prefsProps.getString(companyId, "siteminder.import.from.ldap", "false"));
        dictionary.put("userTokenName", this._prefsProps.getString(companyId, "siteminder.user.header", "SM_USER"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding SiteMinder token configuration for company " + companyId + " with properties: " + dictionary));
        }
        return dictionary;
    }

    protected SettingsFactory getSettingsFactory() {
        return this._settingsFactory;
    }

    protected String getSettingsId() {
        return "com.liferay.portal.security.sso.token";
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setPrefsProps(PrefsProps prefsProps) {
        this._prefsProps = prefsProps;
    }

    @Reference(unbind="-")
    protected void setSettingsFactory(SettingsFactory settingsFactory) {
        this._settingsFactory = settingsFactory;
    }
}

