/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.token.configuration.TokenConfiguration;
import com.liferay.portal.security.sso.token.events.LogoutProcessor;
import com.liferay.portal.security.sso.token.events.LogoutProcessorType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.security.sso.token.configuration.TokenConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"key=logout.events.post"}, service={LifecycleAction.class})
public class TokenLogoutAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(TokenLogoutAction.class);
    private ConfigurationProvider _configurationProvider;
    private final Map<LogoutProcessorType, LogoutProcessor> _logoutProcessors = new ConcurrentHashMap<LogoutProcessorType, LogoutProcessor>();

    public void run(HttpServletRequest request, HttpServletResponse response) {
        try {
            LogoutProcessor redirectLogoutProcessor;
            String logoutRedirectURL;
            LogoutProcessor cookieLogoutProcessor;
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            TokenConfiguration tokenCompanyServiceSettings = (TokenConfiguration)this._configurationProvider.getConfiguration(TokenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.token"));
            if (!tokenCompanyServiceSettings.enabled()) {
                return;
            }
            Object[] authenticationCookies = tokenCompanyServiceSettings.authenticationCookies();
            if (ArrayUtil.isNotEmpty((Object[])authenticationCookies) && (cookieLogoutProcessor = this._logoutProcessors.get((Object)LogoutProcessorType.COOKIE)) != null) {
                cookieLogoutProcessor.logout(request, response, (String[])authenticationCookies);
            }
            if (Validator.isNotNull((String)(logoutRedirectURL = tokenCompanyServiceSettings.logoutRedirectURL())) && (redirectLogoutProcessor = this._logoutProcessors.get((Object)LogoutProcessorType.REDIRECT)) != null) {
                redirectLogoutProcessor.logout(request, response, logoutRedirectURL);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLogoutProcessor(LogoutProcessor logoutProcessor) {
        this._logoutProcessors.put(logoutProcessor.getLogoutProcessorType(), logoutProcessor);
    }

    protected void unsetLogoutProcessor(LogoutProcessor logoutProcessor) {
        this._logoutProcessors.remove((Object)logoutProcessor.getLogoutProcessorType());
    }
}

