/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.events;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.token.events.LogoutProcessor;
import com.liferay.portal.security.sso.token.events.LogoutProcessorType;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={LogoutProcessor.class})
public class RedirectLogoutProcessor
implements LogoutProcessor {
    @Override
    public LogoutProcessorType getLogoutProcessorType() {
        return LogoutProcessorType.REDIRECT;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response, String ... parameters) throws IOException {
        if (ArrayUtil.isEmpty((Object[])parameters)) {
            return;
        }
        String redirectURL = parameters[1];
        String pathInfo = request.getPathInfo();
        if (pathInfo.contains("/portal/logout")) {
            HttpSession session = request.getSession();
            session.invalidate();
            if (Validator.isNotNull((String)redirectURL)) {
                response.sendRedirect(redirectURL);
            }
        }
    }
}

