/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.token.internal.auto.login;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.portal.security.sso.token.configuration.TokenConfiguration;
import com.liferay.portal.security.sso.token.security.auth.TokenLocation;
import com.liferay.portal.security.sso.token.security.auth.TokenRetriever;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.security.sso.token.configuration.TokenConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={AutoLogin.class})
public class TokenAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(TokenAutoLogin.class);
    private ConfigurationProvider _configurationProvider;
    private final Map<TokenLocation, TokenRetriever> _tokenRetrievers = new ConcurrentHashMap<TokenLocation, TokenRetriever>();
    private UserImporter _userImporter;
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        TokenConfiguration tokenCompanyServiceSettings = (TokenConfiguration)this._configurationProvider.getConfiguration(TokenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.token"));
        if (!tokenCompanyServiceSettings.enabled()) {
            return null;
        }
        String userTokenName = tokenCompanyServiceSettings.userTokenName();
        TokenLocation tokenLocation = tokenCompanyServiceSettings.tokenLocation();
        TokenRetriever tokenRetriever = this._tokenRetrievers.get((Object)tokenLocation);
        if (tokenRetriever == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No token retriever found for " + (Object)((Object)tokenLocation)));
            }
            return null;
        }
        String login = tokenRetriever.getLoginToken(request, userTokenName);
        if (Validator.isNull((String)login)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No login found for " + (Object)((Object)tokenLocation)));
            }
            return null;
        }
        User user = this.getUser(companyId, login, tokenCompanyServiceSettings);
        this.addRedirect(request);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    protected User getUser(long companyId, String login, TokenConfiguration tokenCompanyServiceSettings) throws PortalException {
        String authType;
        User user;
        block14: {
            user = null;
            authType = PrefsPropsUtil.getString((long)companyId, (String)"company.security.auth.type", (String)PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            if (tokenCompanyServiceSettings.importFromLDAP()) {
                try {
                    if (authType.equals("screenName")) {
                        user = this._userImporter.importUser(companyId, "", login);
                    } else if (authType.equals("emailAddress")) {
                        user = this._userImporter.importUser(companyId, login, "");
                    } else if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler();
                        sb.append("The property \"");
                        sb.append("company.security.auth.type");
                        sb.append("\" must be set to either \"");
                        sb.append("emailAddress");
                        sb.append("\" or \"");
                        sb.append("screenName");
                        sb.append("\"");
                        _log.warn((Object)sb.toString());
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block14;
                    _log.warn((Object)"Unable to import from LDAP", (Throwable)e);
                }
            }
        }
        if (user != null) {
            return user;
        }
        if (authType.equals("screenName")) {
            user = this._userLocalService.getUserByScreenName(companyId, login);
        } else if (authType.equals("emailAddress")) {
            user = this._userLocalService.getUserByEmailAddress(companyId, login);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)"Incompatible setting for: company.security.auth.type. Please configure to either: emailAddress or screenName");
        }
        return user;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setTokenRetriever(TokenRetriever tokenRetriever) {
        this._tokenRetrievers.put(tokenRetriever.getTokenLocation(), tokenRetriever);
    }

    @Reference(unbind="-")
    protected void setUserImporter(UserImporter userImporter) {
        this._userImporter = userImporter;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void unsetTokenRetriever(TokenRetriever tokenRetriever) {
        this._tokenRetrievers.remove((Object)tokenRetriever.getTokenLocation());
    }
}

