/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.opensso.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.security.sso.SSO;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.sso.opensso.configuration.OpenSSOConfiguration"}, immediate=true, service={SSO.class})
public class SSOImpl
implements SSO {
    private volatile OpenSSOConfiguration _openSSOConfiguration;

    public String getSessionExpirationRedirectUrl(long companyId) {
        if (this.isSessionRedirectOnExpire(companyId)) {
            return PrefsPropsUtil.getString((long)companyId, (String)"open.sso.logout.url", (String)this._openSSOConfiguration.logoutURL());
        }
        return null;
    }

    public String getSignInURL(long companyId, String defaultSigninURL) {
        if (!this.isOpenSSOEnabled(companyId)) {
            return null;
        }
        if (Validator.isNotNull((String)this._openSSOConfiguration.loginURL())) {
            defaultSigninURL = this._openSSOConfiguration.loginURL();
        }
        return PrefsPropsUtil.getString((long)companyId, (String)"open.sso.login.url", (String)defaultSigninURL);
    }

    public boolean isLoginRedirectRequired(long companyId) {
        return this.isOpenSSOEnabled(companyId);
    }

    public boolean isRedirectRequired(long companyId) {
        return false;
    }

    public boolean isSessionRedirectOnExpire(long companyId) {
        if (this.isOpenSSOEnabled(companyId)) {
            return this._openSSOConfiguration.logoutOnSessionExpiration();
        }
        return false;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._openSSOConfiguration = (OpenSSOConfiguration)ConfigurableUtil.createConfigurable(OpenSSOConfiguration.class, properties);
    }

    protected boolean isOpenSSOEnabled(long companyId) {
        return PrefsPropsUtil.getBoolean((long)companyId, (String)"open.sso.auth.enabled", (boolean)this._openSSOConfiguration.enabled());
    }
}

