/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.OpenIdProvider;
import com.liferay.portal.security.sso.openid.OpenIdProviderRegistry;
import com.liferay.portal.security.sso.openid.OpenIdServiceException;
import com.liferay.portal.security.sso.openid.OpenIdServiceHandler;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={OpenIdServiceHandler.class})
public class OpenIdServiceHandlerImpl
implements OpenIdServiceHandler {
    private static final String _OPEN_ID_AX_ATTR_EMAIL = "email";
    private static final String _OPEN_ID_AX_ATTR_FIRST_NAME = "firstname";
    private static final String _OPEN_ID_AX_ATTR_FULL_NAME = "fullname";
    private static final String _OPEN_ID_AX_ATTR_LAST_NAME = "lastname";
    private static final String _OPEN_ID_SREG_ATTR_EMAIL = "email";
    private static final String _OPEN_ID_SREG_ATTR_FULLNAME = "fullname";
    private static final Log _log = LogFactoryUtil.getLog(OpenIdServiceHandlerImpl.class);
    private ConsumerManager _consumerManager;
    private OpenIdProviderRegistry _openIdProviderRegistry;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    @Override
    public String readResponse(ThemeDisplay themeDisplay, ActionRequest actionRequest) throws PortalException {
        String password1;
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        request = this._portal.getOriginalServletRequest(request);
        String receivingURL = ParamUtil.getString((HttpServletRequest)request, (String)"openid.return_to");
        ParameterList parameterList = new ParameterList(request.getParameterMap());
        HttpSession session = request.getSession();
        DiscoveryInformation discoveryInformation = (DiscoveryInformation)session.getAttribute("openid-disco");
        if (discoveryInformation == null) {
            return null;
        }
        AuthSuccess authSuccess = null;
        String firstName = null;
        String lastName = null;
        String emailAddress = null;
        try {
            MessageExtension messageExtension;
            VerificationResult verificationResult = this._consumerManager.verify(receivingURL, parameterList, discoveryInformation);
            Identifier identifier = verificationResult.getVerifiedId();
            if (identifier == null) {
                return null;
            }
            authSuccess = (AuthSuccess)verificationResult.getAuthResponse();
            firstName = null;
            lastName = null;
            emailAddress = null;
            if (authSuccess.hasExtension("http://openid.net/sreg/1.0") && (messageExtension = authSuccess.getExtension("http://openid.net/sreg/1.0")) instanceof SRegResponse) {
                SRegResponse sregResp = (SRegResponse)messageExtension;
                String fullName = GetterUtil.getString((String)sregResp.getAttributeValue("fullname"));
                String[] names = this.splitFullName(fullName);
                if (names != null) {
                    firstName = names[0];
                    lastName = names[1];
                }
                emailAddress = sregResp.getAttributeValue("email");
            }
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0") && (messageExtension = authSuccess.getExtension("http://openid.net/srv/ax/1.0")) instanceof FetchResponse) {
                String[] openIdAXTypes;
                FetchResponse fetchResponse = (FetchResponse)messageExtension;
                OpenIdProvider openIdProvider = this._openIdProviderRegistry.getOpenIdProvider(discoveryInformation.getOPEndpoint());
                for (String openIdAXType : openIdAXTypes = openIdProvider.getAxSchema()) {
                    if (openIdAXType.equals("email")) {
                        if (!Validator.isNull((String)emailAddress)) continue;
                        emailAddress = this.getFirstValue(fetchResponse.getAttributeValues("email"));
                        continue;
                    }
                    if (openIdAXType.equals(_OPEN_ID_AX_ATTR_FIRST_NAME)) {
                        if (!Validator.isNull((String)firstName)) continue;
                        firstName = this.getFirstValue(fetchResponse.getAttributeValues(_OPEN_ID_AX_ATTR_FIRST_NAME));
                        continue;
                    }
                    if (openIdAXType.equals("fullname")) {
                        String fullName = fetchResponse.getAttributeValue("fullname");
                        String[] names = this.splitFullName(fullName);
                        if (names == null) continue;
                        if (Validator.isNull((String)firstName)) {
                            firstName = names[0];
                        }
                        if (!Validator.isNull((String)lastName)) continue;
                        lastName = names[1];
                        continue;
                    }
                    if (!openIdAXType.equals(_OPEN_ID_AX_ATTR_LAST_NAME) || !Validator.isNull((String)lastName)) continue;
                    lastName = this.getFirstValue(fetchResponse.getAttributeValues(_OPEN_ID_AX_ATTR_LAST_NAME));
                }
            }
        }
        catch (AssociationException ae) {
            throw new OpenIdServiceException.AssociationException(ae.getMessage(), ae);
        }
        catch (DiscoveryException de) {
            throw new OpenIdServiceException.DiscoveryException(de.getMessage(), de);
        }
        catch (MessageException me) {
            throw new OpenIdServiceException.MessageException(me.getMessage(), me);
        }
        String openId = this.normalize(authSuccess.getIdentity());
        User user = this._userLocalService.fetchUserByOpenId(themeDisplay.getCompanyId(), openId);
        if (user != null) {
            session.setAttribute("OPEN_ID_LOGIN", (Object)user.getUserId());
            return null;
        }
        try {
            if (Validator.isNull(firstName) || Validator.isNull(lastName) || Validator.isNull((String)emailAddress)) {
                SessionMessages.add((HttpServletRequest)request, (String)"openIdUserInformationMissing");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The OpenID provider did not send the required attributes to create an account");
                }
                String createAccountURL = this._portal.getCreateAccountURL(request, themeDisplay);
                String portletId = HttpUtil.getParameter((String)createAccountURL, (String)"p_p_id", (boolean)false);
                String portletNamespace = this._portal.getPortletNamespace(portletId);
                createAccountURL = HttpUtil.setParameter((String)createAccountURL, (String)(portletNamespace + "openId"), (String)openId);
                session.setAttribute("OPEN_ID_LOGIN_PENDING", (Object)Boolean.TRUE);
                return createAccountURL;
            }
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        long creatorUserId = 0L;
        long companyId = themeDisplay.getCompanyId();
        boolean autoPassword = false;
        String password2 = password1 = PwdGenerator.getPassword();
        boolean autoScreenName = true;
        String screenName = "";
        long facebookId = 0L;
        Locale locale = themeDisplay.getLocale();
        String middleName = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        user = this._userLocalService.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        session.setAttribute("OPEN_ID_LOGIN", (Object)user.getUserId());
        return null;
    }

    @Override
    public void sendRequest(ThemeDisplay themeDisplay, ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        request = this._portal.getOriginalServletRequest(request);
        HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        HttpSession session = request.getSession();
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", "/login/openid");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("mvcRenderCommandName", "/login/openid");
        portletURL.setParameter("cmd", "read");
        try {
            List discoveryInformationList = this._consumerManager.discover(openId);
            DiscoveryInformation discoveryInformation = this._consumerManager.associate(discoveryInformationList);
            session.setAttribute("openid-disco", (Object)discoveryInformation);
            AuthRequest authRequest = this._consumerManager.authenticate(discoveryInformation, portletURL.toString(), themeDisplay.getPortalURL());
            if (this._userLocalService.fetchUserByOpenId(themeDisplay.getCompanyId(), openId) != null) {
                response.sendRedirect(authRequest.getDestinationUrl(true));
                return;
            }
            String screenName = this.getScreenName(openId);
            User user = this._userLocalService.fetchUserByScreenName(themeDisplay.getCompanyId(), screenName);
            if (user != null) {
                this._userLocalService.updateOpenId(user.getUserId(), openId);
                response.sendRedirect(authRequest.getDestinationUrl(true));
                return;
            }
            FetchRequest fetchRequest = FetchRequest.createFetchRequest();
            OpenIdProvider openIdProvider = this._openIdProviderRegistry.getOpenIdProvider(discoveryInformation.getOPEndpoint());
            Map<String, String> openIdAXTypes = openIdProvider.getAxTypes();
            for (Map.Entry<String, String> entry : openIdAXTypes.entrySet()) {
                fetchRequest.addAttribute(entry.getKey(), entry.getValue(), true);
            }
            authRequest.addExtension((MessageExtension)fetchRequest);
            SRegRequest sRegRequest = SRegRequest.createFetchRequest();
            sRegRequest.addAttribute("email", true);
            sRegRequest.addAttribute("fullname", true);
            authRequest.addExtension((MessageExtension)sRegRequest);
            response.sendRedirect(authRequest.getDestinationUrl(true));
        }
        catch (ConsumerException ce) {
            throw new OpenIdServiceException.ConsumerException(ce.getMessage(), ce);
        }
        catch (DiscoveryException de) {
            throw new OpenIdServiceException.DiscoveryException(de.getMessage(), de);
        }
        catch (MessageException me) {
            throw new OpenIdServiceException.MessageException(me.getMessage(), me);
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to communicate with OpenId provider", (Throwable)ioe);
        }
    }

    @Activate
    @Modified
    protected void activate() {
        try {
            this._consumerManager = new ConsumerManager();
            this._consumerManager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
            this._consumerManager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start consumer manager", e);
        }
    }

    protected String getFirstValue(List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    protected String getScreenName(String openId) {
        String screenName = this.normalize(openId);
        if (screenName.startsWith("http://")) {
            screenName = screenName.substring("http://".length());
        }
        if (screenName.startsWith("https://")) {
            screenName = screenName.substring("https://".length());
        }
        screenName = StringUtil.replace((String)screenName, (char[])new char[]{'/', '_'}, (char[])new char[]{'.', '.'});
        return screenName;
    }

    protected String normalize(String identity) {
        if (identity.endsWith("/")) {
            return identity.substring(0, identity.length() - 1);
        }
        return identity;
    }

    @Reference(unbind="-")
    protected void setOpenIdProviderRegistry(OpenIdProviderRegistry openIdProviderRegistry) {
        this._openIdProviderRegistry = openIdProviderRegistry;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected String[] splitFullName(String fullName) {
        if (Validator.isNull((String)fullName)) {
            return null;
        }
        int pos = fullName.indexOf(32);
        if (pos != -1 && pos + 1 < fullName.length()) {
            String[] names = new String[]{fullName.substring(0, pos), fullName.substring(pos + 1)};
            return names;
        }
        return null;
    }
}

