/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.openid.OpenId;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.security.sso.openid.configuration.OpenIdConfiguration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.sso.openid.configuration.OpenIdConfiguration"}, immediate=true, service={OpenId.class})
public class OpenIdImpl
implements OpenId {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdImpl.class);
    private ConfigurationProvider _configurationProvider;

    public boolean isEnabled(long companyId) {
        try {
            OpenIdConfiguration openIdConfiguration = (OpenIdConfiguration)this._configurationProvider.getConfiguration(OpenIdConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.sso.openid"));
            return openIdConfiguration.enabled();
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get OpenId configuration", (Throwable)ce);
            return false;
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }
}

