/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso.openid.internal.auto.login;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.openid.OpenId;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class OpenIdAutoLogin
extends BaseAutoLogin {
    private OpenId _openId;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        if (!this._openId.isEnabled(companyId)) {
            return null;
        }
        HttpSession session = httpServletRequest.getSession();
        Long userId = (Long)session.getAttribute("OPEN_ID_LOGIN");
        if (userId == null) {
            return null;
        }
        session.removeAttribute("OPEN_ID_LOGIN");
        User user = this._userLocalService.getUserById(userId.longValue());
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    @Reference(unbind="-")
    protected void setOpenId(OpenId openId) {
        this._openId = openId;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

